/**********************************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

**********************************************************************************************/
#ifndef CGARMINDBROUTE
#define CGARMINDBROUTE

#include <QObject>
#include <QPointer>
#include <QMap>
class QTabWidget;
class CToolViewDist;
class CToolViewRoute;
class CGarminRoute;
class CGpx;

/// route database
/**
    Basically routes and distance measurement objects are the same.
    Thus the route database will hold dictionaries for both types.
*/
class CGarminDBRoute : public QObject
{
    Q_OBJECT
        public:
        CGarminDBRoute(QTabWidget * parent);
        virtual ~CGarminDBRoute();

        void gainFocus(const QString& toolViewName);

        /// send routes to the device
        void uploadRoutes();

        /// remove all data
        void clear();
        /// add a new CGarminRoute object as distance measurement object
        void newDistance();
        /// add a new CGarminRoute object
        void newRoute();

        /// get access to the distance object dictionary
        const QMap<QString,CGarminRoute*>& getDistanceDict(){return distances;}
        /// get access to the distance object dictionary
        const QMap<QString,CGarminRoute*>& getRouteDict(){return routes;}

        /// get pointer to the current selected route object
        CGarminRoute * getCurrentRoute();
        /// select a distance polyline as active polyline by key
        void highlightDistance(const QString& key);
        /// select a route polyline as active polyline by key
        void highlightRoute(const QString& key);
        /// remove distances by their keys
        void removeDistances(const QStringList& keys);
        /// remove routes by their keys
        void removeRoutes(const QStringList& keys);

        void saveGPX(CGpx& gpx);

        void loadGPX(CGpx& gpx);
        signals:
        /// emitted on a distance object list change
        void sigDistListChanged();
        /// emitted on a route object list change
        void sigRouteListChanged();
        /// emitted if a registered CGarminRoute object is changed
        void sigRouteChanged();

    protected:
        /// pointer to toolview tab widget
        QPointer<QTabWidget> tab;
        /// tool view widget to display database information
        CToolViewDist * toolviewDist;
        /// tool view widget to display database information
        CToolViewRoute * toolviewRoute;

        /// dictionaries to hold all distances
        QMap<QString,CGarminRoute*> distances;
        /// dictionaries to hold all distances
        QMap<QString,CGarminRoute*> routes;

        /// pointer to the current route object
        QPointer<CGarminRoute> pRoute;
};
#endif
