import color
import pychart_util
import chart_object
import types
import object_set
import theme

_keys = {
    "width" : (pychart_util.NumType, 0, theme.default_line_width, "Width of the line, in points."),
    "color": (color.T, 0, color.default, ""),
    "dash" : (types.TupleType, 1, None,
              """The 2N'th value specifies the length of the line, 
              and 2N+1'th value specfies the length of the blank.
              None draws a solid line."""),
    "cap_style": (types.IntType, 0, 0, "Line cap style. 0: butt cap, 1: round cap, 2: projecting square cap. See also Postscript/PDF reference."),
    "join_style": (types.IntType, 0, 0, "Join style. 0: Miter join, 1: round join, 2: bevel join")
    }


class T(chart_object.T):
    keys = _keys
    def __str__(self):
        s = name_table.lookup(self)
        if s:
            return s
        return "<linestyle: width=%s, color=%s, dash=%s, cap=%d, join=%d>" \
               % (self.width, self.color, self.dash, self.cap_style, self.join_style)
    
default = T(color=color.default)
standards = object_set.T()

dash1 = 1.5,1.5  # - - - -
dash2 = 5,2,5,2  # -- -- -- --
dash3 = 1,1

black = T(color=color.black)
blackdash1 = T(color=color.black, dash=dash1)
blackdash2 = T(color=color.black, dash=dash2)

gray7 = T(color=color.gray7)
gray7dash1 = T(color=color.gray7, dash=dash1)
gray7dash2 = T(color=color.gray7, dash=dash2)

gray1 = T(color=color.gray1)
gray1dash1 = T(color=color.gray1, dash=dash1)
gray1dash2 = T(color=color.gray1, dash=dash2)

gray5 = T(color=color.gray5)
gray5dash1 = T(color=color.gray5, dash=dash1)
gray5dash2 = T(color=color.gray5, dash=dash2)

gray9 = T(color=color.gray9)
gray9dash1 = T(color=color.gray9, dash=dash1)
gray9dash2 = T(color=color.gray9, dash=dash2)

gray3 = T(color=color.gray3)
gray3dash1 = T(color=color.gray3, dash=dash1)
gray3dash2 = T(color=color.gray3, dash=dash2)

gray7dash3 = T(color=color.gray7, dash=dash3)
gray1dash3 = T(color=color.gray1, dash=dash3)
gray5dash3 = T(color=color.gray5, dash=dash3)
gray9dash3 = T(color=color.gray9, dash=dash3)

white = T(color=color.white)
default = black

if theme.use_color:
    red = T(color=color.red)
    dark_blue = T(color=color.dark_blue)
    dark_sea_green = T(color=color.dark_sea_green)
    dark_khaki = T(color = color.dark_khaki)
    
    reddash1 = T(color=color.red, dash=dash1)
    dark_bluedash1 = T(color=color.dark_blue, dash=dash1)
    dark_sea_greendash1 = T(color=color.dark_sea_green, dash=dash1)
    dark_khakidash1 = T(color=color.dark_khaki, dash=dash1)
    
    reddash2 = T(color=color.red, dash=dash2)
    dark_bluedash2 = T(color=color.dark_blue, dash=dash2)
    dark_sea_greendash2 = T(color=color.dark_sea_green, dash=dash2)
    dark_khakidash2 = T(color=color.dark_khaki, dash=dash2)

    standards.add(black, red, dark_blue, gray7, dark_sea_green, dark_khaki, gray3,
                  blackdash1, reddash1, dark_bluedash1, gray7dash1,
                  dark_sea_greendash1, dark_khakidash1, gray3dash1,
                  blackdash2, reddash2, dark_bluedash2, gray7dash2,
                  dark_sea_greendash2, dark_khakidash2, gray3dash2)

else:
    standards.add(black, blackdash1, blackdash2,
                  gray7, gray7dash1, gray7dash2,
                  gray1, gray1dash1, gray1dash2,
                  gray5, gray5dash1, gray5dash2,
                  gray9, gray9dash1, gray9dash2,
                  gray3, gray3dash1, gray3dash2,
                  gray7dash3, gray1dash3, gray5dash3, gray9dash3)

name_table = pychart_util.symbol_lookup_table(globals(), standards)

