import chart_object
import object_set
import types
import theme
import pychart_util

blackify_colors = 1

class T(chart_object.T):
    keys={
        "r" : (pychart_util.NumType, 0, 0.0, "The intensity of red. The value is between 0 and 1."),
        "g" : (pychart_util.NumType, 0, 0.0, "The intensity of green. The value is between 0 and 1."),
        "b" : (pychart_util.NumType, 0, 0.0, "The intensity of blue. The value is between 0 and 1.")
        }
    def __str__(self):
        s = name_table.lookup(self)
        if s:
            return s
        if self.r == self.g and self.r == self.b:
            return "<grayscale %f>" % self.r
        else:
            return "<color:r=%f,g=%f,b=%f>" % (self.r, self.g, self.b)
        
standards = object_set.T()

def gray_scale(x):
    return T(r = x, g = x, b = x)

def __gray_scale(x):
    global standards
    c = T(r = x, g = x, b = x)
    standards.add(c)
    return c

def __non_gray(r, g, b):
    global standards
    if (r!=g or r != b) and not theme.use_color and blackify_colors:
        return T(r=0,g=0,b=0)
    else:
        c = T(r = r, g = g, b = b)
        standards.add(c)
        return c
    
black = __gray_scale(0.0)
gray5 = __gray_scale(0.5)
gray1 = __gray_scale(0.1)
gray7 = __gray_scale(0.7)
gray3 = __gray_scale(0.3)
gray9 = __gray_scale(0.9)
white = __gray_scale(1.0)

default = black

snow = __non_gray(r=1, g=0.980392156862745, b=0.980392156862745)
ghost_white = __non_gray(r=0.972549019607843, g=0.972549019607843, b=1)
white_smoke = __non_gray(r=0.96078431372549, g=0.96078431372549, b=0.96078431372549)
gainsboro = __non_gray(r=0.862745098039216, g=0.862745098039216, b=0.862745098039216)
floral_white = __non_gray(r=1, g=0.980392156862745, b=0.941176470588235)
old_lace = __non_gray(r=0.992156862745098, g=0.96078431372549, b=0.901960784313726)
linen = __non_gray(r=0.980392156862745, g=0.941176470588235, b=0.901960784313726)
antique_white = __non_gray(r=0.980392156862745, g=0.92156862745098, b=0.843137254901961)
papaya_whip = __non_gray(r=1, g=0.937254901960784, b=0.835294117647059)
blanched_almond = __non_gray(r=1, g=0.92156862745098, b=0.803921568627451)
bisque = __non_gray(r=1, g=0.894117647058824, b=0.768627450980392)
peach_puff = __non_gray(r=1, g=0.854901960784314, b=0.725490196078431)
navajo_white = __non_gray(r=1, g=0.870588235294118, b=0.67843137254902)
moccasin = __non_gray(r=1, g=0.894117647058824, b=0.709803921568627)
cornsilk = __non_gray(r=1, g=0.972549019607843, b=0.862745098039216)
ivory = __non_gray(r=1, g=1, b=0.941176470588235)
lemon_chiffon = __non_gray(r=1, g=0.980392156862745, b=0.803921568627451)
seashell = __non_gray(r=1, g=0.96078431372549, b=0.933333333333333)
honeydew = __non_gray(r=0.941176470588235, g=1, b=0.941176470588235)
mint_cream = __non_gray(r=0.96078431372549, g=1, b=0.980392156862745)
azure = __non_gray(r=0.941176470588235, g=1, b=1)
alice_blue = __non_gray(r=0.941176470588235, g=0.972549019607843, b=1)
lavender = __non_gray(r=0.901960784313726, g=0.901960784313726, b=0.980392156862745)
lavender_blush = __non_gray(r=1, g=0.941176470588235, b=0.96078431372549)
misty_rose = __non_gray(r=1, g=0.894117647058824, b=0.882352941176471)
cornflower_blue = __non_gray(r=0.392156862745098, g=0.584313725490196, b=0.929411764705882)
slate_blue = __non_gray(r=0.415686274509804, g=0.352941176470588, b=0.803921568627451)
medium_slate_blue = __non_gray(r=0.482352941176471, g=0.407843137254902, b=0.933333333333333)
light_slate_blue = __non_gray(r=0.517647058823529, g=0.43921568627451, b=1)
sky_blue = __non_gray(r=0.529411764705882, g=0.807843137254902, b=0.92156862745098)
light_sky_blue = __non_gray(r=0.529411764705882, g=0.807843137254902, b=0.980392156862745)
light_steel_blue = __non_gray(r=0.690196078431373, g=0.768627450980392, b=0.870588235294118)
light_blue = __non_gray(r=0.67843137254902, g=0.847058823529412, b=0.901960784313726)
powder_blue = __non_gray(r=0.690196078431373, g=0.87843137254902, b=0.901960784313726)
pale_turquoise = __non_gray(r=0.686274509803922, g=0.933333333333333, b=0.933333333333333)
light_cyan = __non_gray(r=0.87843137254902, g=1, b=1)
medium_aquamarine = __non_gray(r=0.4, g=0.803921568627451, b=0.666666666666667)
aquamarine = __non_gray(r=0.498039215686275, g=1, b=0.831372549019608)
dark_sea_green = __non_gray(r=0.56078431372549, g=0.737254901960784, b=0.56078431372549)
pale_green = __non_gray(r=0.596078431372549, g=0.984313725490196, b=0.596078431372549)
lawn_green = __non_gray(r=0.486274509803922, g=0.988235294117647, b=0)
chartreuse = __non_gray(r=0.498039215686275, g=1, b=0)
green_yellow = __non_gray(r=0.67843137254902, g=1, b=0.184313725490196)
yellow_green = __non_gray(r=0.603921568627451, g=0.803921568627451, b=0.196078431372549)
olive_drab = __non_gray(r=0.419607843137255, g=0.556862745098039, b=0.137254901960784)
dark_khaki = __non_gray(r=0.741176470588235, g=0.717647058823529, b=0.419607843137255)
khaki = __non_gray(r=0.941176470588235, g=0.901960784313726, b=0.549019607843137)
pale_goldenrod = __non_gray(r=0.933333333333333, g=0.909803921568627, b=0.666666666666667)
light_goldenrod_yellow = __non_gray(r=0.980392156862745, g=0.980392156862745, b=0.823529411764706)
light_yellow = __non_gray(r=1, g=1, b=0.87843137254902)
yellow = __non_gray(r=1, g=1, b=0)
gold = __non_gray(r=1, g=0.843137254901961, b=0)
light_goldenrod = __non_gray(r=0.933333333333333, g=0.866666666666667, b=0.509803921568627)
goldenrod = __non_gray(r=0.854901960784314, g=0.647058823529412, b=0.125490196078431)
dark_goldenrod = __non_gray(r=0.72156862745098, g=0.525490196078431, b=0.0431372549019608)
rosy_brown = __non_gray(r=0.737254901960784, g=0.56078431372549, b=0.56078431372549)
indian_red = __non_gray(r=0.803921568627451, g=0.36078431372549, b=0.36078431372549)
saddle_brown = __non_gray(r=0.545098039215686, g=0.270588235294118, b=0.0745098039215686)
sienna = __non_gray(r=0.627450980392157, g=0.32156862745098, b=0.176470588235294)
peru = __non_gray(r=0.803921568627451, g=0.52156862745098, b=0.247058823529412)
burlywood = __non_gray(r=0.870588235294118, g=0.72156862745098, b=0.529411764705882)
beige = __non_gray(r=0.96078431372549, g=0.96078431372549, b=0.862745098039216)
wheat = __non_gray(r=0.96078431372549, g=0.870588235294118, b=0.701960784313725)
sandy_brown = __non_gray(r=0.956862745098039, g=0.643137254901961, b=0.376470588235294)
tan = __non_gray(r=0.823529411764706, g=0.705882352941177, b=0.549019607843137)
chocolate = __non_gray(r=0.823529411764706, g=0.411764705882353, b=0.117647058823529)
firebrick = __non_gray(r=0.698039215686274, g=0.133333333333333, b=0.133333333333333)
brown = __non_gray(r=0.647058823529412, g=0.164705882352941, b=0.164705882352941)
dark_salmon = __non_gray(r=0.913725490196078, g=0.588235294117647, b=0.47843137254902)
salmon = __non_gray(r=0.980392156862745, g=0.501960784313725, b=0.447058823529412)
light_salmon = __non_gray(r=1, g=0.627450980392157, b=0.47843137254902)
orange = __non_gray(r=1, g=0.647058823529412, b=0)
dark_orange = __non_gray(r=1, g=0.549019607843137, b=0)
coral = __non_gray(r=1, g=0.498039215686275, b=0.313725490196078)
light_coral = __non_gray(r=0.941176470588235, g=0.501960784313725, b=0.501960784313725)
tomato = __non_gray(r=1, g=0.388235294117647, b=0.27843137254902)
orange_red = __non_gray(r=1, g=0.270588235294118, b=0)
red = __non_gray(r=1, g=0, b=0)
hot_pink = __non_gray(r=1, g=0.411764705882353, b=0.705882352941177)
deep_pink = __non_gray(r=1, g=0.0784313725490196, b=0.576470588235294)
pink = __non_gray(r=1, g=0.752941176470588, b=0.796078431372549)
light_pink = __non_gray(r=1, g=0.713725490196078, b=0.756862745098039)
pale_violet_red = __non_gray(r=0.858823529411765, g=0.43921568627451, b=0.576470588235294)
maroon = __non_gray(r=0.690196078431373, g=0.188235294117647, b=0.376470588235294)
medium_violet_red = __non_gray(r=0.780392156862745, g=0.0823529411764706, b=0.52156862745098)
violet_red = __non_gray(r=0.815686274509804, g=0.125490196078431, b=0.564705882352941)
magenta = __non_gray(r=1, g=0, b=1)
violet = __non_gray(r=0.933333333333333, g=0.509803921568627, b=0.933333333333333)
plum = __non_gray(r=0.866666666666667, g=0.627450980392157, b=0.866666666666667)
orchid = __non_gray(r=0.854901960784314, g=0.43921568627451, b=0.83921568627451)
medium_orchid = __non_gray(r=0.729411764705882, g=0.333333333333333, b=0.827450980392157)
dark_orchid = __non_gray(r=0.6, g=0.196078431372549, b=0.8)
dark_violet = __non_gray(r=0.580392156862745, g=0, b=0.827450980392157)
blue_violet = __non_gray(r=0.541176470588235, g=0.168627450980392, b=0.886274509803922)
purple = __non_gray(r=0.627450980392157, g=0.125490196078431, b=0.941176470588235)
medium_purple = __non_gray(r=0.576470588235294, g=0.43921568627451, b=0.858823529411765)
thistle = __non_gray(r=0.847058823529412, g=0.749019607843137, b=0.847058823529412)
snow1 = __non_gray(r=1, g=0.980392156862745, b=0.980392156862745)
snow2 = __non_gray(r=0.933333333333333, g=0.913725490196078, b=0.913725490196078)
snow3 = __non_gray(r=0.803921568627451, g=0.788235294117647, b=0.788235294117647)
snow4 = __non_gray(r=0.545098039215686, g=0.537254901960784, b=0.537254901960784)
seashell1 = __non_gray(r=1, g=0.96078431372549, b=0.933333333333333)
seashell2 = __non_gray(r=0.933333333333333, g=0.898039215686275, b=0.870588235294118)
seashell3 = __non_gray(r=0.803921568627451, g=0.772549019607843, b=0.749019607843137)
seashell4 = __non_gray(r=0.545098039215686, g=0.525490196078431, b=0.509803921568627)
bisque1 = __non_gray(r=1, g=0.894117647058824, b=0.768627450980392)
bisque2 = __non_gray(r=0.933333333333333, g=0.835294117647059, b=0.717647058823529)
bisque3 = __non_gray(r=0.803921568627451, g=0.717647058823529, b=0.619607843137255)
bisque4 = __non_gray(r=0.545098039215686, g=0.490196078431373, b=0.419607843137255)
cornsilk1 = __non_gray(r=1, g=0.972549019607843, b=0.862745098039216)
cornsilk2 = __non_gray(r=0.933333333333333, g=0.909803921568627, b=0.803921568627451)
cornsilk3 = __non_gray(r=0.803921568627451, g=0.784313725490196, b=0.694117647058824)
cornsilk4 = __non_gray(r=0.545098039215686, g=0.533333333333333, b=0.470588235294118)
ivory1 = __non_gray(r=1, g=1, b=0.941176470588235)
ivory2 = __non_gray(r=0.933333333333333, g=0.933333333333333, b=0.87843137254902)
ivory3 = __non_gray(r=0.803921568627451, g=0.803921568627451, b=0.756862745098039)
ivory4 = __non_gray(r=0.545098039215686, g=0.545098039215686, b=0.513725490196078)
honeydew1 = __non_gray(r=0.941176470588235, g=1, b=0.941176470588235)
honeydew2 = __non_gray(r=0.87843137254902, g=0.933333333333333, b=0.87843137254902)
honeydew3 = __non_gray(r=0.756862745098039, g=0.803921568627451, b=0.756862745098039)
honeydew4 = __non_gray(r=0.513725490196078, g=0.545098039215686, b=0.513725490196078)
azure1 = __non_gray(r=0.941176470588235, g=1, b=1)
azure2 = __non_gray(r=0.87843137254902, g=0.933333333333333, b=0.933333333333333)
azure3 = __non_gray(r=0.756862745098039, g=0.803921568627451, b=0.803921568627451)
azure4 = __non_gray(r=0.513725490196078, g=0.545098039215686, b=0.545098039215686)
aquamarine1 = __non_gray(r=0.498039215686275, g=1, b=0.831372549019608)
aquamarine2 = __non_gray(r=0.462745098039216, g=0.933333333333333, b=0.776470588235294)
aquamarine3 = __non_gray(r=0.4, g=0.803921568627451, b=0.666666666666667)
chartreuse1 = __non_gray(r=0.498039215686275, g=1, b=0)
chartreuse2 = __non_gray(r=0.462745098039216, g=0.933333333333333, b=0)
chartreuse3 = __non_gray(r=0.4, g=0.803921568627451, b=0)
khaki1 = __non_gray(r=1, g=0.964705882352941, b=0.56078431372549)
khaki2 = __non_gray(r=0.933333333333333, g=0.901960784313726, b=0.52156862745098)
khaki3 = __non_gray(r=0.803921568627451, g=0.776470588235294, b=0.450980392156863)
khaki4 = __non_gray(r=0.545098039215686, g=0.525490196078431, b=0.305882352941176)
yellow1 = __non_gray(r=1, g=1, b=0)
yellow2 = __non_gray(r=0.933333333333333, g=0.933333333333333, b=0)
yellow3 = __non_gray(r=0.803921568627451, g=0.803921568627451, b=0)
yellow4 = __non_gray(r=0.545098039215686, g=0.545098039215686, b=0)
gold1 = __non_gray(r=1, g=0.843137254901961, b=0)
gold2 = __non_gray(r=0.933333333333333, g=0.788235294117647, b=0)
gold3 = __non_gray(r=0.803921568627451, g=0.67843137254902, b=0)
gold4 = __non_gray(r=0.545098039215686, g=0.458823529411765, b=0)
goldenrod1 = __non_gray(r=1, g=0.756862745098039, b=0.145098039215686)
goldenrod2 = __non_gray(r=0.933333333333333, g=0.705882352941177, b=0.133333333333333)
goldenrod3 = __non_gray(r=0.803921568627451, g=0.607843137254902, b=0.113725490196078)
goldenrod4 = __non_gray(r=0.545098039215686, g=0.411764705882353, b=0.0784313725490196)
sienna1 = __non_gray(r=1, g=0.509803921568627, b=0.27843137254902)
sienna2 = __non_gray(r=0.933333333333333, g=0.474509803921569, b=0.258823529411765)
sienna3 = __non_gray(r=0.803921568627451, g=0.407843137254902, b=0.223529411764706)
sienna4 = __non_gray(r=0.545098039215686, g=0.27843137254902, b=0.149019607843137)
burlywood1 = __non_gray(r=1, g=0.827450980392157, b=0.607843137254902)
burlywood2 = __non_gray(r=0.933333333333333, g=0.772549019607843, b=0.568627450980392)
burlywood3 = __non_gray(r=0.803921568627451, g=0.666666666666667, b=0.490196078431373)
burlywood4 = __non_gray(r=0.545098039215686, g=0.450980392156863, b=0.333333333333333)
wheat1 = __non_gray(r=1, g=0.905882352941176, b=0.729411764705882)
wheat2 = __non_gray(r=0.933333333333333, g=0.847058823529412, b=0.682352941176471)
wheat3 = __non_gray(r=0.803921568627451, g=0.729411764705882, b=0.588235294117647)
wheat4 = __non_gray(r=0.545098039215686, g=0.494117647058824, b=0.4)
tan1 = __non_gray(r=1, g=0.647058823529412, b=0.309803921568627)
tan2 = __non_gray(r=0.933333333333333, g=0.603921568627451, b=0.286274509803922)
tan3 = __non_gray(r=0.803921568627451, g=0.52156862745098, b=0.247058823529412)
tan4 = __non_gray(r=0.545098039215686, g=0.352941176470588, b=0.168627450980392)
chocolate1 = __non_gray(r=1, g=0.498039215686275, b=0.141176470588235)
chocolate2 = __non_gray(r=0.933333333333333, g=0.462745098039216, b=0.129411764705882)
chocolate3 = __non_gray(r=0.803921568627451, g=0.4, b=0.113725490196078)
chocolate4 = __non_gray(r=0.545098039215686, g=0.270588235294118, b=0.0745098039215686)
firebrick1 = __non_gray(r=1, g=0.188235294117647, b=0.188235294117647)
firebrick2 = __non_gray(r=0.933333333333333, g=0.172549019607843, b=0.172549019607843)
firebrick3 = __non_gray(r=0.803921568627451, g=0.149019607843137, b=0.149019607843137)
firebrick4 = __non_gray(r=0.545098039215686, g=0.101960784313725, b=0.101960784313725)
brown1 = __non_gray(r=1, g=0.250980392156863, b=0.250980392156863)
brown2 = __non_gray(r=0.933333333333333, g=0.231372549019608, b=0.231372549019608)
brown3 = __non_gray(r=0.803921568627451, g=0.2, b=0.2)
brown4 = __non_gray(r=0.545098039215686, g=0.137254901960784, b=0.137254901960784)
salmon1 = __non_gray(r=1, g=0.549019607843137, b=0.411764705882353)
salmon2 = __non_gray(r=0.933333333333333, g=0.509803921568627, b=0.384313725490196)
salmon3 = __non_gray(r=0.803921568627451, g=0.43921568627451, b=0.329411764705882)
salmon4 = __non_gray(r=0.545098039215686, g=0.298039215686275, b=0.223529411764706)
orange1 = __non_gray(r=1, g=0.647058823529412, b=0)
orange2 = __non_gray(r=0.933333333333333, g=0.603921568627451, b=0)
orange3 = __non_gray(r=0.803921568627451, g=0.52156862745098, b=0)
orange4 = __non_gray(r=0.545098039215686, g=0.352941176470588, b=0)
coral1 = __non_gray(r=1, g=0.447058823529412, b=0.337254901960784)
coral2 = __non_gray(r=0.933333333333333, g=0.415686274509804, b=0.313725490196078)
coral3 = __non_gray(r=0.803921568627451, g=0.356862745098039, b=0.270588235294118)
coral4 = __non_gray(r=0.545098039215686, g=0.243137254901961, b=0.184313725490196)
tomato1 = __non_gray(r=1, g=0.388235294117647, b=0.27843137254902)
tomato2 = __non_gray(r=0.933333333333333, g=0.36078431372549, b=0.258823529411765)
tomato3 = __non_gray(r=0.803921568627451, g=0.309803921568627, b=0.223529411764706)
tomato4 = __non_gray(r=0.545098039215686, g=0.211764705882353, b=0.149019607843137)
red1 = __non_gray(r=1, g=0, b=0)
red2 = __non_gray(r=0.933333333333333, g=0, b=0)
red3 = __non_gray(r=0.803921568627451, g=0, b=0)
red4 = __non_gray(r=0.545098039215686, g=0, b=0)
pink1 = __non_gray(r=1, g=0.709803921568627, b=0.772549019607843)
pink2 = __non_gray(r=0.933333333333333, g=0.662745098039216, b=0.72156862745098)
pink3 = __non_gray(r=0.803921568627451, g=0.568627450980392, b=0.619607843137255)
pink4 = __non_gray(r=0.545098039215686, g=0.388235294117647, b=0.423529411764706)
maroon1 = __non_gray(r=1, g=0.203921568627451, b=0.701960784313725)
maroon2 = __non_gray(r=0.933333333333333, g=0.188235294117647, b=0.654901960784314)
maroon3 = __non_gray(r=0.803921568627451, g=0.16078431372549, b=0.564705882352941)
maroon4 = __non_gray(r=0.545098039215686, g=0.109803921568627, b=0.384313725490196)
magenta1 = __non_gray(r=1, g=0, b=1)
magenta2 = __non_gray(r=0.933333333333333, g=0, b=0.933333333333333)
magenta3 = __non_gray(r=0.803921568627451, g=0, b=0.803921568627451)
magenta4 = __non_gray(r=0.545098039215686, g=0, b=0.545098039215686)
orchid1 = __non_gray(r=1, g=0.513725490196078, b=0.980392156862745)
orchid2 = __non_gray(r=0.933333333333333, g=0.47843137254902, b=0.913725490196078)
orchid3 = __non_gray(r=0.803921568627451, g=0.411764705882353, b=0.788235294117647)
orchid4 = __non_gray(r=0.545098039215686, g=0.27843137254902, b=0.537254901960784)
plum1 = __non_gray(r=1, g=0.733333333333333, b=1)
plum2 = __non_gray(r=0.933333333333333, g=0.682352941176471, b=0.933333333333333)
plum3 = __non_gray(r=0.803921568627451, g=0.588235294117647, b=0.803921568627451)
plum4 = __non_gray(r=0.545098039215686, g=0.4, b=0.545098039215686)
purple1 = __non_gray(r=0.607843137254902, g=0.188235294117647, b=1)
purple2 = __non_gray(r=0.568627450980392, g=0.172549019607843, b=0.933333333333333)
purple3 = __non_gray(r=0.490196078431373, g=0.149019607843137, b=0.803921568627451)
thistle1 = __non_gray(r=1, g=0.882352941176471, b=1)
thistle2 = __non_gray(r=0.933333333333333, g=0.823529411764706, b=0.933333333333333)
thistle3 = __non_gray(r=0.803921568627451, g=0.709803921568627, b=0.803921568627451)
thistle4 = __non_gray(r=0.545098039215686, g=0.482352941176471, b=0.545098039215686)
dark_blue = __non_gray(r=0, g=0, b=0.545098039215686)
dark_cyan = __non_gray(r=0, g=0.545098039215686, b=0.545098039215686)
dark_magenta = __non_gray(r=0.545098039215686, g=0, b=0.545098039215686)
dark_red = __non_gray(r=0.545098039215686, g=0, b=0)
light_green = __non_gray(r=0.564705882352941, g=0.933333333333333, b=0.564705882352941)

name_table = pychart_util.symbol_lookup_table(globals(), standards)
