from pychart import *
import whrandom

def randomdata():
    data = []
    for i in range(0, 30):
        data.append((whrandom.random() * 1000, whrandom.random() * 1000))
    return data

chart_object.set_defaults(line_plot.T, line_style=None)

tick1 = tick_mark.Circle(size=2)
tick2 = tick_mark.Circle(size=2, fill_style=fill_style.black)
xaxis = axis.X(label="foo", format="/a-60{}%d")
yaxis = axis.Y(label="bar")

ar = area.T(x_axis=xaxis, y_axis=yaxis, 
            legend = legend.T(loc=(350, 50)), loc = (0, 0))

ar.add_plot(line_plot.T(label="plot1", data=randomdata(), tick_mark=tick1))
ar.add_plot(line_plot.T(label="plot2", data=randomdata(), tick_mark=tick2))
ar.draw()

xaxis = axis.X(label="foo", format="/a-30{}%d",
               grid_interval=10, grid_style=line_style.gray7dash3)
yaxis = axis.Y(label="bar")
ar = area.T(x_axis=xaxis, y_axis=yaxis, 
            x_coord_system='log', y_coord_system='log', loc = (200, 0))

ar.add_plot(line_plot.T(label="plot1", data=randomdata(), tick_mark=tick1))
ar.add_plot(line_plot.T(label="plot2", data=randomdata(), tick_mark=tick2))
ar.draw()

