import sys
import types
import re
import os.path
from pychart import *

oldstdout = sys.stdout
if os.path.exists("/dev/null"):
    sys.stdout = open("/dev/null", "w")

modules = {}
values = []

sys.stdout = oldstdout
g = globals()
for mod in g.keys():
    val = g[mod]
    if type(val) == types.ModuleType:
        dic = {}
        modules[mod] = dic
        for name in val.__dict__.keys():
            v = val.__dict__[name]
            if name[0] != '_':
                values.append((v, name))
            if type(v) == types.ClassType and issubclass(v, chart_object.T):
                dic[name] = v

def stringify_type(t):
    s = str(t)
    
    if t == pychart_util.AnyType:
        return "any"
    if t == pychart_util.ShadowType:
        return "(xoff,yoff,fill)"
    elif t == pychart_util.NumType:
        return "number"
    elif t == pychart_util.CoordType:
        return "(x,y)"
    elif t == pychart_util.CoordOrNoneType:
        return "(x,y) or None"
    elif t == pychart_util.TextAlignType:
        return "'R'/'L'/'C'/None"
    elif t == pychart_util.FormatType:
        return "printf format string"
    elif t == pychart_util.IntervalType:
        return "Number or function"
    elif t == area.CoordSystemType:
        return "linear /log /category"
    
    mo= re.match("<type '([^']+)'>", s)
    if mo:
        s = mo.group(1)
    mo = re.match("pychart\\.(.*)", s)
    if mo:
        s = mo.group(1)
    return s

def stringify_value(val):
    if type(val) == types.IntType or type(val) == types.StringType:
        return val
    if val == None:
        return "None"
    if type(val) == types.ListType:
        return map(stringify_value, val)
    for pair in values:
        if pair[0] == val:
            return pair[1]
    return val

