import string
import canvas
import tick_mark
import font
import line_style
import color
import fill_style
import chart_object
import pychart_util
import types

class Entry(chart_object.T):
    keys = {"line_len" : (pychart_util.NumType, 0, 10,
                          "Length of the sample line for line plots."),
            "rect_size" : (pychart_util.NumType, 0, 7,
                           "Size of the sample 'blob' for bar range charts."),
            "tick_mark": (tick_mark.Base, 1, None),
            "line_style": (line_style.T, 1, None),
            "fill_style": (fill_style.T, 1, None),
            "label": (types.StringType, 0, "???"),
            }
    def label_width(self):
        return font.text_width(" " + self.label)
    def sample_width(self):
        w = 0
        if self.fill_style != None:
            w = w + self.line_len
        elif self.line_style != None:
            w = w + self.line_len
        elif self.tick_mark != None:
            w = w + self.tick_mark.size
        return w
    def height(self):
        return (font.text_height(self.label))[0]
    
    def draw(self, ar, x_tick, x_label, y):
        "Draw a legend entry. X_TICK and X_LABEL are the X location \
        (in points) of where the sample and label are drawn."
        
        nr_lines = len(string.split(self.label, "\n"))
        text_height = font.text_height(self.label)[0]
        line_height = text_height / float(nr_lines)
        y_center = y + text_height - line_height/1.5
            
        if self.fill_style != None:
            canvas.rectangle(self.line_style, self.fill_style,
                             x_tick, y_center - self.rect_size/2.0,
                             x_tick + self.rect_size,
                             y_center + self.rect_size/2.0)
        elif self.line_style != None:
            canvas.line(self.line_style, x_tick, y_center,
                        x_tick + self.line_len, y_center)
            if self.tick_mark != None:
                self.tick_mark.draw(x_tick + self.line_len/2.0, y_center)
        elif self.tick_mark != None:
            self.tick_mark.draw(x_tick, y_center)
            
        canvas.show(x_label, y, self.label)

class T(chart_object.T):
    keys = {
        "inter_row_sep": (pychart_util.NumType, 0, 0,
                          "Space between each entry in the legend."),
        "frame_line_style": (line_style.T, 1, line_style.default, ""),
        "frame_fill_style": (fill_style.T, 0, fill_style.white, ""),
        "top_fudge": (pychart_util.NumType, 0, 0,
                      "Amount of space above the first line."),
        "bottom_fudge": (pychart_util.NumType, 0, 3,
                         "Amount of space below the last line."),
        "left_fudge": (pychart_util.NumType, 0, 5,
                       "Amount of space left of the legend."),
        "right_fudge": (pychart_util.NumType, 0, 5,
                        "Amount of space right of the legend."),
        "loc": (pychart_util.CoordType, 1, None,
                "Bottom-left corner of the legend."),
	"shadow": (pychart_util.ShadowType, 1, None, pychart_util.shadow_desc)

        }
    def draw(self, ar, entries):
        if not self.loc:
            x = ar.loc[0] + ar.size[0] * 1.1
            y = ar.loc[1]
        else:
            x = self.loc[0]
            y = self.loc[1]
        
        ymin = y
	max_label_width = 0
        max_sample_width = 0
        for l in entries:
            max_label_width = max(l.label_width(), max_label_width)
            max_sample_width = max(l.sample_width(), max_sample_width)
            y = y + l.height() + self.inter_row_sep
        ymax = y

	canvas.rectangle(self.frame_line_style, self.frame_fill_style,
                         x - self.left_fudge,	
                         ymin - self.bottom_fudge,	
                         x+max_label_width+max_sample_width+self.right_fudge,
                         ymax + self.top_fudge,
			 self.shadow)

        for l in entries:
            thisx = x
            y = y - l.height() + self.inter_row_sep
            l.draw(ar, x, x + max_sample_width, y)




