import pychart_util
import color
import line_style
import chart_object
import object_set
import types
import canvas
import theme
from scaling import *

_keys = {
    "bgcolor" : (color.T, 1, color.white, "The background color."),
    "line_style": (line_style.T, 1, line_style.default,
                   pychart_util.line_desc),
    "line_interval": (pychart_util.NumType, 0, 3,
                      "The interval between successive stitch lines.")
    }

class T(chart_object.T):
    keys = _keys
    def __str__(self):
        s = name_table.lookup(self)
        if s:
            return s
        return "<fillstyle: bg=%s line=%s interval=%s>" % \
               (self.bgcolor, self.line_style, self.line_interval)

class Plain(T):
    def draw(self, x1, y1, x2, y2):
        pass
    
class Diag(T):
    def draw(self, x1, y1, x2, y2):
        line_width = self.line_style.width
        interval = self.line_interval * 1.414
        x1 = x1 - line_width
        y1 = y1 - line_width
        x2 = x2 + line_width
        y2 = y2 + line_width
        height = y2 - y1
        width = x2 - x2
        len = max(height, width)
        curx = x1 - len
        while curx < x2:
            canvas.line(self.line_style, curx, y1, curx+len, y1+len)
            curx = curx + interval

class Rdiag(T):
    def draw(self, x1, y1, x2, y2):    
        line_width = self.line_style.width
        interval = self.line_interval * 1.414

        x1 = x1 - line_width
        y1 = y1 - line_width
        x2 = x2 + line_width
        y2 = y2 + line_width
        height = y2 - y1
        width = x2 - x2
        len = max(height, width)
        curx = x1
        endx = x2 + len
        while curx < endx:
            canvas.line(self.line_style, curx, y1, curx-len, y1+len)
            curx = curx + interval

class Vert(T):
    def draw(self, x1, y1, x2, y2):    
        interval = self.line_interval
        curx = x1
        while curx < x2:
            canvas.line(self.line_style, curx, y1, curx, y2)
            curx = curx + interval
            
class Horiz(T):
    def draw(self, x1, y1, x2, y2):
        interval = self.line_interval
        cury = y1
        while cury < y2:
            canvas.line(self.line_style, x1, cury, x2, cury)            
            cury = cury + interval
            
class Stitch(T):
    def draw(self, x1, y1, x2, y2):
        interval = self.line_interval
        cury = y1
        while cury < y2:
            canvas.line(self.line_style, x1, cury, x2, cury)
            cury = cury + interval
        curx = x1
        while curx < x2:
            canvas.line(self.line_style, curx, y1, curx, y2)
            curx = curx + interval

class Wave(T):
    def draw(self, x1, y1, x2, y2):
        x1 = xscale(x1)
        x2 = xscale(x2)
        y1 = yscale(y1)
        y2 = yscale(y2)
        line_width = nscale(self.line_style.width)
        interval = nscale(self.line_interval)
        
        canvas.out.set_line_style(self.line_style)        
        x1 = x1 - line_width
        x2 = x2 + line_width
        cury = y1
        half = interval/2.0
        while cury < y2:
            curx = x1
            canvas.out.newpath()
            canvas.out.moveto(curx, cury)
            while curx < x2:
                canvas.out.lineto(curx + half, cury + half)
                canvas.out.lineto(curx + interval, cury)
                curx = curx + interval
            canvas.out.stroke()
            cury = cury + interval

class Vwave(T):
    def draw(self, x1, y1, x2, y2):
        x1 = xscale(x1)
        x2 = xscale(x2)
        y1 = yscale(y1)
        y2 = yscale(y2)
        line_width = nscale(self.line_style.width)
        interval = nscale(self.line_interval)
        
        canvas.out.set_line_style(self.line_style)
        y1 = y1 - line_width
        y2 = y2 + line_width
        curx = x1
        half = interval/2.0
        while curx < x2:
            cury = y1
            canvas.out.newpath()
            canvas.out.moveto(curx, cury)
            while cury < y2:
                canvas.out.lineto(curx + half, cury + half)
                canvas.out.lineto(curx, cury + interval)
                cury = cury + interval
            canvas.out.stroke()
            curx = curx + interval        

class Lines(T):
    def draw(self, x1, y1, x2, y2):
        interval = nscale(self.line_interval)
        cury = y1
        j = 0
        while cury < y2:
            curx = x1
            if j % 2 == 1:
                curx = curx + interval/2.0
            while curx < x2:
                canvas.line(self.line_style, curx, cury,
                            curx+interval/2.0, cury)
                curx = curx + interval * 1.5
            j = j + 1
            cury = cury + interval

default = Plain()

standards = object_set.T()

def __intern(style):
    standards.add(style)
    return style

black = __intern(Plain(bgcolor=color.gray_scale(0.0), line_style=None))

if not theme.use_color:
    gray7 = __intern(Plain(bgcolor=color.gray_scale(0.7), line_style=None))
    diag = __intern(Diag(line_style=line_style.T(cap_style=2)))
    gray3 = __intern(Plain(bgcolor=color.gray_scale(0.3), line_style=None))
    rdiag = __intern(Rdiag(line_style=line_style.T(cap_style=2)))
    gray1 = __intern(Plain(bgcolor=color.gray_scale(0.1), line_style=None))
    diag2 = __intern(Diag(line_style=line_style.T(width=3, cap_style=2),
                          line_interval=6))
    white = __intern(Plain(bgcolor=color.gray_scale(1.0), line_style=None))
    rdiag2 = __intern(Rdiag(line_style=line_style.T(width=3, cap_style=2),
                            line_interval=6))
    vert = __intern(Vert())
    diag3 = __intern(Diag(line_style=line_style.T(width=3, color=color.gray5, cap_style=2),
                          line_interval=6))
    gray5 = __intern(Plain(bgcolor=color.gray_scale(0.5), line_style=None))
    horiz = __intern(Horiz())
    gray9 = __intern(Plain(bgcolor=color.gray_scale(0.9), line_style=None))
    rdiag3 = __intern(Rdiag(line_style=line_style.T(width=3,
                                                    color=color.gray5,
                                                    cap_style=2),
                            line_interval=6))
    
    wave = __intern(Wave(line_style=line_style.T(cap_style=2, join_style=1)))
    vwave = __intern(Vwave(line_style=line_style.T(cap_style=2, join_style=1)))
    stitch = __intern(Stitch(line_style=line_style.T(cap_style=2, join_style=1)))
    lines = __intern(Lines(line_style=line_style.T()))
else:
    red = __intern(Plain(bgcolor=color.red))
    dark_sea_green = __intern(Plain(bgcolor=color.dark_sea_green))
    aquamarine1 = __intern(Plain(bgcolor=color.aquamarine1))
    gray7 = __intern(Plain(bgcolor=color.gray_scale(0.7), line_style=None))    
    brown = __intern(Plain(bgcolor=color.brown))
    dark_orchid = __intern(Plain(bgcolor=color.dark_orchid))    
    gray5 = __intern(Plain(bgcolor=color.gray_scale(0.5), line_style=None))
    diag = __intern(Diag(line_style=line_style.T(cap_style=2)))    
    vert = __intern(Vert())
    horiz = __intern(Horiz())
    goldenrod = __intern(Plain(bgcolor=color.goldenrod))
    rdiag = __intern(Rdiag(line_style=line_style.T(cap_style=2)))
    white = __intern(Plain(bgcolor=color.gray_scale(1.0), line_style=None))    
    
name_table = pychart_util.symbol_lookup_table(globals(), standards)
