import string
import pychart_util
import copy

def __convert_item(v, typ, line):
    if typ == "a":
        try:
            i = string.atof(v)
        except ValueError: # non-number
            i = v
        return i
    elif typ == "d":
        try:
            return string.atoi(v)
        except ValueError:
            raise ValueError, "Can't convert %s to int line=%s" % (v, line)
    elif typ == "f":
        try:
            return string.atof(v)
        except ValueError:
            raise ValueError, "Can't convert %s to float line=%s" % (v, line)
    elif typ == "s":
        return v
    else:
        raise ValueError, "Unknown conversion type, type=%s, line=%s" % (typ,line)
        
def parse_line(line, delim):
    data = []
    if string.find(delim, "%") < 0:
        for item in string.split(line, delim):
            data.append(__convert_item(item, "a", line))
    else:
        id = 0 # indexes delim
        il = 0 # indexes line
        ch = 'f'
        sep = ','
        
        while id < len(delim):
            if delim[id] != '%':
                raise ValueError, "bad delimitor: '" + delim + "'"
            ch = delim[id+1]
            id = id + 2
            sep = ""
            while id < len(delim) and delim[id] != '%':
                sep = sep + delim[id]
                id = id + 1
            xx = string.split(line, sep, 1)
            data.append(__convert_item(xx[0], ch, line))
            if len(xx) >= 2:
                line = xx[1]
            else:
                line = ""
                break
                
        if line != "":
            for item in string.split(line, sep):
                data.append(__convert_item(item, ch, line))
    return data

def escape_string(str):
    return string.replace(str, "/", "//")

def extract_rows(data, *rows):
    try:
        out = []
        for r in rows:
            out.append(data[r])
        return out
    except IndexError:
        raise IndexError, "data=%s rows=%s" % (data, rows)
    return out

def extract_columns(data, *cols):
    out = []
    try:
        for r in data:
            col = []
            for c in cols:
                col.append(r[c])
            out.append(col)
    except IndexError:
        raise IndexError, "data=%s col=%s" % (data, col)        
    return out

def moving_average(data, xcol, ycol, width):
    out = []
    try:
        for i in range(0, len(data)):
            n = 0
            total = 0
            for j in range(i-width, i+width+1):
                if j >= 0 and j < len(data):
                    total = total + data[j][ycol]
                    n = n + 1
            out.append((data[i][xcol], float(total) / n))
    except IndexError:
        raise IndexError, "bad data: %s,xcol=%d,ycol=%d,width=%d" % (data,xcol,ycol,width)
    
    return out
    
def filter(func, data):
    out = []
    for r in data:
	if func(r):
	    out.append(r)
    return out

def transform(func, data):
    out = []
    for r in data:
        out.append(func(r))
    return out

def aggregate_rows(data, col):
    out = copy.deepcopy(data)
    total = 0
    for r in out:
        total = total + r[col]
        r[col] = total
    return out

def empty_line_p(s):
    return string.strip(s) == ""

def fread_csv(fp, delim = ','):
    data = []
    line = fp.readline()
    while line != "":
        if line[0] != '#' and not empty_line_p(line):
            data.append(parse_line(line, delim))
        line = fp.readline()
    return data

def read_csv(file, delim = ','):
    f = open(file)
    data = fread_csv(f, delim)
    f.close()
    return data

def read_str(delim = ',', *lines):
    data = []
    for line in lines:
        com = parse_line(line, delim)
        data.append(com)
    return data
    
def func(f, xmin, xmax, step = None):
    data = []
    x = xmin
    if not step:
        step = (xmax - xmin) / 100.0
    while x < xmax:
        data.append((x, f(x)))
        x = x + step
    return data

def __nr_data(data, col):
    nr_data = 0
    for d in data:
        nr_data = nr_data + d[col]
    return nr_data
    
def median(data, freq_col=1):
    nr_data = __nr_data(data, freq_col)
    median_idx = nr_data / 2
    i = 0
    for d in data:
        i = i + d[freq_col]
        if i >= median_idx:
            return d
    
def cut_extremes(data, cutoff_percentage, freq_col=1):
    nr_data = __nr_data(data, freq_col)
    min_idx = nr_data * cutoff_percentage / 100.0
    max_idx = nr_data * (100 - cutoff_percentage) / 100.0
    r = []
    
    i = 0
    for d in data:
        if i < min_idx:
            if i + d[freq_col] >= min_idx:
                x = copy.deepcopy(d)
                x[freq_col] = x[freq_col] - (min_idx - i)
                r.append(x)
            i = i + d[freq_col]
            continue
	elif i + d[freq_col] >= max_idx:
            if i < max_idx and i + d[freq_col] >= max_idx:
                x = copy.deepcopy(d)
                x[freq_col] = x[freq_col] - (max_idx - i)
                r.append(x)
            break
        i = i + d[freq_col]
        r.append(d)
    return r

def mean(data, val_col, freq_col):
    nr_data = 0
    sum = 0
    for d in data:
        sum = sum + d[val_col] * d[freq_col]
        nr_data = nr_data + d[freq_col]
    if nr_data == 0:
	raise IndexError, "data is empty"

    return sum / float(nr_data)

