import line_style
import legend
import axis
import pychart_util
import chart_object
import fill_style
import types
import math
import canvas

def CoordSystemType(s):
    if s == 'linear' or s == 'log' or s == 'category':
        return ""
    else:
        return s + """: Unsupported coordinate system. 
The value must be one of 'linear', 'log', or 'category'."""


# LEN: the length of the axis (in points)
# VAL: the value 
# RANGE: the min and max values of the axis
# SKIP: None or the region that should be compressed by a zigzag.
zigZagSize=30

def linear_coord_pos(len, val, range, skip):
    if skip == None:
	return len * (val - range[0]) / float(range[1]-range[0])

    sec1 = skip[0]-range[0]
    sec2 = range[1] - skip[1]
    len_low = (len - zigZagSize) * sec1 / (sec1+sec2)
    len_high = (len - zigZagSize) * sec2 / (sec1+sec2)

    if val < skip[0]:
	range_low = (range[0], skip[0])
	return linear_coord_pos(len_low, val, range_low, None)
    if val < skip[1]:
	return len_low + zigZagSize/2.0
    else:
	range_high = (skip[1], range[1])
	return len_low + zigZagSize + linear_coord_pos(len_high, val, range_high, None)

def log_coord_pos(len, val, range):
   xminl = math.log(range[0])
   xmaxl = math.log(range[1])
   if val <= 0:
       return 0
   vl = math.log(val)
   return len * (vl-xminl) / float(xmaxl-xminl)

def category_coord_pos(size, val, data, col):
    i = 0.5
    for v in data:
        if v[col] == val:
            return size * i / float(len(data))
        i = i + 1
    # the drawing area is clipped. So negative offset will make this plot
    # invisible.
    return canvas.invalid_coord;

_keys = {
    "loc" : (pychart_util.CoordType, 0, (0,0),
             "Bottom-left corner of the chart. "),
    "size" : (pychart_util.CoordType, 0, (120,110),
              "Size of the chart drawing area, excluding axis labels, legends, tick marks, etc."),
    "bg_style": (fill_style.T, 1, None, "Background of the chart."),
    "border_line_style": (line_style.T, 1, None, "Line style of the frame that surrounds the chart."),
    "x_coord_system":
    (CoordSystemType, 0, 'linear',
     """Either 'linear', 'log' or 'category'. Linear and log makes 
x coordinate scaled linearly or logarithmically. Category enumerates the X
values through x_category_data and x_category_col attributes."""),
    "x_category_data":
    (types.ListType, 1, None,
     """Meaningful only when x_coord_system = 'category'. 
'x_category_col'th column of each tuple in x_category_data defines the
set of X values."""),
    "x_category_col":
    (types.IntType, 1, 0,
     "Selects values from 'x_category_data'."),
    
    "y_coord_system": (CoordSystemType, 0, 'linear',
                       "Set the Y coordinate scaling. See also x_coord_system."),
    "x_range": (pychart_util.CoordType, 1, None,
               "The minimum and maximum X values. "),
    "y_range": (pychart_util.CoordType, 1, None,
               "The minimum and maximum Y values. "),
    "y_category_data": (types.ListType, 1, None, "See x_category_data."),
    "y_category_col": (types.IntType, 1, 1, "See x_category_col."),
    "x_axis": (axis.X, 1, None, "The X axis. <<axis>>."),
    "y_axis": (axis.Y, 1, None, "The Y axis. <<axis>>."),
    "x_grid_over_plot": (types.IntType, 0, 0,
                      "If true, grid lines are drawn over plots."),
    "y_grid_over_plot": (types.IntType, 0, 0, "See x_grid_over_plot."),
    "y_zap": (pychart_util.CoordType, 1, None, "Compress the section."),
    "y_zap_entire_area": (types.IntType, 1, None, "If 1, then the entire area is horizontally `zapped'."),
    "_plots": (types.ListType, 1, pychart_util.new_list),
    "legend": (legend.T, 1, None, "The legend of the chart."),
    "x_log_base": (types.IntType, 0, 10, ""),
    "y_log_base": (types.IntType, 0, 10, ""),
    }

class T(chart_object.T):
    keys = _keys
        
    # return the x position on the canvas corresponding to the value XVAL.
    def x_pos(self, xval):
        off = 0
        if self.x_coord_system == 'linear':
            off = linear_coord_pos(self.size[0], xval, self.x_range, None)
        elif self.x_coord_system == 'log':
            off = log_coord_pos(self.size[0], xval, self.x_range)
        else:
            off = category_coord_pos(self.size[0], xval,
                                     self.x_category_data, self.x_category_col)
        return self.loc[0] + off
    
    # return the y position on the canvas corresponding to the value YVAL.
    def y_pos(self, yval):
        off = 0
        if self.y_coord_system == 'linear':
            off = linear_coord_pos(self.size[1], yval, self.y_range, self.y_zap)
        elif self.y_coord_system == 'log':
            off = log_coord_pos(self.size[1], yval, self.y_range)
        else:
            off = category_coord_pos(self.size[1], yval,
                                   self.y_category_data, self.y_category_col)
        return self.loc[1] + off

    def __get_data_range(self, r, which, coord_system, log_base):
        if coord_system == 'category':
            return (0,0)

        r = r or (None, None)
        (dmin, dmax) = (None, None)

        for plot in self._plots:
            range = plot.get_data_range(which)
            if not dmin:
                (dmin, dmax) = range
            else:
                (thismin, thismax) = range
                (dmin, dmax) = (min(thismin, dmin), max(thismax, dmax))

        if coord_system == 'linear':
	    if dmax == dmin:
		unit = 10
	    else:
	        unit = 10 ** (float(int(math.log(dmax-dmin)/math.log(10))))
	        #unit = max(10, unit)

            if dmin:
                dmin = min(dmin, pychart_util.round_down(dmin, unit))
                dmax = max(dmax, pychart_util.round_up(dmax, unit) + unit/2.0)
            else:
                dmin = pychart_util.round_down(dmin, unit)
                dmax = pychart_util.round_up(dmax, unit) + unit/2.0

            #pychart_util.warn("DBA>", dmax, ">", dmin, "\n")

        elif coord_system == 'log':
            dmin = 1
            unit = (int(math.log(dmax-dmin)/math.log(log_base))+1)
            if dmax:
                dmax = max(dmax, log_base ** (unit+0.1))
            else:
                dmax = log_base ** (unit+0.1)
        else:
            raise ValueError, "Unknown coord system: " + coord_system
        if r[0] != None:
            dmin = r[0]
        if r[1] != None:
            dmax = r[1]
        return (dmin, dmax)
    
    def draw(self):
        self.type_check()

        if not self.x_range or not self.x_range[0] or not self.x_range[1]:
            self.x_range = self.__get_data_range(self.x_range, 'X', self.x_coord_system, self.x_log_base)
        if not self.y_range or not self.y_range[0] or not self.y_range[1]:
            self.y_range = self.__get_data_range(self.y_range, 'Y', self.y_coord_system, self.y_log_base)
        
	if self.y_zap != None and self.y_zap_entire_area:
            canvas.beginZigZagClip(self.loc[0],
                                   self.y_pos((self.y_zap[0]+self.y_zap[1])/2.0),
				   self.size[1])

        canvas.rectangle(self.border_line_style, self.bg_style,
                         self.loc[0], self.loc[1],
                         self.loc[0] + self.size[0], self.loc[1] + self.size[1])

        if not self.x_grid_over_plot and self.x_axis:
            self.x_axis.draw(self)
        if not self.y_grid_over_plot and self.y_axis:
            if self.y_zap != None and not self.y_zap_entire_area:
                canvas.beginZigZagClip(self.loc[0], self.y_pos((self.y_zap[0]+self.y_zap[1])/2.0), 30)
                self.y_axis.draw(self)
                canvas.endZigZagClip()
            else:
                self.y_axis.draw(self)
                
        canvas.clip(self.loc[0] - 10, self.loc[1] - 10,
                    self.loc[0] + self.size[0] + 10,
                    self.loc[1] + self.size[1] + 10)
        for plot in self._plots:
            plot.draw(self)
            
        canvas.endclip()
            
        if self.x_grid_over_plot and self.x_axis:
            self.x_axis.draw(self)
        if self.y_grid_over_plot and self.y_axis:
            if self.y_zap != None and not self.y_zap_entire_area:
                canvas.beginZigZagClip(self.loc[0], self.y_pos((self.y_zap[0]+self.y_zap[1])/2.0), 30)
                self.y_axis.draw(self)
                canvas.endZigZagClip()
            else:
                self.y_axis.draw(self)
            
        if self.legend:
            legends = []
            for plot in self._plots:
                entry = plot.get_legend_entry()
                if entry == None:
                    pass
                elif type(entry) != types.ListType:
                    legends.append(entry)
                else:
                    for e in entry:
                        legends.append(e)
            self.legend.draw(self, legends)

	if self.y_zap != None and self.y_zap_entire_area:
            canvas.endZigZagClip()
        
    def add_plot(self, *plots):
        for plot in plots:
            self._plots.append(plot)
