import Docsupport
import getopt
import string
from pychart import *
import sys
import re

output="png"
optlist, argv = getopt.getopt(sys.argv[1:], "pP")
for l in optlist:
    if l[0] == "-p":
        output="pdf"
    if l[0] == "-P":
        output="eps"

def formatDocString(str):
    str = re.sub("<<([^>]+)>>", "@xref{\\1}.", str)
    return str

def outputClassAttrs(moduleName, className):
    x = Docsupport.modules[moduleName]
    v = x[className]
#    print "@multitable @asis\n";
    print "@multitable @columnfractions 0.25 0.15 0.15 0.45\n";
    print "@item @strong{Attribute}\n@tab @strong{Type}\n@tab @strong{Default}\n@tab @strong{Description}\n";
    keys = v.keys.keys()
    keys.sort()
    for key in keys:
        if key[0] == '_':
            continue
        val = v.keys[key]
	print "@vindex ", key
        print "@item @code{", key, "}"
	s = Docsupport.stringify_type(val[0])
	s2 = str(s)
	mm = re.match("(.*)\\.T$", s2)
        print "@tab %s" % (s,)

        print "@tab ", Docsupport.stringify_value(val[2]), "\n@tab ",
        if len(val) > 3:
            print formatDocString(val[3])
	if mm:
	    print "@xref{%s}." % (mm.group(1),)
	print "\n";
    print "@end multitable";

def copyFile(src, dest):
    infp = open(src, "rb")
    outfp = open(dest, "wb")
    outfp.writelines(infp.readlines())
    infp.close()
    outfp.close()
    
nodeNames = []
nodeReplaces = []
demoDir = "../../demos/"

def scanNodes(fp):
    global nodeNames
    for line in fp.readlines():
        moNode = re.match("^@node ([^,]*)", line)
        if moNode:
            nodeNames.append(re.compile("\\b(" + moNode.group(1) + ")\\b"))

def include_text_file(file):
    fp = open(file, "r")
    print "@example\n"
    for line in fp.readlines():
        print string.expandtabs(line),
    fp.close()
    print "@end example"
    
fp = open(argv[0], "r")

scanNodes(fp)

fp.seek(0)

line = fp.readline()
while line != "":
    mo = re.match("^%%([^.]+)\\.(.*)", line)
    mo2 = re.match("^%-([^,]*),(.*)", line)
    mo3 = re.match("^%-(.*)", line)
    mo4 = re.match("^%#([^,]*),(.*)", line)
    mo5 = re.match("^%i(.*)", line)
    if mo:
        outputClassAttrs(mo.group(1), mo.group(2))
    elif mo2 or mo4:
	envname="{figure}"
	envarg = ""
	if mo4:
	    envname = "{figure}"
	    envarg = ""
	    mo2=mo4
        file=mo2.group(1)
        description=mo2.group(2)
	copyFile(demoDir + file + "." + output, file + "." + output)
        print "@image {" + file + "}\n"
        print description, "\n"
        print "Below is the source code that produces Figure \\ref{fig:" \
              + file + "}:"
        include_text_file(demoDir + file + ".py")
        
    elif mo3:
        file=mo3.group(1)
        include_text_file(demoDir + file)
    elif mo5:
        file=mo5.group(1)
	copyFile(demoDir + file + "." + output, file + "." + output)
        print "@image {" + file + "}\n"
    else:
        print line,
    line = fp.readline()

