#!/usr/bin/perl
use Getopt::Std;

sub usage () {
    print "usage: pstopng [-o OUTPUT] [-d RESOLUTION] PSFILE\n";
    exit(1);
}
getopts("d:o:") || usage();
$ps_file = shift;
usage() unless $ps_file;
$tmp_file = "pstopngtmp";
$density= $opt_d or 144; # 72: standard size, 144: double size, etc.

if ($opt_o) {
    $output_file = $opt_o;
} elsif ($ps_file =~ /(.*)\.eps$/ or $ps_file =~ /(.*)\.ps$/) {
    $output_file = "$1.png";
} else {
    $output_file = "$ps_file.png";
}

open(PS, $ps_file) || die "$ps_file: $!";
open(TMP, ">$tmp_file") || die "tmp: $!";
while (<PS>) {
    if (/%%BoundingBox: ([-\d]+) ([-\d]+) ([-\d]+) ([-\d]+)/) {
	($bx, $by, $bw, $bh) = (0 - $1, 0 - $2, 
				int(($3-$1)* $density/72.0 + 0.5), 
				int(($4-$2) * $density/72.0) + 0.5);
	
	$bounding_box_found = 1;
	last;
    }
}
close PS;
print TMP "$bx $by translate\n";
print TMP "($ps_file) run quit\n";
close TMP;
die "%%BoundingBox not found" unless $bounding_box_found;
system("c:/gstools/gs6.50/bin/gswin32c -r$density -g${bw}x${bh} -q -dNOPAUSE -sDEVICE=png256 -SOutputFile=$output_file $tmp_file");


