/***********************************************************/
/* PORTSCAN.C by Tennessee Carmel-Veilleux                 */
/* Contact info:                                           */
/* e-mail: veilleux@ameth.org                              */
/* www: http://www.ameth.org/~veilleux 			   */
/*                                                         */
/* Version 1.0                                             */
/* The author of this program offers no waranty at all     */
/* about the correct execution of this software material.  */
/* Furthermore, the author can NOT be held responsible for */
/* any physical or moral damage caused by the use of this  */
/* software.                                               */
/*                                                         */
/* -> This program will scan for TCP port listening on a   */
/*    remote or local host inside the range you give to it.*/
/*    I offer no warranty over the accuracy though :)      */
/*    There are 3 verbose modes: No info, service info, and*/
/*    full info. No info is good of you only want the list */
/*    of the ports, no more info. The best mode is Full    */
/*    info, as you get error information,etc. The main     */
/*    output is STDOUT, and ALL the errors go to STDERR.   */
/*                                                         */
/*    History: v1.00 : August 9 1998 -> First release      */
/***********************************************************/

#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>

int sock = -1;
struct sockaddr_in address;
int result;
extern char *sys_errlist[];
extern int errno;
int current_port = 0; 
u_short base_port = 0;
u_short end_port = 1024;
int verbose = 0;
struct hostent *host_info;
struct servent *service_info;

void port_scan(void);

int main(int argc, char **argv)
{ 
   if (argc < 4) {
    fprintf(stderr,"Usage: portscan [address] [start port] [end port] <-v or -vv>\n");
    exit(1);
   }
   
   switch (argc) {
     case 5: if (!strcmp(argv[4],"-v")) 
               verbose = 1;
             else if (!strcmp(argv[4],"-vv"))
                    verbose = 2;
               else { fprintf(stderr,"Usage: portscan [address] [start port] [end port] <-v or -vv>\n");
                      exit(1); }

     case 4: base_port = (u_short)atoi(argv[2]);
             end_port = (u_short)atoi(argv[3]);
             break;
     default: fprintf(stderr,"Usage: portscan [address] [start port] [end port] <-v>\n");
              exit(1);
              break;
   }
   
   bzero((char *)&address, sizeof(address));
   address.sin_family = AF_INET;

   if (verbose == 2) printf("Resolving: %s ->",argv[1]);
   if (host_info = gethostbyname(argv[1])) {
     bcopy(host_info->h_addr, (char *)&address.sin_addr,host_info->h_length);
     if (verbose == 2) printf(" resolved\n");
   } else if ((address.sin_addr.s_addr = inet_addr(argv[1])) == INADDR_NONE) {
            fprintf(stderr,"Could not get %s host entry !\n",argv[1]);
            printf(" NOT resolved !!!\n");
            exit(1);
          } else if (verbose == 2) printf(" address valid\n");
   
   if ((base_port > end_port) || ((short)base_port < 0)) { 
     fprintf(stderr,"Bad port range : start=%d end=%d !\n");
     exit(1);
   } else if (verbose == 2) {
            printf("Port range: %d to %d\n",base_port,end_port);
     }
   port_scan();
   exit(0);
}

void port_scan(void) {

   while (base_port+current_port <= end_port) {
/*  fprintf(stderr,"Trying port: %d\n",base_port+current_port); */
    sock = socket(PF_INET, SOCK_STREAM, 0);
    if (sock == -1)
     {
	fprintf(stderr, "Error assigning master socket: %s\n",sys_errlist[errno]);
	exit(-1);
     } 

    address.sin_port = htons(base_port+current_port);
    if (connect(sock, (struct sockaddr *)&address, sizeof(address)) == 0) {
     switch (verbose) {
      case 0: printf("%d\n",base_port+current_port);
              break;
      case 1: service_info = getservbyport(htons(base_port+current_port),"tcp");
              if (!service_info) {
              printf("%d -> service name unknown\n",base_port+current_port);
              } else {
              printf("%d -> %s\n",base_port+current_port,service_info->s_name);
              }
              break; 
      case 2: service_info = getservbyport(htons(base_port+current_port),"tcp");
              if (!service_info) {
              printf("Port %d found. Service name unknown\n",base_port+current_port);
              } else {
              printf("Port %d found. Service name: %s\n",base_port+current_port,service_info->s_name);
              }
              break; 
     } 
    }  else if (errno == 113) {
         fprintf(stderr,"No route to host !\n");
         exit(1);
       } 
/*     fprintf(stderr,"Error %d connecting socket %d to port %d: %s\n",
     errno,sock,base_port+current_port,sys_errlist[errno]); */ 
     close(sock);
     current_port++;
   }

  if (verbose == 2) printf("Port scan finished !\n");
}

