#!/usr/bin/ksh

SGML_HOME=/usr/share/sgml

DOCBOOK_CATALOGS='
   CATALOG.docbook-dsssl-stylesheets 
   CATALOG.docbk41
   CATALOG.jade_dsl'

function exportCatalogs
{
   for CATALOG in $*;
   do
      if [[ -n ${CATALOG} ]]
      then
         if [[ -n ${CATALOG_FILES} ]]
         then
            CATALOG_FILES=${CATALOG_FILES}:${SGML_HOME}/${CATALOG}
         else
            CATALOG_FILES=${SGML_HOME}/${CATALOG}
         fi
      fi
   done;
}

CATALOG_FILES=""
exportCatalogs ${DOCBOOK_CATALOGS}
typeset -x SGML_CATALOG_FILES=${CATALOG_FILES}

./xdoc.py POW
openjade -t tex POW.sgm
pdfjadetex POW.tex
