<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

   <xsl:template match="docset">
      <xsl:element name="article">
         <xsl:element name="articleinfo">
            <xsl:element name="title">
               <xsl:value-of select="///moduleDescription/header/name"/>
            </xsl:element>
         </xsl:element>
         <xsl:element name="sect1">
            <xsl:element name="title">Introduction</xsl:element>
            <xsl:copy-of select="///moduleDescription/body/*"/>
         </xsl:element>
         <xsl:element name="sect1">
            <xsl:element name="title">Module Functions</xsl:element>
            <xsl:call-template name="functionPrototypes"/>
            <xsl:call-template name="functionDescriptions"/>
         </xsl:element>
         <xsl:element name="sect1">
            <xsl:element name="title">Module Classes</xsl:element>
            <xsl:call-template name="moduleClasses"/>
         </xsl:element>
      </xsl:element>
   </xsl:template>

   <xsl:template name="functionPrototypes">
      <xsl:element name="sect2">
         <xsl:element name="title">Function Prototypes</xsl:element>
         <xsl:element name="funcsynopsis">
            <xsl:for-each select="///modulefunction">
               <xsl:element name="funcprototype">
                  <xsl:element name="funcdef">def <xsl:element name="function"><xsl:value-of select="header/name"/></xsl:element></xsl:element>
                  <xsl:call-template name="functionParameter"/>

               </xsl:element>
            </xsl:for-each>
         </xsl:element>
      </xsl:element>
   </xsl:template>


   <xsl:template name="functionDescriptions">
      <xsl:element name="sect2">
         <xsl:element name="title">Function Descriptions</xsl:element>
         <xsl:for-each select="///modulefunction">
            <xsl:element name="sect3">
               <xsl:element name="title">The <xsl:element name="function"><xsl:value-of select="header/name"/></xsl:element> Function</xsl:element>
               <xsl:copy-of select="body/*"/>
            </xsl:element>
         </xsl:for-each>
      </xsl:element>
   </xsl:template>


   <xsl:template name="moduleClasses">
      <xsl:for-each select="///class">
         <xsl:variable name="class">
            <xsl:value-of select="header/name"/>
         </xsl:variable>
         <xsl:element name="sect2">
            <xsl:element name="title">The <xsl:element name="classname"><xsl:value-of select="$class"/></xsl:element> Class</xsl:element>

            <xsl:copy-of select="body/*"/>

            <xsl:element name="sect3">
               <xsl:element name="title">Class Prototypes</xsl:element> 
               <xsl:call-template name="methodPrototypes">
                  <xsl:with-param name="class">
                     <xsl:value-of select="$class"/>
                  </xsl:with-param>
               </xsl:call-template>
            </xsl:element> 

            <xsl:call-template name="methodDescriptions">
               <xsl:with-param name="class">
                  <xsl:value-of select="$class"/>
               </xsl:with-param>
            </xsl:call-template>

         </xsl:element>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="methodPrototypes">
      <xsl:param name="class"/>
      <xsl:element name="classsynopsis">
         <xsl:attribute name="language">python</xsl:attribute>
         <xsl:element name="ooclass"><xsl:element name="classname"><xsl:value-of select="$class"/></xsl:element></xsl:element> 
         <xsl:for-each select="///constructor">
            <xsl:if test="header/memberof=$class">
               <xsl:element name="constructorsynopsis">
                  <xsl:element name="methodname"><xsl:value-of select="$class"/></xsl:element> 
                  <xsl:call-template name="methodParameter"/>
<!--
                  <xsl:for-each select="header/parameter">
                     <xsl:element name="methodparam"><xsl:element name="parameter"><xsl:value-of select="self::node()"/></xsl:element></xsl:element> 
                  </xsl:for-each>
-->
                  
               </xsl:element> 
            </xsl:if>
         </xsl:for-each>
         <xsl:for-each select="///method">
            <xsl:if test="header/memberof=$class">
               <xsl:element name="methodsynopsis">
                  <xsl:element name="methodname">
                     <xsl:value-of select="header/name"/>
                  </xsl:element> 
                  <xsl:call-template name="methodParameter"/>
               </xsl:element> 
            </xsl:if>
         </xsl:for-each>
      </xsl:element> 
   </xsl:template>

   <xsl:template name="functionParameter">
      <xsl:choose>
         <xsl:when test="header/parameter!=''">
            <xsl:for-each select="header/parameter">
               <xsl:element name="paramdef">
                  <xsl:element name="parameter">
                     <xsl:value-of select="self::node()"/>
                  </xsl:element> 
               </xsl:element> 
            </xsl:for-each>
         </xsl:when>
         <xsl:otherwise>
            <xsl:element name="void"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template name="methodParameter">
      <xsl:choose>
         <xsl:when test="header/parameter!=''">
            <xsl:for-each select="header/parameter">
               <xsl:element name="methodparam">
                  <xsl:element name="parameter">
                     <xsl:value-of select="self::node()"/>
                  </xsl:element> 
               </xsl:element> 
            </xsl:for-each>
         </xsl:when>
         <xsl:otherwise>
            <xsl:element name="void"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template name="methodDescriptions">
      <xsl:param name="class"/>

      <xsl:for-each select="///constructor">
         <xsl:if test="header/memberof=$class">
            <xsl:element name="sect3">
               <xsl:element name="title">The <xsl:element name="function">__init__</xsl:element> Method</xsl:element>
               <xsl:copy-of select="body/*"/>
            </xsl:element>
         </xsl:if>
      </xsl:for-each>

      <xsl:for-each select="///method">
         <xsl:if test="header/memberof=$class">
            <xsl:element name="sect3">
               <xsl:element name="title">The <xsl:element name="function"><xsl:value-of select="header/name"/></xsl:element> Method</xsl:element>
               <xsl:copy-of select="body/*"/>
            </xsl:element>
         </xsl:if>
      </xsl:for-each>

   </xsl:template>

</xsl:stylesheet>
