#!/usr/bin/env python

import os,math,base64,socket,sys,time,POW

if not os.path.isdir('working'):
   os.mkdir('working')

def write_rsa_test():
   privateFile = open('working/private.key', 'w')
   publicFile = open('working/public.key', 'w')

   rsa = POW.Asymmetric( POW.RSA_CIPHER, 512 )
   privateFile.write( rsa.pemWrite( POW.RSA_PRIVATE_KEY, POW.DES_EDE3_CFB, 'pass' ) )
   publicFile.write( rsa.pemWrite( POW.RSA_PUBLIC_KEY ) )

   privateFile.close()
   publicFile.close()

def read_rsa_test():
   privateFile = open('working/private.key', 'r')
   publicFile = open('working/public.key', 'r')

   privateKey = POW.pemRead( POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass' )
   publicKey = POW.pemRead( POW.RSA_PUBLIC_KEY, publicFile.read() )

   print privateKey.pemWrite( POW.RSA_PRIVATE_KEY, POW.DES_EDE3_CFB, 'pass' )
   print publicKey.pemWrite( POW.RSA_PUBLIC_KEY )

def sign_test():
   plain_text = 'Hello World!'
   print '\tPlain text:', plain_text
   digest = POW.Digest( POW.RIPEMD160_DIGEST )
   digest.update( plain_text )
   print '\tDigest text:', digest.digest()

   privateFile = open('working/private.key', 'r')
   privateKey = POW.pemRead( POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass' )
   privateFile.close()
   signed_text =  privateKey.sign(digest.digest(), POW.RIPEMD160_DIGEST)
   print '\tSigned text:', signed_text

   digest2 = POW.Digest( POW.RIPEMD160_DIGEST )
   digest2.update( plain_text )
   publicFile = open('working/public.key', 'r')
   publicKey = POW.pemRead( POW.RSA_PUBLIC_KEY, publicFile.read() )
   publicFile.close()
   if publicKey.verify( signed_text, digest2.digest(), POW.RIPEMD160_DIGEST ):
      print '\n\n\tSigning verified!'
   else:
      print '\n\n\tSigning gone wrong!'

def public_private_test():
   privateFile = open('working/private.key', 'r')
   publicFile = open('working/public.key', 'r')

   privateKey = POW.pemRead( POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass' )
   publicKey = POW.pemRead( POW.RSA_PUBLIC_KEY, publicFile.read() )

   publicCipherText = publicKey.publicEncrypt( 'public encryption test data' ) 
   print '\tcipher text length:', len(publicCipherText), '\n\tpublic cihper text, decrypted:', \
            privateKey.privateDecrypt( publicCipherText ), '\n'

   privateCipherText = privateKey.privateEncrypt( 'private encryption test data' ) 
   print '\tcipher text length:', len(privateCipherText), '\n\tprivate cihper text, decrypted:', \
            publicKey.publicDecrypt( privateCipherText ), '\n'

def revoked_test():            
   rev = POW.X509Revoked()
   rev.setSerial(1)
   rev.setDate( time.time() )
   print rev.getSerial()
   print rev.getDate()

def write_crl_test():
   privateFile = open('working/private.key', 'r')
   publicFile = open('working/public.key', 'r')
   crlFile = open('working/crl.pem', 'w')

   publicKey = POW.pemRead(POW.RSA_PUBLIC_KEY, publicFile.read())
   privateKey = POW.pemRead(POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass')

   crl = POW.X509Crl()

   name = [  ['C', 'GB'], ['ST', 'Hertfordshire'], 
             ['O','The House'], ['CN', 'Peter Shannon'] ]

   crl.setIssuer( name )
   rev = [  POW.X509Revoked(3, int( time.time() ) - 24*60*60 ),
            POW.X509Revoked(4, int( time.time() ) - 24*60*60 ),
            POW.X509Revoked(5, int( time.time() ) - 24*60*60 )    ]

   crl.setRevoked( rev )
   crl.setThisUpdate( time.time() )
   crl.setNextUpdate( time.time() + 2*60*60*24*365)
   crl.sign(privateKey)

   crlFile.write( crl.pemWrite() )

   privateFile.close()
   publicFile.close()
   crlFile.close()

def read_crl_test():
   publicFile = open('working/public.key', 'r')
   crlFile = open('working/crl.pem', 'r')

   publicKey = POW.pemRead(POW.RSA_PUBLIC_KEY, publicFile.read())

   crl = POW.pemRead( POW.X509_CRL, crlFile.read() )

   print crl.pprint()
   if crl.verify( publicKey ):
      print '\n\tsignature ok!'
   else:
      print '\n\tsignature not ok!'

   revocations = crl.getRevoked()
   for revoked in revocations:
      print 'serial number:', revoked.getSerial()
      print 'date:', time.ctime( revoked.getDate()[0] ), '\n'

   publicFile.close()
   crlFile.close()

def write_x509_test():
   privateFile = open('working/private.key', 'r')
   publicFile = open('working/public.key', 'r')
   certFile = open('working/cacert.pem', 'w')

   publicKey = POW.pemRead(POW.RSA_PUBLIC_KEY, publicFile.read())
   privateKey = POW.pemRead(POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass')

   c = POW.X509()

   name = [  ['C', 'GB'], ['ST', 'Hertfordshire'], 
             ['O','The House'], ['CN', 'Peter Shannon'] ]

   c.setIssuer( name )
   c.setSubject( name )
   c.setSerial(0)
   c.setNotBefore( time.time() )
   c.setNotAfter( time.time() + 60*60*24*365)
   c.setPublicKey(publicKey)
   c.sign(privateKey)

   certFile.write( c.pemWrite() )

   privateFile.close()
   publicFile.close()
   certFile.close()

def read_x509_test():
   certFile = open( 'working/cacert.pem', 'r' )
   cert = POW.pemRead( POW.X509_CERTIFICATE, certFile.read() )
   certFile.close()
   print cert.pprint()

def foocom_test():
   privateFile = open('working/foocom.priv', 'w')
   publicFile = open('working/foocom.pub', 'w')

   rsa = POW.Asymmetric( POW.RSA_CIPHER, 1024 )
   privateFile.write( rsa.pemWrite( POW.RSA_PRIVATE_KEY, POW.DES_EDE3_CFB, 'pass' ) )
   publicFile.write( rsa.pemWrite( POW.RSA_PUBLIC_KEY ) )

   privateFile.close()
   publicFile.close()

   privateFile = open('working/private.key', 'r')
   publicFile = open('working/foocom.pub', 'r')

   certFile = open('working/foocom.cert', 'w')

   publicKey = POW.pemRead(POW.RSA_PUBLIC_KEY, publicFile.read())
   privateKey = POW.pemRead(POW.RSA_PRIVATE_KEY, privateFile.read(), 'pass')

   c = POW.X509()

   subject = [ ['C', 'GB'], ['ST', 'Hertfordshire'], 
               ['O','The House'], ['CN', 'David Shannon'] ]

   issuer = [  ['C', 'GB'], ['ST', 'Hertfordshire'], 
               ['O','The House'], ['CN', 'Peter Shannon'] ]

   c.setSubject( subject )
   c.setIssuer( issuer )
   c.setVersion(2)
   c.setSerial(3)
   c.setNotBefore( time.time() )
   c.setNotAfter( time.time() + 2*60*60*24*365)
   c.setPublicKey(publicKey)
   c.sign(privateKey)

   certFile.write( c.pemWrite() )

   privateFile.close()
   publicFile.close()
   certFile.close()

def verify_test():
   store = POW.X509Store()

   caFile = open( 'working/cacert.pem', 'r' )
   ca = POW.pemRead( POW.X509_CERTIFICATE, caFile.read() )
   caFile.close()

   store.addTrust( ca )

   certFile = open( 'working/foocom.cert', 'r' )
   x509 = POW.pemRead( POW.X509_CERTIFICATE, certFile.read() )
   certFile.close()

   print x509.pprint()
   
   if store.verify( x509 ):
      print '\n\tVerified certificate!.'
   else:
      print '\n\tFailed to verify certificate!.'

def client_test():
   s = socket.socket( socket.AF_INET, socket.SOCK_STREAM )
   s.connect(('localhost', 1111))

   sl = POW.Ssl( POW.SSLV23_CLIENT_METHOD )
   sl.setFd( s.fileno() )
   sl.connect()
   sl.write('\n\tMessage from client to server...')
   print sl.read(1024)

   store = POW.X509Store()

   caFile = open( 'working/cacert.pem', 'r' )
   ca = POW.pemRead( POW.X509_CERTIFICATE, caFile.read() )
   caFile.close()

   store.addTrust( ca )
   x509 = sl.peerCertificate()
   if store.verify( x509 ):
      print '\n\tGot servers certificate and verified!'
      print '\tThe issuer is:'
      name = x509.getSubject()
      for pair in name:
         print '\t\t', pair[0] + ':\t',  pair[1]
      print '\n'

   else:
      print '\n\tCould not verify servers certificate!\n'
   s.close()

def server_test():
   keyFile = open( 'working/private.key', 'r' )
   certFile = open( 'working/cacert.pem', 'r' )

   rsa = POW.pemRead( POW.RSA_PRIVATE_KEY, keyFile.read(), 'pass' )
   x509 = POW.pemRead( POW.X509_CERTIFICATE, certFile.read() )

   keyFile.close()
   certFile.close()

   sl = POW.Ssl( POW.SSLV23_SERVER_METHOD )
   sl.useCertificate( x509 )
   sl.useKey( rsa )

   s = socket.socket( socket.AF_INET, socket.SOCK_STREAM )
   s.bind( ('localhost', 1111) )
   s.listen(5)
   s2, addr = s.accept()

   s.close()

   sl.setFd( s2.fileno() )
   sl.accept()
   print sl.read(1024)
   sl.write('\n\tMessage from server to client...')

   s2.close()     

def crl_test():
   caFile = open( 'working/cacert.pem', 'r' )
   ca = POW.pemRead( POW.X509_CERTIFICATE, caFile.read() )
   caFile.close()

   fooFile = open( 'working/foocom.cert', 'r' )
   foo = POW.pemRead( POW.X509_CERTIFICATE, fooFile.read() )
   fooFile.close()

   crlFile = open( 'working/crl.pem', 'r' )
   crl = POW.pemRead( POW.X509_CRL, crlFile.read() )
   crlFile.close()

   store = POW.X509Store()
   store.addTrust( ca )
   if store.verify( foo ):
      print '\n\tCertificate verified!'
      print '\tThe issuer is:'
      name = foo.getSubject()
      for pair in name:
         print '\t\t', pair[0] + ':\t',  pair[1]
      print '\n'

   else:
      print '\n\tCould not verify servers certificate!\n'

def ssl_test():
   print '\nForking client...'
   time.sleep(1)
   pid = os.fork()

   if pid:
      print 'Waiting 5 seconds for server to start...'
      time.sleep(5)
      client_test()

   else:
      time.sleep(1)
      print 'Starting server...'
      server_test()

def md2_test():
   plain_text = 'Hello World!'
   md2 = POW.Digest( POW.MD2_DIGEST )
   md2.update( plain_text )
   print '\tPlain text: Hello World! =>', md2.digest()

def md5_test():
   plain_text = 'Hello World!'
   md5 = POW.Digest( POW.MD5_DIGEST )
   md5.update( plain_text )
   print '\tPlain text: Hello World! =>', md5.digest()

def sha_test():
   plain_text = 'Hello World!'
   sha = POW.Digest( POW.SHA_DIGEST )
   sha.update( plain_text )
   print '\tPlain text: Hello World! =>', sha.digest()

def sha1_test():
   plain_text = 'Hello World!'
   sha1 = POW.Digest( POW.SHA1_DIGEST )
   sha1.update( plain_text )
   print '\tPlain text: Hello World! =>', sha1.digest()

def ripemd160_test():
   plain_text = 'Hello World!'
   rpmd = POW.Digest( POW.RIPEMD160_DIGEST )
   rpmd.update( plain_text )
   print '\tPlain text: Hello World! =>', rpmd.digest()

def cast_test():
   passphrase = 'my silly passphrase'
   md5 = POW.Digest( POW.MD5_DIGEST )
   md5.update( passphrase )
   password = md5.digest()[:8]

   plaintext = 'cast test message'
   cast = POW.Symmetric( POW.CAST5_CFB ) 
   cast.encryptInit( password )
   ciphertext = cast.update(plaintext) + cast.final()
   print '\tCipher text:\t\t', ciphertext

   cast.decryptInit( password )
   out = cast.update( ciphertext ) + cast.final()
   print '\tDeciphered text:\t', out

def rand_test():
   POW.writeRandomFile('working/rand')
   POW.readRandomFile('working/rand',1000)
   POW.seed('aweofhdkjh8912iuhw3r')
   POW.writeRandomFile('working/rand')

def doc_test():
   print '<docset>'
   for doc in POW.__docset__.get():
      print doc
   print '</docset>'

tests = [   rand_test, cast_test, ripemd160_test, sha1_test, sha_test,
            md5_test, md2_test, write_rsa_test, read_rsa_test, sign_test,
            public_private_test, revoked_test, write_crl_test, read_crl_test,
            write_x509_test, read_x509_test, foocom_test, verify_test,
            crl_test ]

def all_test():
   st = 2 # seconds
   for test in tests:
      pid = os.fork()
      if not pid:
         print '\n======================================================================\n\n\t', test.__name__
         test()
         sys.exit()
      else:
         os.waitpid( pid, 0 )
         time.sleep(st)

if len(sys.argv) == 2:
   if sys.argv[1] == 'all_test':
      all_test()
      
   elif sys.argv[1] == 'write_rsa_test':
      write_rsa_test()

   elif sys.argv[1] == 'read_rsa_test':
      read_rsa_test()

   elif sys.argv[1] == 'sign_test':
      sign_test()

   elif sys.argv[1] == 'public_private_test':
      public_private_test()

   elif sys.argv[1] == 'md2_test':
      md2_test()

   elif sys.argv[1] == 'md5_test':
      md5_test()

   elif sys.argv[1] == 'sha_test':
      sha_test()

   elif sys.argv[1] == 'sha1_test':
      sha1_test()

   elif sys.argv[1] == 'ripemd160_test':
      ripemd160_test()

   elif sys.argv[1] == 'cast_test':
      cast_test()

   elif sys.argv[1] == 'rand_test':
      rand_test()

   elif sys.argv[1] == 'revoked_test':
      revoked_test()

   elif sys.argv[1] == 'write_crl_test':
      write_crl_test()

   elif sys.argv[1] == 'read_crl_test':
      read_crl_test()

   elif sys.argv[1] == 'crl_test':
      crl_test()

   elif sys.argv[1] == 'write_x509_test':
      write_x509_test()

   elif sys.argv[1] == 'read_x509_test':
      read_x509_test()

   elif sys.argv[1] == 'foocom_test':
      foocom_test()

   elif sys.argv[1] == 'verify_test':
      verify_test()

   elif sys.argv[1] == 'client_test':
      client_test()

   elif sys.argv[1] == 'server_test':
      server_test()

   elif sys.argv[1] == 'ssl_test':
      ssl_test()

   elif sys.argv[1] == 'doc_test':
      doc_test()

   else:
      print '\nunknown test\n'
else:
   print """
Please run one of the test.

   tests = [   rand_test, cast_test, ripemd160_test, sha1_test, sha_test,
               md5_test, md2_test, write_rsa_test, read_rsa_test, sign_test,
               public_private_test, revoked_test, write_crl_test, read_crl_test,
               write_x509_test, read_x509_test, foocom_test, verify_test,
               crl_test, all_test ]
   ei:

   root@alecto:/tmp/pow > python test.py all_test
"""
