#!/www/python/bin/python

from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE

__revision__ = "$Id: test_nargs.py,v 1.1 2001/12/10 18:01:38 gward Exp $"

# Test the "nargs" Option attribute (new with Optik 1.1)
parser = OptionParser(usage=SUPPRESS_USAGE)
parser.add_option("-p", "--point",
                  action="store", nargs=3, type="float", dest="point")
(values, args) = parser.parse_args(["foo", "-p", "1", "2.5", "-4.3", "xyz"])
assert len(vars(values)) == 1
assert values.point == (1.0, 2.5, -4.3)
assert args == ["foo", "xyz"]
print "ok: 1"

(values, args) = parser.parse_args(["--point", "-1", "2.5", "-0", "xyz"])
assert len(vars(values)) == 1
assert values.point == (-1.0, 2.5, -0.0)
assert args == ["xyz"]
print "ok: 2"

try:
    parser.parse_args(["-p", "1.0", "2x", "3.5"])
except SystemExit, err:
    assert err.args[0].endswith("option -p: "
                                "invalid floating-point value: '2x'"), \
           err.args[0]
    print "ok: 3"
else:
    print "not ok"

try:
    parser.parse_args(["--point", "1.0", "3.5"])
except SystemExit, err:
    assert err.args[0].endswith("--point option requires 3 values"), \
           err.args[0]
    print "ok: 4"
else:
    print "not ok"
    
parser.add_option("-f", "--foo",
                  action="append", nargs=2, type="int", dest="foo")
(values, args) = parser.parse_args(["-f", "4", "-3", "blah",
                                    "--foo", "1", "666"])
assert len(vars(values)) == 2
assert values.point is None
assert values.foo == [(4, -3), (1, 666)], values.foo
assert args == ["blah"]
print "ok: 5"

try:
    parser.parse_args(["-f4,3"])
except SystemExit, err:
    assert err.args[0].endswith("-f option requires 2 values"), err.args[0]
    print "ok: 6"
else:
    print "not ok"

(values, args) = parser.parse_args(["--foo=3", "4"])
assert values.foo == [(3, 4)]
assert args == []
print "ok: 7"


