#!/www/python/bin/python

# Test conflict resolution between options in an OptionParser.

__revision__ = "$Id: test_conflict.py,v 1.2 2001/12/10 20:27:47 gward Exp $"

import sys
from cStringIO import StringIO
from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE
from optik.errors import OptionConflictError


# First, test the old (Option <= 1.1 behaviour) -- arguably broken, but
# still available so should be tested.

def show_version (option, opt, value, parser):
    parser.values.show_version = 1

parser = OptionParser(usage=SUPPRESS_USAGE,
                      conflict_handler="ignore")
parser.add_option("-v", "--verbose", action="count", dest="verbose",
                  help="increment verbosity")
parser.add_option("-v", "--version", action="callback", callback=show_version,
                  help="show version")

v_opt = parser.get_option("-v")
verbose_opt = parser.get_option("--verbose")
version_opt = parser.get_option("--version")

assert v_opt is version_opt
assert v_opt is not verbose_opt
assert v_opt._long_opts == ["--version"]
assert version_opt._short_opts == ["-v"]
assert verbose_opt._short_opts == ["-v"]
print "ok: 1"

# The help text makes the conflict obvious, at least.
sys.stdout = StringIO()
try:
    parser.parse_args(["-h"])
except SystemExit, err:
    stdout = sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    assert err[0] == 0
    assert stdout == """\
options:
  -h, --help     show this help message and exit
  -v, --verbose  increment verbosity
  -v, --version  show version
""", stdout
    print "ok: 2"
else:
    sys.stdout = sys.__stdout__
    print "not ok"

# Now try parsing a command-line with the conflict there.
(options, args) = parser.parse_args(["-v"])
assert vars(options) == {'show_version': 1,
                         'verbose': None}
assert args == []
print "ok: 3"


# Now use the default conflict resolution for Optik 1.2: error.
parser = OptionParser(usage=SUPPRESS_USAGE)
parser.add_option("-v", "--verbose", action="count", dest="verbose",
                  help="increment verbosity")
try:
    parser.add_option("-v", "--version",
                      action="callback", callback=show_version,
                      help="show version")
except OptionConflictError, err:
    assert err.msg == "conflicting option string(s): -v", err.msg
    assert err.option_id == "-v/--version", err.option_id
    assert str(err) == "option -v/--version: conflicting option string(s): -v"
    print "ok: 4"
else:
    print "not ok"


# Try the fancy conflict resolution method.
parser.set_conflict_handler("resolve")
parser.add_option("-v", "--version",
                  action="callback", callback=show_version,
                  help="show version")

v_opt = parser.get_option("-v")
verbose_opt = parser.get_option("--verbose")
version_opt = parser.get_option("--version")

assert v_opt is version_opt
assert v_opt is not verbose_opt
assert v_opt._long_opts == ["--version"]
assert version_opt._short_opts == ["-v"]
assert version_opt._long_opts == ["--version"]
assert verbose_opt._short_opts == []
assert verbose_opt._long_opts == ["--verbose"]
print "ok: 5"

# Look at the help text -- the conflict has been removed
sys.stdout = StringIO()
try:
    parser.parse_args(["-h"])
except SystemExit, err:
    stdout = sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    assert err[0] == 0
    assert stdout == """\
options:
  -h, --help     show this help message and exit
  --verbose      increment verbosity
  -v, --version  show version
""", stdout
    print "ok: 6"
else:
    sys.stdout = sys.__stdout__
    print "not ok"

# And try parsing some command lines.
(options, args) = parser.parse_args(["-v"])
assert vars(options) == {'verbose': None, 'show_version': 1}, vars(options)
assert args == []
print "ok: 7"

(options, args) = parser.parse_args(["--verbose"])
assert vars(options) == {'verbose': 1}, vars(options)
assert args == []
print "ok: 8"

(options, args) = parser.parse_args(["--verbose", "--version"])
assert vars(options) == {'verbose': 1, 'show_version': 1}, vars(options)
assert args == []
print "ok: 9"


# Now, see what happens when a later option completely overrides
# all of the option strings for an earlier option.
parser.remove_option("--verbose")
parser.remove_option("--version")
parser.add_option("-n", "--dry-run",
                  action="store_true", dest="dry_run",
                  help="don't do anything")
parser.add_option("--dry-run", "-n",
                  action="store_const", const=42, dest="dry_run",
                  help="dry run mode")
opt = parser.get_option("--dry-run")
assert opt._short_opts == ["-n"]
assert opt._long_opts == ["--dry-run"]
print "ok: 10"

sys.stdout = StringIO()
try:
    parser.parse_args(["-h"])
except SystemExit, err:
    stdout = sys.stdout.getvalue()
    sys.stdout = sys.__stdout__
    assert err[0] == 0
    assert stdout == """\
options:
  -h, --help     show this help message and exit
  -n, --dry-run  dry run mode
"""
    print "ok: 11"
else:
    print "not ok"

(options, args) = parser.parse_args(["-n"])
assert options.dry_run == 42
assert args == []
print "ok: 12"
