#!/usr/bin/env python
# To use:
#       python setup.py install
#
import os, sys, string, re
from glob import glob
if not hasattr(sys, 'version_info') or sys.version_info < (2,0,0,'alpha',0):
    raise SystemExit, "Python 2.0 or later required to build Numeric."
import distutils
from distutils.core import setup, Extension

headers = glob (os.path.join ("Include","Numeric","*.h"))

# The version is set in Lib/numeric_version.py
execfile(os.path.join('Lib','numeric_version.py'))

mathlibs = ['m']
define_macros = [('HAVE_INVERSE_HYPERBOLIC',None)]
undef_macros = []
# You might need to add a case here for your system
if sys.platform == 'win32':
    mathlibs = []
    define_macros = []
    undef_macros = ['HAVE_INVERSE_HYPERBOLIC']
elif sys.platform == 'beos5':
    mathlibs = []

# delete all but the first one in this list if using your own LAPACK/BLAS
sourcelist = ['Src/lapack_litemodule.c',
              'Src/blas_lite.c', 
              'Src/f2c_lite.c', 
              'Src/zlapack_lite.c',
              'Src/dlapack_lite.c'
             ]
# set these to use your own BLAS
library_dirs_list = []
libraries_list = []

setup (name = "Numeric",
       version = version,
       maintainer = "Numerical Python Developers",
       maintainer_email = "numpy-developers@lists.sourceforge.net",
       description = "Numerical Extension to Python",
       url = "http://numpy.sourceforge.net",

       packages = [''],
       package_dir = {'': 'Lib'},
       extra_path = 'Numeric',
       include_dirs = ['Include'],
       headers = headers,
       ext_modules = [Extension('_numpy',
                                ['Src/_numpymodule.c',
                                 'Src/arrayobject.c',
                                 'Src/ufuncobject.c']),
                      Extension('multiarray', ['Src/multiarraymodule.c']),
                      Extension('umath', ['Src/umathmodule.c'],
                                libraries=mathlibs,
                                define_macros=define_macros,
                                undef_macros=undef_macros),
                      Extension('arrayfns',
                                ['Src/arrayfnsmodule.c']),
                      Extension('ranlib',
                                ['Src/ranlibmodule.c',
                                 'Src/ranlib.c',
                                 'Src/com.c',
                                 'Src/linpack.c']),
                      Extension('lapack_lite', sourcelist,
                           library_dirs=library_dirs_list,
                           libraries = libraries_list) 
                     ]
       )
print "Numeric Version", version

