
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <fame.h>

#include <unistd.h>
#include <time.h>
#include <sys/time.h>

// Returns current time in microseconds
unsigned int GetTimer(){
  struct timeval tv;
  struct timezone tz;
//  float s;
  gettimeofday(&tv,&tz);
//  s=tv.tv_usec;s*=0.000001;s+=tv.tv_sec;
  return (tv.tv_sec*1000000+tv.tv_usec);
}  

int frames=100;

fame_parameters_t params;
fame_yuv_t yuv;

#define BUFFBAZZE 0x100000
unsigned char bufi[BUFFBAZZE];

int main(){
fame_context_t *ctx;
int len,i,x,y;
FILE *f=fopen("out.mpg","wb");
unsigned int t0,t1;
float t=0;

params.width=720;
params.height=576;
//params.coding="IPPPPP";
params.coding="I";
params.quality=90;
params.bitrate=0; // bitrate=VBR
params.slices_per_frame=1;
params.frames_per_sequence=0xffffffff;
params.frame_rate_num=25;
params.frame_rate_den=1;
params.shape_quality=100;
params.search_range=8;
params.verbose=1;
params.profile=NULL; // TODO

ctx=fame_open();
if(!ctx){printf("open error\n");return 0;}
fame_init(ctx,&params,bufi,BUFFBAZZE);

yuv.w=params.width;
yuv.h=params.height;
yuv.y=malloc(yuv.w*yuv.h);
yuv.u=malloc(yuv.w*yuv.h/4);
yuv.v=malloc(yuv.w*yuv.h/4);


t0=GetTimer();

for(i=0;i<frames;i++){

//------------------------------
t0-=GetTimer();
for(y=0;y<yuv.h;y++)
  for(x=0;x<yuv.w;x++){
//    yuv.y[yuv.w*y+x]=x&255;
    yuv.y[yuv.w*y+x]=128+127.0*sin(t*0.6524+y*0.17832+cos(x*0.3275227));
  }
for(y=0;y<yuv.h/2;y++)
  for(x=0;x<yuv.w/2;x++){
    yuv.u[(yuv.w/2)*y+x]=128+127.0*sin(t*0.8263+y*0.23456315+cos(x*0.276227));
    yuv.v[(yuv.w/2)*y+x]=128+127.0*sin(t+y*0.15+cos(x*0.12782));
  }
t=t+0.2;
t0+=GetTimer();
//------------------------------


    len=fame_encode_frame(ctx, &yuv, NULL);
    fwrite(bufi,len,1,f);
    printf("len=%d\n",len);
}

len=fame_close(ctx);
fwrite(bufi,len,1,f);

t0=GetTimer()-t0;
printf("\n*** time = %8.3f fps: %5.1f cpu: %d %% ***\n",(float)(t0*0.000001),
    (float)(frames/(0.000001*(float)t0)),
    (int)((100*0.000001*(float)t0)/(frames/25.0))
    );

fclose(f);

}


