/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define HUFFMAXRUN 32

static fame_vlc_t rlehuff_table[511] =
{
  { 0x8001, 16},
  { 0x8002, 16},
  { 0x8003, 16},
  { 0x8004, 16},
  { 0x8005, 16},
  { 0x8006, 16},
  { 0x8007, 16},
  { 0x8008, 16},
  { 0x8009, 16},
  { 0x800A, 16},
  { 0x800B, 16},
  { 0x800C, 16},
  { 0x800D, 16},
  { 0x800E, 16},
  { 0x800F, 16},
  { 0x8010, 16},
  { 0x8011, 16},
  { 0x8012, 16},
  { 0x8013, 16},
  { 0x8014, 16},
  { 0x8015, 16},
  { 0x8016, 16},
  { 0x8017, 16},
  { 0x8018, 16},
  { 0x8019, 16},
  { 0x801A, 16},
  { 0x801B, 16},
  { 0x801C, 16},
  { 0x801D, 16},
  { 0x801E, 16},
  { 0x801F, 16},
  { 0x8020, 16},
  { 0x8021, 16},
  { 0x8022, 16},
  { 0x8023, 16},
  { 0x8024, 16},
  { 0x8025, 16},
  { 0x8026, 16},
  { 0x8027, 16},
  { 0x8028, 16},
  { 0x8029, 16},
  { 0x802A, 16},
  { 0x802B, 16},
  { 0x802C, 16},
  { 0x802D, 16},
  { 0x802E, 16},
  { 0x802F, 16},
  { 0x8030, 16},
  { 0x8031, 16},
  { 0x8032, 16},
  { 0x8033, 16},
  { 0x8034, 16},
  { 0x8035, 16},
  { 0x8036, 16},
  { 0x8037, 16},
  { 0x8038, 16},
  { 0x8039, 16},
  { 0x803A, 16},
  { 0x803B, 16},
  { 0x803C, 16},
  { 0x803D, 16},
  { 0x803E, 16},
  { 0x803F, 16},
  { 0x8040, 16},
  { 0x8041, 16},
  { 0x8042, 16},
  { 0x8043, 16},
  { 0x8044, 16},
  { 0x8045, 16},
  { 0x8046, 16},
  { 0x8047, 16},
  { 0x8048, 16},
  { 0x8049, 16},
  { 0x804A, 16},
  { 0x804B, 16},
  { 0x804C, 16},
  { 0x804D, 16},
  { 0x804E, 16},
  { 0x804F, 16},
  { 0x8050, 16},
  { 0x8051, 16},
  { 0x8052, 16},
  { 0x8053, 16},
  { 0x8054, 16},
  { 0x8055, 16},
  { 0x8056, 16},
  { 0x8057, 16},
  { 0x8058, 16},
  { 0x8059, 16},
  { 0x805A, 16},
  { 0x805B, 16},
  { 0x805C, 16},
  { 0x805D, 16},
  { 0x805E, 16},
  { 0x805F, 16},
  { 0x8060, 16},
  { 0x8061, 16},
  { 0x8062, 16},
  { 0x8063, 16},
  { 0x8064, 16},
  { 0x8065, 16},
  { 0x8066, 16},
  { 0x8067, 16},
  { 0x8068, 16},
  { 0x8069, 16},
  { 0x806A, 16},
  { 0x806B, 16},
  { 0x806C, 16},
  { 0x806D, 16},
  { 0x806E, 16},
  { 0x806F, 16},
  { 0x8070, 16},
  { 0x8071, 16},
  { 0x8072, 16},
  { 0x8073, 16},
  { 0x8074, 16},
  { 0x8075, 16},
  { 0x8076, 16},
  { 0x8077, 16},
  { 0x8078, 16},
  { 0x8079, 16},
  { 0x807A, 16},
  { 0x807B, 16},
  { 0x807C, 16},
  { 0x807D, 16},
  { 0x807E, 16},
  { 0x807F, 16},
  { 0x8080, 16},
  { 0x0081, 8},
  { 0x0082, 8},
  { 0x0083, 8},
  { 0x0084, 8},
  { 0x0085, 8},
  { 0x0086, 8},
  { 0x0087, 8},
  { 0x0088, 8},
  { 0x0089, 8},
  { 0x008A, 8},
  { 0x008B, 8},
  { 0x008C, 8},
  { 0x008D, 8},
  { 0x008E, 8},
  { 0x008F, 8},
  { 0x0090, 8},
  { 0x0091, 8},
  { 0x0092, 8},
  { 0x0093, 8},
  { 0x0094, 8},
  { 0x0095, 8},
  { 0x0096, 8},
  { 0x0097, 8},
  { 0x0098, 8},
  { 0x0099, 8},
  { 0x009A, 8},
  { 0x009B, 8},
  { 0x009C, 8},
  { 0x009D, 8},
  { 0x009E, 8},
  { 0x009F, 8},
  { 0x00A0, 8},
  { 0x00A1, 8},
  { 0x00A2, 8},
  { 0x00A3, 8},
  { 0x00A4, 8},
  { 0x00A5, 8},
  { 0x00A6, 8},
  { 0x00A7, 8},
  { 0x00A8, 8},
  { 0x00A9, 8},
  { 0x00AA, 8},
  { 0x00AB, 8},
  { 0x00AC, 8},
  { 0x00AD, 8},
  { 0x00AE, 8},
  { 0x00AF, 8},
  { 0x00B0, 8},
  { 0x00B1, 8},
  { 0x00B2, 8},
  { 0x00B3, 8},
  { 0x00B4, 8},
  { 0x00B5, 8},
  { 0x00B6, 8},
  { 0x00B7, 8},
  { 0x00B8, 8},
  { 0x00B9, 8},
  { 0x00BA, 8},
  { 0x00BB, 8},
  { 0x00BC, 8},
  { 0x00BD, 8},
  { 0x00BE, 8},
  { 0x00BF, 8},
  { 0x00C0, 8},
  { 0x00C1, 8},
  { 0x00C2, 8},
  { 0x00C3, 8},
  { 0x00C4, 8},
  { 0x00C5, 8},
  { 0x00C6, 8},
  { 0x00C7, 8},
  { 0x00C8, 8},
  { 0x00C9, 8},
  { 0x00CA, 8},
  { 0x00CB, 8},
  { 0x00CC, 8},
  { 0x00CD, 8},
  { 0x00CE, 8},
  { 0x00CF, 8},
  { 0x00D0, 8},
  { 0x00D1, 8},
  { 0x00D2, 8},
  { 0x00D3, 8},
  { 0x00D4, 8},
  { 0x00D5, 8},
  { 0x00D6, 8},
  { 0x00D7, 8},
  { 0x00D8, 8},
  { 0x00D9, 8},
  { 0x00DA, 8},
  { 0x00DB, 8},
  { 0x00DC, 8},
  { 0x00DD, 8},
  { 0x00DE, 8},
  { 0x00DF, 8},
  { 0x00E0, 8},
  { 0x00E1, 8},
  { 0x00E2, 8},
  { 0x00E3, 8},
  { 0x00E4, 8},
  { 0x00E5, 8},
  { 0x00E6, 8},
  { 0x00E7, 8},
  { 0x00E8, 8},
  { 0x00E9, 8},
  { 0x00EA, 8},
  { 0x00EB, 8},
  { 0x00EC, 8},
  { 0x00ED, 8},
  { 0x00EE, 8},
  { 0x00EF, 8},
  { 0x00F0, 8},
  { 0x00F1, 8},
  { 0x00F2, 8},
  { 0x00F3, 8},
  { 0x00F4, 8},
  { 0x00F5, 8},
  { 0x00F6, 8},
  { 0x00F7, 8},
  { 0x00F8, 8},
  { 0x00F9, 8},
  { 0x00FA, 8},
  { 0x00FB, 8},
  { 0x00FC, 8},
  { 0x00FD, 8},
  { 0x00FE, 8},
  { 0x00FF, 8},
  { 0x0000, 8},
  { 0x0001, 8},
  { 0x0002, 8},
  { 0x0003, 8},
  { 0x0004, 8},
  { 0x0005, 8},
  { 0x0006, 8},
  { 0x0007, 8},
  { 0x0008, 8},
  { 0x0009, 8},
  { 0x000A, 8},
  { 0x000B, 8},
  { 0x000C, 8},
  { 0x000D, 8},
  { 0x000E, 8},
  { 0x000F, 8},
  { 0x0010, 8},
  { 0x0011, 8},
  { 0x0012, 8},
  { 0x0013, 8},
  { 0x0014, 8},
  { 0x0015, 8},
  { 0x0016, 8},
  { 0x0017, 8},
  { 0x0018, 8},
  { 0x0019, 8},
  { 0x001A, 8},
  { 0x001B, 8},
  { 0x001C, 8},
  { 0x001D, 8},
  { 0x001E, 8},
  { 0x001F, 8},
  { 0x0020, 8},
  { 0x0021, 8},
  { 0x0022, 8},
  { 0x0023, 8},
  { 0x0024, 8},
  { 0x0025, 8},
  { 0x0026, 8},
  { 0x0027, 8},
  { 0x0028, 8},
  { 0x0029, 8},
  { 0x002A, 8},
  { 0x002B, 8},
  { 0x002C, 8},
  { 0x002D, 8},
  { 0x002E, 8},
  { 0x002F, 8},
  { 0x0030, 8},
  { 0x0031, 8},
  { 0x0032, 8},
  { 0x0033, 8},
  { 0x0034, 8},
  { 0x0035, 8},
  { 0x0036, 8},
  { 0x0037, 8},
  { 0x0038, 8},
  { 0x0039, 8},
  { 0x003A, 8},
  { 0x003B, 8},
  { 0x003C, 8},
  { 0x003D, 8},
  { 0x003E, 8},
  { 0x003F, 8},
  { 0x0040, 8},
  { 0x0041, 8},
  { 0x0042, 8},
  { 0x0043, 8},
  { 0x0044, 8},
  { 0x0045, 8},
  { 0x0046, 8},
  { 0x0047, 8},
  { 0x0048, 8},
  { 0x0049, 8},
  { 0x004A, 8},
  { 0x004B, 8},
  { 0x004C, 8},
  { 0x004D, 8},
  { 0x004E, 8},
  { 0x004F, 8},
  { 0x0050, 8},
  { 0x0051, 8},
  { 0x0052, 8},
  { 0x0053, 8},
  { 0x0054, 8},
  { 0x0055, 8},
  { 0x0056, 8},
  { 0x0057, 8},
  { 0x0058, 8},
  { 0x0059, 8},
  { 0x005A, 8},
  { 0x005B, 8},
  { 0x005C, 8},
  { 0x005D, 8},
  { 0x005E, 8},
  { 0x005F, 8},
  { 0x0060, 8},
  { 0x0061, 8},
  { 0x0062, 8},
  { 0x0063, 8},
  { 0x0064, 8},
  { 0x0065, 8},
  { 0x0066, 8},
  { 0x0067, 8},
  { 0x0068, 8},
  { 0x0069, 8},
  { 0x006A, 8},
  { 0x006B, 8},
  { 0x006C, 8},
  { 0x006D, 8},
  { 0x006E, 8},
  { 0x006F, 8},
  { 0x0070, 8},
  { 0x0071, 8},
  { 0x0072, 8},
  { 0x0073, 8},
  { 0x0074, 8},
  { 0x0075, 8},
  { 0x0076, 8},
  { 0x0077, 8},
  { 0x0078, 8},
  { 0x0079, 8},
  { 0x007A, 8},
  { 0x007B, 8},
  { 0x007C, 8},
  { 0x007D, 8},
  { 0x007E, 8},
  { 0x007F, 8},
  { 0x0080, 16},
  { 0x0081, 16},
  { 0x0082, 16},
  { 0x0083, 16},
  { 0x0084, 16},
  { 0x0085, 16},
  { 0x0086, 16},
  { 0x0087, 16},
  { 0x0088, 16},
  { 0x0089, 16},
  { 0x008A, 16},
  { 0x008B, 16},
  { 0x008C, 16},
  { 0x008D, 16},
  { 0x008E, 16},
  { 0x008F, 16},
  { 0x0090, 16},
  { 0x0091, 16},
  { 0x0092, 16},
  { 0x0093, 16},
  { 0x0094, 16},
  { 0x0095, 16},
  { 0x0096, 16},
  { 0x0097, 16},
  { 0x0098, 16},
  { 0x0099, 16},
  { 0x009A, 16},
  { 0x009B, 16},
  { 0x009C, 16},
  { 0x009D, 16},
  { 0x009E, 16},
  { 0x009F, 16},
  { 0x00A0, 16},
  { 0x00A1, 16},
  { 0x00A2, 16},
  { 0x00A3, 16},
  { 0x00A4, 16},
  { 0x00A5, 16},
  { 0x00A6, 16},
  { 0x00A7, 16},
  { 0x00A8, 16},
  { 0x00A9, 16},
  { 0x00AA, 16},
  { 0x00AB, 16},
  { 0x00AC, 16},
  { 0x00AD, 16},
  { 0x00AE, 16},
  { 0x00AF, 16},
  { 0x00B0, 16},
  { 0x00B1, 16},
  { 0x00B2, 16},
  { 0x00B3, 16},
  { 0x00B4, 16},
  { 0x00B5, 16},
  { 0x00B6, 16},
  { 0x00B7, 16},
  { 0x00B8, 16},
  { 0x00B9, 16},
  { 0x00BA, 16},
  { 0x00BB, 16},
  { 0x00BC, 16},
  { 0x00BD, 16},
  { 0x00BE, 16},
  { 0x00BF, 16},
  { 0x00C0, 16},
  { 0x00C1, 16},
  { 0x00C2, 16},
  { 0x00C3, 16},
  { 0x00C4, 16},
  { 0x00C5, 16},
  { 0x00C6, 16},
  { 0x00C7, 16},
  { 0x00C8, 16},
  { 0x00C9, 16},
  { 0x00CA, 16},
  { 0x00CB, 16},
  { 0x00CC, 16},
  { 0x00CD, 16},
  { 0x00CE, 16},
  { 0x00CF, 16},
  { 0x00D0, 16},
  { 0x00D1, 16},
  { 0x00D2, 16},
  { 0x00D3, 16},
  { 0x00D4, 16},
  { 0x00D5, 16},
  { 0x00D6, 16},
  { 0x00D7, 16},
  { 0x00D8, 16},
  { 0x00D9, 16},
  { 0x00DA, 16},
  { 0x00DB, 16},
  { 0x00DC, 16},
  { 0x00DD, 16},
  { 0x00DE, 16},
  { 0x00DF, 16},
  { 0x00E0, 16},
  { 0x00E1, 16},
  { 0x00E2, 16},
  { 0x00E3, 16},
  { 0x00E4, 16},
  { 0x00E5, 16},
  { 0x00E6, 16},
  { 0x00E7, 16},
  { 0x00E8, 16},
  { 0x00E9, 16},
  { 0x00EA, 16},
  { 0x00EB, 16},
  { 0x00EC, 16},
  { 0x00ED, 16},
  { 0x00EE, 16},
  { 0x00EF, 16},
  { 0x00F0, 16},
  { 0x00F1, 16},
  { 0x00F2, 16},
  { 0x00F3, 16},
  { 0x00F4, 16},
  { 0x00F5, 16},
  { 0x00F6, 16},
  { 0x00F7, 16},
  { 0x00F8, 16},
  { 0x00F9, 16},
  { 0x00FA, 16},
  { 0x00FB, 16},
  { 0x00FC, 16},
  { 0x00FD, 16},
  { 0x00FE, 16},
  { 0x00FF, 16}
};
               
static unsigned long huff_table0[] =
                { 0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d, 0x2f,
                  0x31, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2b, 0x2d,
		  0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b, 0x3d,
		  0x3f, 0x2f, 0x31, 0x33, 0x35, 0x21, 0x27, 0x31,
		  0x3b, 0x15, 0x43, 0x4d, 0x0d, 0x0b, 0x09, 0x07,
		  0x00, 0x06, 0x08, 0x0a, 0x0c, 0x4c, 0x42, 0x14,
		  0x3a, 0x30, 0x26, 0x20, 0x34, 0x32, 0x30, 0x2e,
		  0x3e, 0x3c, 0x3a, 0x38, 0x36, 0x34, 0x32, 0x30,
		  0x2e, 0x2c, 0x2a, 0x28, 0x26, 0x24, 0x22, 0x20,
		  0x30, 0x2e, 0x2c, 0x2a, 0x28, 0x26, 0x24, 0x22,
		  0x20 };
static unsigned long huff_bits0[] = { 16, 16, 16, 16, 16, 16, 16, 16,
		 16, 15, 15, 15, 15, 15, 15, 15,
		 15, 15, 15, 15, 15, 15, 15, 15,
		 15, 14, 14, 14, 14, 13, 13, 13,
		 13, 11,  9,  9,  8,  6,  5,  3,
		 0,  3,  5,  6,  8,  9,  9, 11,
		 13, 13, 13, 13, 14, 14, 14, 14,
		 15, 15, 15, 15, 15, 15, 15, 15,
		 15, 15, 15, 15, 15, 15, 15, 15,
		 16, 16, 16, 16, 16, 16, 16, 16,
		 16 };

static unsigned long huff_table1[] = { 0x21, 0x23, 0x25, 0x27, 0x33, 0x35, 0x37, 0x39,
		  0x3b, 0x3d, 0x3f, 0x2b, 0x2d, 0x37, 0x19, 0x4b,
		  0x0d, 0x07, 0x00, 0x06, 0x0c, 0x4a, 0x18, 0x36,
		  0x2c, 0x2a, 0x3e, 0x3c, 0x3a, 0x38, 0x36, 0x34,
		  0x32, 0x26, 0x24, 0x22, 0x20 };
static unsigned long huff_bits1[] = { 17, 17, 17, 17, 16, 16, 16, 16,
		 16, 16, 16, 14, 14, 13, 11,  9,
		  7,  4,  0,  4,  7,  9, 11, 13,
		 14, 14, 16, 16, 16, 16, 16, 16,
		 16, 17, 17, 17, 17 };

static unsigned long huff_table2[] = { 0x29, 0x29, 0x17, 0x09, 0x0b, 0x00, 0x0a, 0x08,
		  0x16, 0x28, 0x28 };
static unsigned long huff_bits2[] = { 14, 13, 11,  8,  5,  0,  5,  8,
		 11, 13, 14 }; 

static unsigned long huff_table3[] = { 0x27, 0x39, 0x49, 0x0f, 0x00, 0x0e, 0x48, 0x38,
		  0x26 };
static unsigned long huff_bits3[] = { 14, 13, 9, 6, 0, 6, 9, 13,
		 14 };

static unsigned long huff_table4[] = { 0x25, 0x1f, 0x0d, 0x00, 0x0c, 0x1e, 0x24 };
static unsigned long huff_bits4[] = { 13, 11, 6, 0, 6, 11, 13 };

static unsigned long huff_table5[] = { 0x25, 0x13, 0x0f, 0x00, 0x0e, 0x12, 0x24 };
static unsigned long huff_bits5[] = { 14, 11, 7, 0, 7, 11, 14 };

static unsigned long huff_table6[] = { 0x29, 0x3d, 0x0b, 0x00, 0x0a, 0x3c, 0x28 };
static unsigned long huff_bits6[] = { 17, 13, 7, 0, 7, 13, 17 };

static unsigned long huff_table7[] = { 0x2b, 0x09, 0x00, 0x08, 0x2a };
static unsigned long huff_bits7[] = { 13, 7, 0, 7, 13 };

static unsigned long huff_table8[] = { 0x23, 0x0f, 0x00, 0x0e, 0x22 };
static unsigned long huff_bits8[] = {13, 8, 0, 8, 13 };

static unsigned long huff_table9[] = {0x23, 0x0b, 0x00, 0x0a, 0x22 };
static unsigned long huff_bits9[] = {14, 8, 0, 8, 14 };

static unsigned long huff_table10[] = {0x21, 0x4f, 0x00, 0x4e, 0x20 };
static unsigned long huff_bits10[] = {14, 9, 0, 9, 14 };

static unsigned long huff_table11[] = {0x35, 0x47, 0x00, 0x46, 0x34 };
static unsigned long huff_bits11[] = {17, 9, 0, 9, 17 };

static unsigned long huff_table12[] = {0x33, 0x45, 0x00, 0x44, 0x32 };
static unsigned long huff_bits12[] = {17, 9, 0, 9, 17 };

static unsigned long huff_table13[] = {0x31, 0x41, 0x00, 0x40, 0x30 };
static unsigned long huff_bits13[] = {17, 9, 0, 9, 17 };

static unsigned long huff_table14[] = {0x2f, 0x1d, 0x00, 0x1c, 0x2e };
static unsigned long huff_bits14[] = {17, 11, 0, 11, 17 };

static unsigned long huff_table15[] = {0x2d, 0x1b, 0x00, 0x1a, 0x2c };
static unsigned long huff_bits15[] = {17, 11, 0, 11, 17 };

static unsigned long huff_table16[] = {0x2b, 0x11, 0x00, 0x10, 0x2a };
static unsigned long huff_bits16[] = {17, 11, 0, 11, 17 }; 

static unsigned long huff_table17[] = {0x3f, 0x00, 0x3e };
static unsigned long huff_bits17[] = {13, 0, 13 };

static unsigned long huff_table18[] = {0x35, 0x00, 0x34 };
static unsigned long huff_bits18[] = {13, 0, 13 };

static unsigned long huff_table19[] = {0x33, 0x00, 0x32 };
static unsigned long huff_bits19[] = {13, 0, 13 };

static unsigned long huff_table20[] = {0x2f, 0x00, 0x2e };
static unsigned long huff_bits20[] = {13, 0, 13 };

static unsigned long huff_table21[] = {0x2d, 0x00, 0x2c };
static unsigned long huff_bits21[] = {13, 0, 13 };

static unsigned long huff_table22[] = {0x3f, 0x00, 0x3e };
static unsigned long huff_bits22[] = {14, 0, 14 };

static unsigned long huff_table23[] = {0x3d, 0x00, 0x3c };
static unsigned long huff_bits23[] = {14, 0, 14 }; 

static unsigned long huff_table24[] = {0x3b, 0x00, 0x3a };
static unsigned long huff_bits24[] = {14, 0, 14 };

static unsigned long huff_table25[] = {0x39, 0x00, 0x38 };
static unsigned long huff_bits25[] = {14, 0, 14 };

static unsigned long huff_table26[] = {0x37, 0x00, 0x36 };
static unsigned long huff_bits26[] = {14, 0, 14 };

static unsigned long huff_table27[] = {0x3f, 0x00, 0x3e };
static unsigned long huff_bits27[] = {17, 0, 17 };

static unsigned long huff_table28[] = {0x3d, 0x00, 0x3c };
static unsigned long huff_bits28[] = {17, 0, 17 };

static unsigned long huff_table29[] = {0x3b, 0x00, 0x3a };
static unsigned long huff_bits29[] = {17, 0, 17 };

static unsigned long huff_table30[] = {0x39, 0x00, 0x38 };
static unsigned long huff_bits30[] = {17, 0, 17 };

static unsigned long huff_table31[] = {0x37, 0x00, 0x36 };
static unsigned long huff_bits31[] = {17, 0, 17 };

static unsigned long * const huff_table[] = {
   huff_table0,
   huff_table1,
   huff_table2,
   huff_table3,
   huff_table4,
   huff_table5,
   huff_table6,
   huff_table7,
   huff_table8,
   huff_table9,
   huff_table10,
   huff_table11,
   huff_table12,
   huff_table13,
   huff_table14,
   huff_table15,
   huff_table16,
   huff_table17,
   huff_table18,
   huff_table19,
   huff_table20,
   huff_table21,
   huff_table22,
   huff_table23,
   huff_table24,
   huff_table25,
   huff_table26,
   huff_table27,
   huff_table28,
   huff_table29,
   huff_table30,
   huff_table31
};
                
static unsigned long * const huff_bits[] = {
   huff_bits0,
   huff_bits1,
   huff_bits2,
   huff_bits3,
   huff_bits4,
   huff_bits5,
   huff_bits6,
   huff_bits7,
   huff_bits8,
   huff_bits9,
   huff_bits10,
   huff_bits11,
   huff_bits12,
   huff_bits13,
   huff_bits14,
   huff_bits15,
   huff_bits16,
   huff_bits17,
   huff_bits18,
   huff_bits19,
   huff_bits20,
   huff_bits21,
   huff_bits22,
   huff_bits23,
   huff_bits24,
   huff_bits25,
   huff_bits26,
   huff_bits27,
   huff_bits28,
   huff_bits29,
   huff_bits30,
   huff_bits31
};

static short rlehuff_max_level[32] = 
{41,19, 6, 5, 4, 4, 4, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2 };
