/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jem.internal.proxy.core.BaseProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.DebugModeHelper;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMCallbackRegistry;
import org.eclipse.jem.internal.proxy.remote.REMCallbackThread;
import org.eclipse.jem.internal.proxy.remote.REMConnection;
import org.eclipse.jem.internal.proxy.remote.REMRegistryController;

public class REMProxyFactoryRegistry
extends BaseProxyFactoryRegistry {
    public static final String REMOTE_REGISTRY_TYPE_ID = "org.eclipse.jem.REMOTE";
    protected int fServerPort = 0;
    protected REMCallbackRegistry fCallbackServer;
    protected Stack fConnectionPool = new Stack();
    protected static int NUMBER_FREE_CONNECTIONS = 5;
    protected IProcess fProcess;
    protected String fName;
    protected int fCallbackServerPort;
    protected Integer fRegistryKey;
    protected REMRegistryController fRegistryController;
    protected static final Object TERMINATE_JOB_FAMILY = new Object();
    boolean fNoTimeouts = false;
    static boolean fGlobalNoTimeouts = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/remote/debug/notimeouts")));
    private WaitForRegistrationThread waitRegistrationThread;
    private IDebugEventSetListener processListener = null;

    public static void setGlobalNoTimeouts(boolean noTimeouts) {
        fGlobalNoTimeouts = noTimeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REMProxyFactoryRegistry(REMRegistryController registryController, String name) {
        super(REMOTE_REGISTRY_TYPE_ID);
        this.fRegistryController = registryController;
        this.fRegistryKey = this.fRegistryController.registerRegistry(this);
        this.fName = name;
        REMProxyFactoryRegistry rEMProxyFactoryRegistry = this;
        synchronized (rEMProxyFactoryRegistry) {
            this.waitRegistrationThread = new WaitForRegistrationThread();
            this.waitRegistrationThread.start();
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public Integer getRegistryKey() {
        return this.fRegistryKey;
    }

    public void initializeRegistry(IProcess process) {
        this.fProcess = process;
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent e = events[i];
                    if (e.getSource() == REMProxyFactoryRegistry.this.fProcess && e.getKind() == 8) {
                        IStreamsProxy stProxy = REMProxyFactoryRegistry.this.fProcess.getStreamsProxy();
                        StringWriter s = new StringWriter();
                        PrintWriter w = new PrintWriter(s);
                        String msg = MessageFormat.format(ProxyRemoteMessages.Proxy_Terminated_too_soon_ERROR_, REMProxyFactoryRegistry.this.fName);
                        w.println(msg);
                        w.println(ProxyRemoteMessages.VM_TERMINATED_INFO_);
                        w.println(ProxyRemoteMessages.VM_COMMAND_LINE);
                        w.println(REMProxyFactoryRegistry.this.fProcess.getAttribute(IProcess.ATTR_CMDLINE));
                        w.println(ProxyRemoteMessages.VM_TERMINATED_LINE1);
                        w.println(stProxy.getErrorStreamMonitor().getContents());
                        w.println(ProxyRemoteMessages.VM_TERMINATED_LINE2);
                        w.println(stProxy.getOutputStreamMonitor().getContents());
                        w.println(ProxyRemoteMessages.VM_TERMINATED_LINE3);
                        w.close();
                        DebugModeHelper dh = new DebugModeHelper();
                        dh.displayErrorMessage(ProxyRemoteMessages.Proxy_Error_Title, msg);
                        ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, s.toString(), null));
                        REMProxyFactoryRegistry.this.processListener = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        REMProxyFactoryRegistry.this.terminateRegistry();
                        break;
                    }
                    ++i;
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public ICallbackRegistry getCallbackRegistry() {
        if (this.fCallbackServer == null) {
            this.fCallbackServer = new REMCallbackRegistry(this.fName, this);
        }
        return this.fCallbackServer;
    }

    public static void cancelAllTerminateJobs() {
        IJobManager jobManager = Platform.getJobManager();
        jobManager.cancel(TERMINATE_JOB_FAMILY);
        try {
            jobManager.join(TERMINATE_JOB_FAMILY, null);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registryTerminated(boolean wait) {
        if (this.processListener != null) {
            DebugPlugin db = DebugPlugin.getDefault();
            if (db != null) {
                db.removeDebugEventListener(this.processListener);
            }
            this.processListener = null;
        }
        TerminateProcess tjob = null;
        if (this.waitRegistrationThread != null) {
            WaitForRegistrationThread waitForRegistrationThread = this.waitRegistrationThread;
            synchronized (waitForRegistrationThread) {
                WaitForRegistrationThread wThread = this.waitRegistrationThread;
                this.waitRegistrationThread = null;
                wThread.notifyAll();
            }
        }
        if (this.fServerPort != 0) {
            IREMConnection closeCon = null;
            Stack stack = this.fConnectionPool;
            synchronized (stack) {
                Iterator itr = this.fConnectionPool.iterator();
                if (itr.hasNext()) {
                    closeCon = (IREMConnection)itr.next();
                }
                while (itr.hasNext()) {
                    IREMConnection con = (IREMConnection)itr.next();
                    con.close();
                }
            }
            if (closeCon == null) {
                try {
                    closeCon = this.getFreeConnection();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (closeCon != null) {
                closeCon.terminateServer();
            }
            this.fConnectionPool.clear();
            this.fServerPort = 0;
            if (this.fProcess != null && !this.fRegistryController.inShutDown()) {
                tjob = new TerminateProcess(this.fProcess);
                tjob.setSystem(true);
                tjob.schedule();
                this.fProcess = null;
            }
        }
        if (this.fCallbackServer != null) {
            this.fCallbackServer.requestShutdown();
            this.fCallbackServer = null;
        }
        this.fConnectionPool.clear();
        this.fRegistryController.deregisterRegistry(this.fRegistryKey);
        if (wait && tjob != null) {
            try {
                tjob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getServerPort() {
        return this.fServerPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServerPort(int serverport) {
        this.fServerPort = serverport;
        if (this.waitRegistrationThread != null) {
            WaitForRegistrationThread waitForRegistrationThread = this.waitRegistrationThread;
            synchronized (waitForRegistrationThread) {
                WaitForRegistrationThread wThread = this.waitRegistrationThread;
                this.waitRegistrationThread = null;
                wThread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IREMConnection getFreeConnection() throws IllegalStateException {
        Thread thread = Thread.currentThread();
        if (thread instanceof REMCallbackThread) {
            REMCallbackThread callbackThread = (REMCallbackThread)thread;
            if (callbackThread.registry == this && !callbackThread.inTransaction()) {
                IREMConnection c = callbackThread.getConnection();
                if (c.isConnected()) {
                    return c;
                }
                throw new IllegalStateException(ProxyRemoteMessages.REMProxyFactoryRegistry_CallbackConnectionNotWorking_EXC_);
            }
        }
        Stack stack = this.fConnectionPool;
        synchronized (stack) {
            if (!this.fConnectionPool.isEmpty()) {
                return (IREMConnection)this.fConnectionPool.pop();
            }
            return this.createConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IREMConnection createConnection() throws IllegalStateException {
        if (this.fServerPort != 0) {
            final Socket[] scArray = new Socket[1];
            final boolean[] waiting = new boolean[]{true};
            Thread doIt = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Socket sc = new Socket("localhost", REMProxyFactoryRegistry.this.fServerPort);
                        2 var2_3 = this;
                        synchronized (var2_3) {
                            if (waiting[0]) {
                                scArray[0] = sc;
                            } else {
                                sc.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    }
                }
            });
            doIt.start();
            while (true) {
                try {
                    doIt.join(!this.fNoTimeouts ? 60000 : 0);
                    Thread thread = doIt;
                    synchronized (thread) {
                        waiting[0] = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            if (scArray[0] == null) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)new IllegalStateException(ProxyRemoteMessages.REMProxyFactoryRegistry_ConnectionCreationFailed_INFO_)));
                throw new IllegalStateException(ProxyRemoteMessages.REMProxyFactoryRegistry_CouldNotCreateSocketConnectionToRemoteVM_EXC_);
            }
            REMConnection connection = new REMConnection(scArray[0], this.fNoTimeouts);
            if (connection.isConnected()) {
                return connection;
            }
            try {
                scArray[0].close();
            }
            catch (IOException iOException) {}
        } else {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "No Server to retrieve a connection.", null));
        }
        throw new IllegalStateException(ProxyRemoteMessages.REMProxyFactoryRegistry_CouldNotCreateSocketConnectionToRemoteVM_EXC_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(IREMConnection connection) {
        Thread thread;
        if (connection.isConnected() && (!((thread = Thread.currentThread()) instanceof REMCallbackThread) || ((REMCallbackThread)thread).getConnection() != connection)) {
            Stack stack = this.fConnectionPool;
            synchronized (stack) {
                if (this.fConnectionPool.size() < NUMBER_FREE_CONNECTIONS) {
                    this.fConnectionPool.push(connection);
                } else {
                    connection.close();
                }
            }
        }
    }

    public void closeConnection(IREMConnection connection) {
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connectionCount() {
        Stack stack = this.fConnectionPool;
        synchronized (stack) {
            return this.fConnectionPool.size();
        }
    }

    private class WaitForRegistrationThread
    extends Thread {
        public WaitForRegistrationThread() {
            super("Wait for remote vm registration thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Stack stack = REMProxyFactoryRegistry.this.fConnectionPool;
            synchronized (stack) {
                Object object = REMProxyFactoryRegistry.this;
                synchronized (object) {
                    REMProxyFactoryRegistry.this.notifyAll();
                }
                object = this;
                synchronized (object) {
                    long stopTime = System.currentTimeMillis() + 60000L;
                    while (REMProxyFactoryRegistry.this.waitRegistrationThread != null && (REMProxyFactoryRegistry.this.fNoTimeouts || System.currentTimeMillis() < stopTime)) {
                        try {
                            Thread.currentThread().wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            REMProxyFactoryRegistry.this.waitRegistrationThread = null;
        }
    }

    private static class TerminateProcess
    extends Job {
        private IProcess process;

        public TerminateProcess(IProcess process) {
            super(ProxyRemoteMessages.REMProxyFactoryRegistry_Job_TerminateProcess_Title);
            this.process = process;
        }

        public boolean belongsTo(Object family) {
            return family == TERMINATE_JOB_FAMILY || super.belongsTo(family);
        }

        public IStatus run(IProgressMonitor mon) {
            try {
                int i = 0;
                while (!this.process.isTerminated() && i < 100) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
                if (!this.process.isTerminated()) {
                    this.process.terminate();
                }
            }
            catch (DebugException debugException) {}
            return Status.OK_STATUS;
        }
    }
}

