#!/usr/bin/perl
#
# Test writing TIFF images
#
# Contributed by Bob Friesenhahn <bfriesen@simple.dallas.tx.us>
#
BEGIN { $| = 1; $test=1; print "1..10\n"; }
END {print "not ok $test\n" unless $loaded;}

use Image::Magick;
$loaded=1;

require 't/subroutines.pl';

chdir 't/tiff' || die 'Cd failed';

#
# 1) Test 4-bit pseudocolor image
#
print("PseudoColor image (4 bits/sample) ...\n");
testReadWrite( 'input_16.tiff',
  'output_16.tiff',
  q//,
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  'c7308e9b6c8fe20479b02b1e4890eb13d8fbc79c001dd138b5ec9eed23c39690');

#
# 2) Test 8-bit pseudocolor image
#
++$test;
print("PseudoColor image (8 bits/sample) ...\n");
testReadWrite( 'input_256.tiff',
  'output_256.tiff',
  q//,
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  'e77f78b3bbfefe57b5981e60a6bf08c137aa527395fe7f206cd69198eb08ddd0');

#
# 3) Test 4-bit pseudocolor + matte channel image
#
++$test;
print("PseudoColor image (4 bits/sample + matte channel) ...\n");
testReadWrite( 'input_16_matte.tiff',
  'output_16_matte.tiff',
  q//,
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  '1502b4e5747ed8805fe9103f56f9c4097f60440b3a867fa6b1ae0ba81f12a90d',
  'c7308e9b6c8fe20479b02b1e4890eb13d8fbc79c001dd138b5ec9eed23c39690' );

#
# 4) Test 8-bit pseudocolor + matte channel image
#
++$test;
print("PseudoColor image (8 bits/sample + matte channel) ...\n");
testReadWrite( 'input_256_matte.tiff',
  'output_256_matte.tiff',
  q//,
  '5577f9f604340f3f564ee28632981ff7f88b451ca1693d222369d02f2cde8a81',
  '5577f9f604340f3f564ee28632981ff7f88b451ca1693d222369d02f2cde8a81',
  '01f9d29ebea733fb815dcccfa1fb769cf223d60d8bfbce47b8329d119587de15' );

#
# 5) Test truecolor image
#
++$test;
print("TrueColor image (8 bits/sample) ...\n");
testReadWrite( 'input_truecolor.tiff',
  'output_truecolor.tiff',
  q/quality=>55/,
  '489aed63f0c516497a59881cd42ae99579bd962a3b5346a8820c1f47a1ebf80c' );

#
# 6) Test monochrome image
#
++$test;
print("Gray image (1 bit per sample) ...\n");
testReadWrite(  'input_mono.tiff',
  'output_mono.tiff',
  q//,
  'c3db0a928eb365a8d4c132fccf913174f22864253e3974d89e7af6b81f57b14e' );

#
# 7) Test gray 4 bit image
#
++$test;
print("Gray image (4 bits per sample) ...\n");
testReadWrite(  'input_gray_4bit.tiff',
  'output_gray_4bit.tiff',
  q//,
  'fb23dac3a20f8c0c0ad2b4a6c3b318aafe27a8dcc937a2eddd94adb54e4ec162' );

#
# 8) Test gray 8 bit image
#
++$test;
print("Gray image (8 bits per sample) ...\n");
testReadWrite(  'input_gray_8bit.tiff',
  'output_gray_8bit.tiff',
  q//,
  '3aa1d0e0c053c38146de36126054eb007175e3b1fd4a92f09bed59452e991a2d' );

#
# 9) Test gray 4 bit image (with matte channel)
#
++$test;
print("Gray image (4 bits per sample + matte channel) ...\n");
testReadWrite(  'input_gray_4bit_matte.tiff',
  'output_gray_4bit_matte.tiff',
  q//,
  'bab8bea9a756e476845511e1d02498a2aa66aeadf45126b303ff328cd13eb573',
  'bab8bea9a756e476845511e1d02498a2aa66aeadf45126b303ff328cd13eb573',
  '20fc50f858dcd84aeb29097fe8067f2f0b8059d535d81fcdf51045f28aebe905' );

#
# 10) Test gray 8 bit image (with matte channel)
#
++$test;
print("Gray image (8 bits per sample + matte channel) ...\n");
testReadWrite(  'input_gray_8bit_matte.tiff',
  'output_gray_8bit_matte.tiff',
  q//,
  '1d09012a9334266bc64255cfc8305a89afba602a93e29bec0c793851f8bb01e7',
  '1d09012a9334266bc64255cfc8305a89afba602a93e29bec0c793851f8bb01e7' );
