##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################


HOTFIX_ID = 'Hotfix_2001-09-28'

apply_hotfix = 0
try:
    from App.Hotfixes import beforeApplyHotfix
    # Require Zope 2.2.x.
    apply_hotfix = beforeApplyHotfix(HOTFIX_ID, 2, 2, 0)
except ImportError:
    # No hotfix module exists yet.
    apply_hotfix = 1
    from zLOG import LOG, INFO
    LOG('Hotfix', INFO, 'Applying %s.' % HOTFIX_ID)


if apply_hotfix:

    from string import rfind
    import sys
    from DocumentTemplate.DT_Var import special_formats, Var

    # Apply a patch to DT_Var.render().

    def render(self, md):
        args=self.args
        have_arg=args.has_key
        name=self.__name__

        val=self.expr

        if val is None:
            if md.has_key(name):
                if have_arg('url'):
                    val=md.getitem(name,0)
                    val=val.absolute_url()
                else:
                    val = md[name]
            else:
                if have_arg('missing'):
                    return args['missing']
                else:
                    raise KeyError, name
        else:
            val=val.eval(md)
            if have_arg('url'): val=val.absolute_url()

        __traceback_info__=name, val, args

        if have_arg('null') and not val and val != 0:
            # check for null (false but not zero, including None, [], '')
            return args['null']
            

        # handle special formats defined using fmt= first
        if have_arg('fmt'):
            _get = getattr(md, 'guarded_getattr', None)
            if _get is None:
                _get = getattr

            fmt=args['fmt']
            if have_arg('null') and not val and val != 0:
                try:
                    if hasattr(val, fmt):
                        val = _get(val, fmt)()
                    elif special_formats.has_key(fmt):
                        val = special_formats[fmt](val, name, md)
                    elif fmt=='': val=''
                    else: val = fmt % val
                except:
                    t, v = sys.exc_info()[:2]
                    if val is None or not str(val): return args['null']
                    raise t, v

            else:
                # We duplicate the code here to avoid exception handler
                # which tends to screw up stack or leak
                if hasattr(val, fmt):
                    val = _get(val, fmt)()
                elif special_formats.has_key(fmt):
                    val = special_formats[fmt](val, name, md)
                elif fmt=='': val=''
                else: val = fmt % val

        # finally, pump it through the actual string format...
        fmt=self.fmt
        if fmt=='s': val=str(val)
        else: val = ('%'+self.fmt) % (val,)

        # next, look for upper, lower, etc
        for f in self.modifiers: val=f(val)

        if have_arg('size'):
            size=args['size']
            try: size=int(size)
            except: raise 'Document Error',(
                '''a <code>size</code> attribute was used in a <code>var</code>
                tag with a non-integer value.''')
            if len(val) > size:
                val=val[:size]
                l=rfind(val, ' ')
                if l > size/2:
                    val=val[:l+1]
                if have_arg('etc'): l=args['etc']
                else: l='...'
                val=val+l

        return val


    Var.render = render
    Var.__call__ = render

