/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *             
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdxv.h,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/

#ifndef DVD_XVIDEO
#define DVD_XVIDEO 

#ifdef HAVE_XV


#include <xincs.h>

class XVAdaptor;

typedef FXObjectListOf<XVAdaptor>   AdaptorList;


class XVProperty : public FXObject{
  FXDECLARE(XVProperty);
public:
  FXApp *  app;
  FXint    port;
  FXint    attr;
  FXString name;
  FXbool   get;
  FXbool   set;
  FXint    value;
  FXint    max;
  FXint    min;
  Atom     xatom;
private:
  XVProperty(){}
public:
  enum {
    ID_CHECK_PROPERTY,
    ID_SLIDER_PROPERTY,
    ID_SLIDERTEXT_PROPERTY,
    ID_COLOR_PROPERTY,
    ID_FUNCTION_PROPERTY,
    }; 
public:
  XVProperty(FXApp * a,FXint p,FXint aa) {port=p;attr=aa;app=a;}
  ~XVProperty(){}

  long onCmdCheckProperty(FXObject *,FXSelector,void*);
  long onUpdCheckProperty(FXObject *,FXSelector,void*);

  long onCmdSliderProperty(FXObject *,FXSelector,void*);
  long onUpdSliderProperty(FXObject *,FXSelector,void*);

  long onCmdColorProperty(FXObject *,FXSelector,void*);
  long onUpdColorProperty(FXObject *,FXSelector,void*);

  long onCmdFunctionProperty(FXObject *,FXSelector,void*);
  long onUpdFunctionProperty(FXObject *,FXSelector,void*);
  };  


typedef FXObjectListOf<XVProperty>  XVPropertyList;


class XVController : public FXObject{
  FXDECLARE(XVController)
private:
  AdaptorList adaptors;
  FXuint version;
  FXuint release;
  FXuint event;
private:
  XVController() {} 
public:
  XVController(FXApp * app);  

  FXint getNumAdaptors() {return adaptors.no();}
  XVAdaptor * getAdaptor(FXint i) { return adaptors[i];}

  FXuint getVersion() { return version;}
  FXuint getRelease() { return release;} 
  FXuint getEventBase() { return event;}

  void setPropertyValue(FXuint port,Atom xatom,FXint value);

  virtual ~XVController();
  };


class XVAdaptor : public FXObject{
FXDECLARE(XVAdaptor)
private:
  XVPropertyList checkproperty;
  XVPropertyList valueproperty;
  XVPropertyList colorproperty;
  XVPropertyList functionproperty;
  FXString name;
  FXint base;
  FXint port;
private:
  XVAdaptor() {} 
public:
  XVAdaptor(FXApp * app, FXString name,FXint base, FXint ports);

  FXint getNumCheckProperties()     { return checkproperty.no(); }
  FXint getNumValueProperties()     { return valueproperty.no(); }
  FXint getNumColorProperties()     { return colorproperty.no(); }
  FXint getNumFunctionProperties()  { return functionproperty.no(); }

  XVProperty * getCheckProperty(FXint i)    { return checkproperty[i];   }
  XVProperty * getValueProperty(FXint i)    { return valueproperty[i];   }
  XVProperty * getColorProperty(FXint i)    { return colorproperty[i];   } 
  XVProperty * getFunctionProperty(FXint i) { return functionproperty[i];}

  FXString getName() { return name; }

  virtual ~XVAdaptor();
  };
#endif

#endif

