/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *             
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdxv.cpp,v 1.1.1.1 2003/02/05 06:47:48 sander Exp $
*/
#ifdef HAVE_XV
#include <xincs.h>
#include <X11/extensions/Xvlib.h>
#include <fx.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "dvdxv.h"

#define DISPLAY ((Display*)(app->getDisplay()))

FXDEFMAP(XVProperty) XVPropertyMap[]={
  FXMAPFUNC(SEL_COMMAND,XVProperty::ID_CHECK_PROPERTY,XVProperty::onCmdCheckProperty),
  FXMAPFUNC(SEL_UPDATE, XVProperty::ID_CHECK_PROPERTY,XVProperty::onUpdCheckProperty),
  FXMAPFUNC(SEL_CHANGED,XVProperty::ID_SLIDER_PROPERTY,XVProperty::onCmdSliderProperty),
  FXMAPFUNC(SEL_COMMAND,XVProperty::ID_SLIDER_PROPERTY,XVProperty::onCmdSliderProperty),
  FXMAPFUNC(SEL_UPDATE, XVProperty::ID_SLIDER_PROPERTY,XVProperty::onUpdSliderProperty),
  FXMAPFUNC(SEL_UPDATE, XVProperty::ID_SLIDERTEXT_PROPERTY,XVProperty::onUpdSliderProperty),
  FXMAPFUNC(SEL_CHANGED,XVProperty::ID_COLOR_PROPERTY,XVProperty::onCmdColorProperty),
  FXMAPFUNC(SEL_COMMAND,XVProperty::ID_COLOR_PROPERTY,XVProperty::onCmdColorProperty),
  FXMAPFUNC(SEL_UPDATE, XVProperty::ID_COLOR_PROPERTY,XVProperty::onUpdColorProperty),
  FXMAPFUNC(SEL_COMMAND,XVProperty::ID_FUNCTION_PROPERTY,XVProperty::onCmdFunctionProperty),
  FXMAPFUNC(SEL_UPDATE, XVProperty::ID_FUNCTION_PROPERTY,XVProperty::onUpdFunctionProperty),


  };

FXIMPLEMENT(XVProperty,FXObject,XVPropertyMap,ARRAYNUMBER(XVPropertyMap));


long XVProperty::onCmdCheckProperty(FXObject *,FXSelector,void*){
  if (value) value=0; else value=1;
  XvSetPortAttribute(DISPLAY,port,xatom,value);
  return 1;
  }
long XVProperty::onUpdCheckProperty(FXObject *sender,FXSelector,void*){
  if (value)  
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);

  if (set)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);    
  return 1;
  }


long XVProperty::onCmdSliderProperty(FXObject *,FXSelector,void*ptr){
  value = (FXint)(FXival)ptr;
  XvSetPortAttribute(DISPLAY,port,xatom,value);
  return 1;
  }
long XVProperty::onUpdSliderProperty(FXObject *sender,FXSelector,void*){
  sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&value);
  if (set)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);    
  return 1;
  }



long XVProperty::onCmdColorProperty(FXObject *,FXSelector,void*ptr){
  value = app->getDefaultVisual()->getPixel((FXint)(FXival)(ptr));
  XvSetPortAttribute(DISPLAY,port,xatom,value);
  return 1;
  }
long XVProperty::onUpdColorProperty(FXObject *sender,FXSelector,void*){
  FXint color = app->getDefaultVisual()->getColor(value);  
  sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&color);
  if (set)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);    
  return 1;
  }

long XVProperty::onCmdFunctionProperty(FXObject *,FXSelector,void*ptr){
  XvSetPortAttribute(DISPLAY,port,xatom,min);
  return 1;
  }

long XVProperty::onUpdFunctionProperty(FXObject *sender,FXSelector,void*){
  if (set)
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL);    
  return 1;
  }

FXIMPLEMENT(XVController,FXObject,NULL,0);

XVController::XVController(FXApp * app){
  FXuint request,error;
  FXuint num_adaptors = 0;
  XvAdaptorInfo *adaptor_info;
  XVAdaptor * adaptor;

  if (XvQueryExtension(DISPLAY,&version,&release,&request,&event,&error)==Success){    
    XvQueryAdaptors(DISPLAY,app->getRootWindow()->id(),&num_adaptors,&adaptor_info);  
    for(FXint i=0;i<num_adaptors;i++){   
      adaptor = new XVAdaptor(app,adaptor_info[i].name,adaptor_info[i].base_id,adaptor_info[i].num_ports);
      adaptors.append(adaptor);
      }      
    XvFreeAdaptorInfo(adaptor_info);
    }
  }

XVController::~XVController(){
  for(FXint i=0;i<adaptors.no();i++){   
    delete adaptors[i];
    }
  }

void XVController::setPropertyValue(FXuint port,Atom xatom,FXint value){
  for(FXint i=0;i<adaptors.no();i++){   
    for (FXint j=0;j<adaptors[i]->getNumCheckProperties();j++){
      if (adaptors[i]->getCheckProperty(j)->xatom==xatom && adaptors[i]->getCheckProperty(j)->port==port){
        adaptors[i]->getCheckProperty(j)->value=value;
        return;
        }
      }
  
    for (FXint j=0;j<adaptors[i]->getNumValueProperties();j++){
      if (adaptors[i]->getValueProperty(j)->xatom==xatom && adaptors[i]->getValueProperty(j)->port==port){
        adaptors[i]->getValueProperty(j)->value=value;
        return;
        }
      }

    for (FXint j=0;j<adaptors[i]->getNumColorProperties();j++){
      if (adaptors[i]->getColorProperty(j)->xatom==xatom && adaptors[i]->getColorProperty(j)->port==port){
        adaptors[i]->getColorProperty(j)->value=value;
        return;
        }
      }
    }
  }




FXIMPLEMENT(XVAdaptor,FXObject,NULL,0);

XVAdaptor::XVAdaptor(FXApp * app,FXString n, FXint b, FXint p){
  XVProperty  *xvproperty;
  XvAttribute *xvattr;
  FXint numattr;
  name=n;
  base=b;
  port=p;

  for(FXint i=base;i<base+port;i++){
    XvSelectPortNotify(DISPLAY,i,True);
    xvattr = XvQueryPortAttributes(DISPLAY,i,&numattr);
    for (FXint j=0;j<numattr;j++){
      xvproperty = new XVProperty(app,i,j);
      xvproperty->min  = xvattr[j].min_value;
      xvproperty->max  = xvattr[j].max_value;
      xvproperty->get  = (xvattr[j].flags & XvGettable);
		  xvproperty->set  = (xvattr[j].flags & XvSettable);
      xvproperty->name = xvattr[j].name;
      xvproperty->xatom= XInternAtom(DISPLAY, xvattr[j].name,False);
      if (xvproperty->get) {
        XvGetPortAttribute(DISPLAY,i,xvproperty->xatom,&xvproperty->value);
        }

      if (xvproperty->name=="XV_COLORKEY")
        colorproperty.append(xvproperty);
      else if (xvproperty->min==0 && xvproperty->max==1)
        checkproperty.append(xvproperty);
      else if (!xvproperty->get && xvproperty->min==xvproperty->max)
        functionproperty.append(xvproperty);
      else 
        valueproperty.append(xvproperty);
           
      /// Make nice and friendly names  
      if (xvproperty->name=="XV_COLORKEY") xvproperty->name="Colorkey";
      else if (xvproperty->name=="XV_HUE") xvproperty->name="Hue";
      else if (xvproperty->name=="XV_SATURATION") xvproperty->name="Saturation";
      else if (xvproperty->name=="XV_CONTRAST") xvproperty->name="Contrast";
      else if (xvproperty->name=="XV_BRIGHTNESS") xvproperty->name="Brightness";
      }
    XFree(xvattr);
    }
  }

XVAdaptor::~XVAdaptor(){
  for (FXint i=0;i<colorproperty.no();i++) delete colorproperty[i];
  for (FXint i=0;i<checkproperty.no();i++) delete checkproperty[i];
  for (FXint i=0;i<functionproperty.no();i++) delete functionproperty[i];
  for (FXint i=0;i<valueproperty.no();i++) delete valueproperty[i];
  }


#endif


