/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdwindow.h,v 1.5 2003/05/08 03:22:25 sander Exp $
*/

#ifndef DVD_WINDOW
#define DVD_WINDOW

#define DEFAULT_SHORTCUT_FULLSCREEN     "f"
#define DEFAULT_SHORTCUT_PAUSE          "p"
#define DEFAULT_SHORTCUT_STOP           "o"
#define DEFAULT_SHORTCUT_RAISE          "F1"
#define DEFAULT_SHORTCUT_NEXT           "Shift+>"
#define DEFAULT_SHORTCUT_PREVIOUS       "Shift+<"
#define DEFAULT_SHORTCUT_TITLEMENU      "t"
#define DEFAULT_SHORTCUT_ROOTMENU       "r"
#define DEFAULT_SHORTCUT_AUDIOMENU      "a"
#define DEFAULT_SHORTCUT_ANGLEMENU      "A"
#define DEFAULT_SHORTCUT_SUBPICTUREMENU   "s"
#define DEFAULT_SHORTCUT_SEARCHFORWARD  "."
#define DEFAULT_SHORTCUT_SEARCHBACKWARD ","
#define DEFAULT_SHORTCUT_ENTER          "enter"
#define DEFAULT_SHORTCUT_NAVUP          "up"
#define DEFAULT_SHORTCUT_NAVDOWN        "down"
#define DEFAULT_SHORTCUT_NAVLEFT        "left"
#define DEFAULT_SHORTCUT_NAVRIGHT       "right"

#define DEFAULTLANGUAGE "en"
#define DEFAULTCOUNTRY  "us"


#include <fx.h>


class FXScreenSaver;
class FXDPMS;

class bookmarkentry{
public:
  FXchar * navstate;
  FXint    entry;
  FXbool   autobook;
  bookmarkentry(FXchar * n,FXint e,FXbool a) {navstate=n;entry=e;autobook=a;}
  ~bookmarkentry() {FXFREE(&navstate);}
  };

class DVDWindow : public FXMainWindow {
  FXDECLARE(DVDWindow)
private: /// GUI Elements
  FXMenuPane       *filemenu;
  FXMenuPane       *gotomenu;
  FXMenuPane       *audiomenu;
  FXMenuPane       *anglemenu;
  FXMenuPane       *optionmenu;
  FXMenuPane       *subpicturemenu;
  FXMenuPane       *helpmenu;
  FXMenuPane       *bookmarkmenu;
  FXMenuButton     *audiotitle;
  FXMenuButton     *subpicturetitle;
  FXMenuButton     *angletitle;
  FXLabel *         timelabel;
  FXLabel *         titlelabel;
  FXLabel *         chapterlabel;
  FXTextField *     dvdidlabel;
  FXLabel *         infolabel;
  FXSlider *        progressbar;
private: /// RESOURCES
  FXImage          *img_fifthplanet;
  FXImage          *img_gogglessmall;
  FXImage          *img_goggles;
  FXIcon           *icon_play;
  FXIcon           *icon_stop;
  FXIcon           *icon_pause;
  FXIcon           *icon_next;
  FXIcon           *icon_snext;
  FXIcon           *icon_previous;
  FXIcon           *icon_sprevious;
  FXIcon           *icon_enter;
  FXIcon           *icon_left;
  FXIcon           *icon_right;
  FXIcon           *icon_up;
  FXIcon           *icon_down;
  FXIcon           *icon_max;
  FXIcon           *icon_win;
  FXIcon           *icon_menu;
  FXIcon           *icon_sub;
  FXIcon           *icon_exit;
  FXIcon           *icon_goroot;
  FXIcon           *icon_goto;
  FXIcon           *icon_angle;
  FXIcon           *icon_bookopen_menu;
  FXIcon           *icon_bookopen;
  FXIcon           *icon_bookclose;
  FXIcon           *icon_bookclose_menu;
  FXIcon           *icon_subpicture;
  FXIcon           *icon_audio;
  FXIcon           *icon_dvdsmall;
  FXIcon           *icon_bookset;
  FXIcon           *icon_bookdel;
  FXIcon           *icon_goggles;
  FXIcon           *icon_clock;
  FXIcon           *icon_screenshot;
private:
  FXbool            auto_bookmark;
  FXbool            auto_show;
  FXbool            auto_disable;
  FXbool            auto_audiostream;
  FXbool            play_last_session;
  FXbool            filter_subpicture_entry;
  FXbool            start_fullscreen;
  FXbool            start_dvd;
  FXbool            show_info;
  FXbool            screenshot_with_spu;
private:
  FXbool            dvd_started;
  DVDUOP_t          uop;
  DVDDomain_t       dom;
  DVDBookmark_t *   dvdbookmark;
  DVDLocation_t     location;
  void*             navigator;
  FXint             last_title;
  FXint             last_chapter;
  FXuint            bookmark_no;
  FXuint            audio_id;
  FXuint            angle_id;
  FXuint            current_time;
  FXuint            total_time;
  FXuint            subpicture_id;
  FXbool            fullscreen;
  FXbool            pause;
  FXbool            is_seeking;
  FXdouble          fspeed;
  FXdouble          bspeed;
  FXString          dvdroot;
  FXString          bookmarkdir;
  FXString          timeinfo;
  FXString          volumeid;
  FXString          dvdid_string;
  FXuchar           dvdid[16];
  FXDataTarget      angle_target;
  FXDataTarget      audio_target;
  FXDataTarget      subpicture_target;
  FXbool            firstpopupmesssage;
  FXbool            disable_dpms;
  FXbool            disable_screensaver;
  FXScreenSaver  *  screensaver_manager;
  FXDPMS         *  dpms_manager;

protected: /// Internal Helper Functions
  void  createIcons();
  void  deleteIcons();
  void  readRegistry();
  void  writeRegistry();
  void  initCountryListBoxes(FXListBox * l1,FXString i1);
  void  initLanguageListBoxes(FXListBox * l1,FXListBox * l2,FXListBox * l3,FXString i1,FXString i2,FXString i3);
  void  initLanguageNames();
  void  initCountryNames();
  void  initOgle();
  void  initBookmarks();
  void  saveBookmarks();
  void  saveAutoBookmark();
  void  addBookmark(FXbool autobookmark=FALSE);
  FXbool  openDVD();
  FXbool  closeDVD();
  FXString  getSubpictureName(FXuint id);
  FXString  getAudioName(FXuint id);
  FXString  getLanguageName(DVDLangID_t);
  FXString  getCountryName(DVDCountryID_t);
  DVDLangID_t   getLanguageCode(FXString code);
  DVDCountryID_t getCountryCode(FXString code);
  void  update_angle_menu();
  void  update_audio_menu();
  void  update_subpicture_menu();
  void  openTitle(FXint title,FXint chapter);
private:
  DVDWindow(){}
  DVDWindow(const DVDWindow&);
  DVDWindow& operator=(const DVDWindow&);
public: /// Message Handlers
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onCmdOpen(FXObject*,FXSelector,void*);
  long onUpdOpen(FXObject*,FXSelector,void*);

  long onCmdPlay(FXObject*,FXSelector,void*);
  long onCmdStop(FXObject*,FXSelector,void*);
  long onCmdPause(FXObject*,FXSelector,void*);
  long onCmdNext(FXObject*,FXSelector,void*);
  long onCmdPrevious(FXObject*,FXSelector,void*);
  long onCmdSearchForward(FXObject*,FXSelector,void*);
  long onCmdSearchBackward(FXObject*,FXSelector,void*);

  long onCmdEnter(FXObject*,FXSelector,void*);
  long onCmdNavUp(FXObject*,FXSelector,void*);
  long onCmdNavDown(FXObject*,FXSelector,void*);
  long onCmdNavLeft(FXObject*,FXSelector,void*);
  long onCmdNavRight(FXObject*,FXSelector,void*);

  long onUpdPlay(FXObject*,FXSelector,void*);
  long onUpdStop(FXObject*,FXSelector,void*);
  long onUpdPause(FXObject*,FXSelector,void*);
  long onUpdNext(FXObject*,FXSelector,void*);
  long onUpdPrevious(FXObject*,FXSelector,void*);
  long onUpdSearchForward(FXObject*,FXSelector,void*);
  long onUpdSearchBackward(FXObject*,FXSelector,void*);

  /// Menus
  long onCmdMenuRoot(FXObject*,FXSelector,void*);
  long onCmdMenuTitle(FXObject*,FXSelector,void*);
  long onCmdMenuSubpicture(FXObject*,FXSelector,void*);
  long onCmdMenuAudio(FXObject*,FXSelector,void*);
  long onCmdMenuAngle(FXObject*,FXSelector,void*);
  long onCmdMenuPart(FXObject*,FXSelector,void*);

  long onUpdMenuRoot(FXObject*,FXSelector,void*);
  long onUpdMenuTitle(FXObject*,FXSelector,void*);
  long onUpdMenuSubpicture(FXObject*,FXSelector,void*);
  long onUpdMenuAudio(FXObject*,FXSelector,void*);
  long onUpdMenuAngle(FXObject*,FXSelector,void*);
  long onUpdMenuPart(FXObject*,FXSelector,void*);

  long onCmdChangeAngle(FXObject*,FXSelector,void*);
  long onCmdChangeAudio(FXObject*,FXSelector,void*);
  long onCmdChangeSubpicture(FXObject*,FXSelector,void*);

  long onUpdAngleMenu(FXObject*,FXSelector,void*);
  long onUpdAudioMenu(FXObject*,FXSelector,void*);
  long onUpdSubpictureMenu(FXObject*,FXSelector,void*);

  /// Bookmarks
  long onCmdBookmark(FXObject*,FXSelector,void*);
  long onCmdAddBookmark(FXObject*,FXSelector,void*);
  long onUpdAddBookmark(FXObject*,FXSelector,void*);

  long onCmdClearBookmarks(FXObject*,FXSelector,void*);
  long onUpdClearBookmarks(FXObject*,FXSelector,void*);

  long onCmdTitleDialog(FXObject*,FXSelector,void*);
  long onCmdTitleSelect(FXObject*,FXSelector,void*);
  long onUpdTitleDialog(FXObject*,FXSelector,void*);

  long onCmdFullScreen(FXObject*,FXSelector,void*);
  long onUpdFullScreen(FXObject*,FXSelector,void*);

  long onCmdRaiseControl(FXObject*,FXSelector,void*);

  long onCmdMenuPopup(FXObject*,FXSelector,void*);
  long onCmdSelectDirectory(FXObject*,FXSelector,void*);

  long onCmdCrop(FXObject*,FXSelector,void*);
  long onUpdCrop(FXObject*,FXSelector,void*);

  long onTimeout(FXObject*,FXSelector,void*);
  long onRefresh(FXObject*,FXSelector,void*);

  long onCmdOptions(FXObject*,FXSelector,void*);
  long onCmdEditShortCut(FXObject*,FXSelector,void*);

  long onCmdTimePlay(FXObject*,FXSelector,void*);
  long onSliderPress(FXObject*,FXSelector,void*);
  long onSliderRelease(FXObject*,FXSelector,void*);
  long onUpdSlider(FXObject*,FXSelector,void*);
  long onChgSlider(FXObject*,FXSelector,void*);

  long onCmdScreenShot(FXObject*,FXSelector,void*);
  long onUpdScreenShot(FXObject*,FXSelector,void*);

  long onCmdBrowseScreenshots(FXObject*,FXSelector,void*);
  long onUpdBrowseScreenshots(FXObject*,FXSelector,void*);

  long onCmdShowScreenshot(FXObject*,FXSelector,void*);

  long onUpdEnter(FXObject*,FXSelector,void*);
  long onUpdNavUp(FXObject*,FXSelector,void*);
  long onUpdNavDown(FXObject*,FXSelector,void*);
  long onUpdNavLeft(FXObject*,FXSelector,void*);
  long onUpdNavRight(FXObject*,FXSelector,void*);

public:
  enum{
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_SELF,
    ID_OPEN,
    ID_PLAY,
    ID_STOP,
    ID_PAUSE,
    ID_NEXT,
    ID_PREVIOUS,
    ID_SEARCH_FORWARD,
    ID_SEARCH_BACKWARD,
    ID_ENTER,
    ID_NAV_UP,
    ID_NAV_DOWN,
    ID_NAV_LEFT,
    ID_NAV_RIGHT,
    ID_MENU_ROOT,
    ID_MENU_TITLE,
    ID_MENU_SUBPICTURE,
    ID_MENU_AUDIO,
    ID_MENU_ANGLE,
    ID_MENU_PART,
    ID_CHANGE_AUDIO,
    ID_CHANGE_ANGLE,
    ID_CHANGE_SUBPICTURE,
    ID_CROP,
    ID_RAISE_CONTROL,
    ID_RAISE_TIMER,
    ID_TOGGLE_FULLSCREEN,
    ID_TITLE_DIALOG,
    ID_TITLE_LIST,
    ID_POPUP_MENU,
    ID_TIMEOUT,
    ID_SLIDER,
    ID_OPTIONS,
    ID_REFRESH,
    ID_SHORTCUT_BEGIN,
    ID_SHORTCUT_FULLSCREEN,
    ID_SHORTCUT_RAISE,
    ID_SHORTCUT_TITLEMENU,
    ID_SHORTCUT_ROOTMENU,
    ID_SHORTCUT_AUDIOMENU,
    ID_SHORTCUT_ANGLEMENU,
    ID_SHORTCUT_SUBPICTUREMENU,
    ID_SHORTCUT_PAUSE,
    ID_SHORTCUT_STOP,
    ID_SHORTCUT_NEXT,
    ID_SHORTCUT_PREVIOUS,
    ID_SHORTCUT_SEARCHFORWARD,
    ID_SHORTCUT_SEARCHBACKWARD,
    ID_SHORTCUT_ENTER,
    ID_SHORTCUT_UP,
    ID_SHORTCUT_DOWN,
    ID_SHORTCUT_LEFT,
    ID_SHORTCUT_RIGHT,
    ID_SHORTCUT_LAST,
    ID_GETBOOKMARKDIR,
    ID_GETDVDROOTDIR,
    ID_ADD_BOOKMARK,
    ID_CLEAR_BOOKMARKS,
    ID_BOOKMARK,
    ID_SCREENSHOT,
    ID_BROWSE_SCREENSHOTS,
    ID_SCREENSHOT_LIST,
    ID_LAST
    };
public:
  /// Create new dvd window
  DVDWindow(FXApp* a);

  /// Create window
  virtual void create();

  /// Set DVD Navigator
  void setNavigator(void * nav) {navigator=nav;}

  /// Destructor
  virtual ~DVDWindow();
  };

#endif
