/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvdpreferences.cpp,v 1.3 2003/05/08 03:22:25 sander Exp $
*/
#include <fx.h>

extern "C" {
#include <ogle/dvdcontrol.h>
}
#include "dvdapp.h"
#include "dvdwindow.h"
#include "dvddxr3.h"
#include "dvdxv.h"
#include "dvddesktop.h"




//----------------------------------------------------------------------------------
// Options Dialog -  FIXME
//----------------------------------------------------------------------------------
long DVDWindow::onCmdOptions(FXObject*,FXSelector,void*){
  DVDApp * dvdapp = dynamic_cast<DVDApp*>(getApp());

  const FXuint listboxstyle=LISTBOX_NORMAL|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y;
  const FXuint labelstyle=LAYOUT_CENTER_Y|LABEL_NORMAL|LAYOUT_RIGHT;
  const FXuint textfieldstyle=TEXTFIELD_ENTER_ONLY|LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_COLUMN;
 
  FXString bookmarkdir_backup=bookmarkdir;
  FXString dvdroot_backup=dvdroot;


  int region=getApp()->reg().readIntEntry("OGLE","player region",1);

  FXDataTarget target_start_fullscreen(start_fullscreen);
  FXDataTarget target_start_dvd(start_dvd);

  FXDataTarget target_auto_bookmark(auto_bookmark);
  FXDataTarget target_play_bookmark(play_last_session);

  FXDataTarget target_auto_show(auto_show);
  FXDataTarget target_dvdroot(dvdroot);
  FXDataTarget target_auto_disable(auto_disable);
  FXDataTarget target_dvdbookmarkdir(bookmarkdir);
  FXDataTarget target_subpic_filter(filter_subpicture_entry);
  FXDataTarget target_dpms(disable_dpms);
  FXDataTarget target_screensaver(disable_screensaver);
  FXDataTarget target_audiostream(auto_audiostream);
  FXDataTarget target_screenshot(screenshot_with_spu);

  FXDialogBox dialog(this,"Preferences",DECOR_ALL);
  FXVerticalFrame * main=new FXVerticalFrame(&dialog,LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0,0,0,0,0);
  FXTabBook * tabbook=new FXTabBook(main,NULL,0,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_RIGHT,0,0,0,0,0,0,0,0);


  FXGroupBox * grpbox;
  FXMatrix   * matrix;
  FXTextField *txtfld;
  FXVerticalFrame * vframe;

  /// GOGGLES SETTINGS PANEL
  /// ======================


  new FXTabItem(tabbook," &Goggles ",NULL);
  FXVerticalFrame * frame1 = new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);


  //  new FXCheckButton(main,"Open DVD on start up",&target_start_dvd,FXDataTarget::ID_VALUE);
//  new FXCheckButton(frame1,"Fullscreen on start up",&target_start_fullscreen,FXDataTarget::ID_VALUE);


  grpbox =  new FXGroupBox(frame1,"Features",FRAME_RIDGE|LAYOUT_FILL_X);


  new FXCheckButton(grpbox,"Auto Play - Automatically play dvd when Goggles starts.",&target_start_dvd,FXDataTarget::ID_VALUE);
  new FXCheckButton(grpbox,"Auto Raise - Show Goggles window when toggling fullscreen mode.",&target_auto_show,FXDataTarget::ID_VALUE);
  new FXCheckButton(grpbox,"Disable Menus - Disable menus if DVD asks for it.",&target_auto_disable,FXDataTarget::ID_VALUE);

  new FXCheckButton(grpbox,"Save Last Session  - When quiting Goggles save session.",&target_auto_bookmark,FXDataTarget::ID_VALUE);
  new FXCheckButton(grpbox,"Play Last Session  - Automatically play last session.",&target_play_bookmark,FXDataTarget::ID_VALUE);

  new FXCheckButton(grpbox,"Save Screenshots with subtitles.",&target_screenshot,FXDataTarget::ID_VALUE);


  grpbox =  new FXGroupBox(frame1,"Power Management / Screensaver",FRAME_RIDGE|LAYOUT_FILL_X);
  new FXCheckButton(grpbox,"Disable Screensaver.",&target_screensaver,FXDataTarget::ID_VALUE);
  FXCheckButton * check=new FXCheckButton(grpbox,"Disable Power Management.",&target_dpms,FXDataTarget::ID_VALUE);

  grpbox =  new FXGroupBox(frame1,"Ogle Bugfixes/Workarounds",FRAME_RIDGE|LAYOUT_FILL_X);

  new FXCheckButton(grpbox,"Filter Subpicture Menu - do not show empty entries.",&target_subpic_filter,FXDataTarget::ID_VALUE);
  new FXCheckButton(grpbox,"Always activate audiostream - if none is active, select first available.",&target_audiostream,FXDataTarget::ID_VALUE);

  if (!dpms_manager->isAvailable()){
    check->disable();
    disable_dpms=FALSE;
    }

 


  new FXTabItem(tabbook," &Ogle ",NULL);
  FXVerticalFrame * frame3 = new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);


  matrix=new FXMatrix(frame3,3,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);


  new FXLabel(matrix,"Device ",NULL,labelstyle);
  new FXTextField(matrix,15,&target_dvdroot,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_COLUMN);
  new FXButton(matrix,"...\tBrowse",NULL,this,ID_GETDVDROOTDIR);

  new FXLabel(matrix,"Bookmark Directory",NULL,labelstyle);
  new FXTextField(matrix,15,&target_dvdbookmarkdir,FXDataTarget::ID_VALUE,LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_COLUMN);
  new FXButton(matrix,"...\tBrowse",NULL,this,ID_GETBOOKMARKDIR);


  new FXLabel(matrix,"Player Region",NULL,labelstyle);
  FXListBox * regionlist = new FXListBox(matrix,7,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);

  /// Setup Parental Level
  regionlist->appendItem("Region 0");  
  regionlist->appendItem("Region 1");  
  regionlist->appendItem("Region 2");  
  regionlist->appendItem("Region 3");  
  regionlist->appendItem("Region 4");  
  regionlist->appendItem("Region 5");  
  regionlist->appendItem("Region 6");
  regionlist->setCurrentItem(region);  


  new FXLabel(matrix,"Parental Level",NULL,labelstyle);
  FXListBox * parentallist = new FXListBox(matrix,9,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);

  new FXLabel(matrix,"Parental Country",NULL,labelstyle);
  FXListBox * countrylist = new FXListBox(matrix,9,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);

  FXString def_country=getApp()->reg().readStringEntry("OGLE","parental country",DEFAULTCOUNTRY);

  initCountryListBoxes(countrylist,def_country);

  /// Setup Parental Level
  parentallist->appendItem("Parental Level 1");  
  parentallist->appendItem("Parental Level 2");  
  parentallist->appendItem("Parental Level 3");  
  parentallist->appendItem("Parental Level 4");  
  parentallist->appendItem("Parental Level 5");  
  parentallist->appendItem("Parental Level 6");  
  parentallist->appendItem("Parental Level 7");  
  parentallist->appendItem("Parental Level 8");  
  parentallist->appendItem("None");  


  /// Language Settings

  new FXLabel(matrix,"Default Audio Language",NULL,labelstyle);
  FXListBox * audiolanglist = new FXListBox(matrix,9,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);

  new FXLabel(matrix,"Default Subpicture Language",NULL,labelstyle);
  FXListBox * subpicturelanglist = new FXListBox(matrix,9,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);

  new FXLabel(matrix,"Default Menu Language",NULL,labelstyle);
  FXListBox * menulanglist = new FXListBox(matrix,9,NULL,0,listboxstyle);
  new FXFrame(matrix,FRAME_NONE);
  
  FXString def_audiolang=getApp()->reg().readStringEntry("OGLE","default audio language",DEFAULTLANGUAGE);
  FXString def_subpicturelang=getApp()->reg().readStringEntry("OGLE","default subpicture language",DEFAULTLANGUAGE);
  FXString def_menulang=getApp()->reg().readStringEntry("OGLE","default menu language",DEFAULTLANGUAGE);

  initLanguageListBoxes(audiolanglist,subpicturelanglist,menulanglist,def_audiolang,def_subpicturelang,def_menulang);








#ifdef HAVE_DXR3
  /// DXR3 SETTINGS PANEL
  /// ======================
  FXDXR3 dxr3device("/dev/em8300-0");

  FXTabItem * dxr3item = new FXTabItem(tabbook," &DXR3 ",NULL);
  FXVerticalFrame * frame2 = new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED);


  FXGroupBox * box0   = new FXGroupBox(frame2,"DXR3 Device",LAYOUT_FILL_X|FRAME_RIDGE);
  matrix=new FXMatrix(box0,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);
  new FXLabel(matrix,"Select Output Device: ",NULL,labelstyle);
  FXComboBox * dxr3devicelist = new FXComboBox(matrix,1,4,&dxr3device,FXDXR3::ID_DEVICESELECT,listboxstyle);

  dxr3devicelist->appendItem("/dev/em8300-0");  
  dxr3devicelist->appendItem("/dev/em8300-1");  
  dxr3devicelist->appendItem("/dev/em8300-2");  
  dxr3devicelist->appendItem("/dev/em8300-3");  

  FXGroupBox * box1   = new FXGroupBox(frame2,"Audio Output Mode",LAYOUT_FILL_X|FRAME_RIDGE);
  FXRadioButton* rda1 = new FXRadioButton(box1,"Digital AC3",&dxr3device,FXDXR3::ID_AUDIOMODE_AC3);
  FXRadioButton* rda2 = new FXRadioButton(box1,"Digital PCM",&dxr3device,FXDXR3::ID_AUDIOMODE_DIGITALPCM);
  FXRadioButton* rda3 = new FXRadioButton(box1,"Analog",&dxr3device,FXDXR3::ID_AUDIOMODE_ANALOG);

/*
  FXGroupBox * box2 = new FXGroupBox(frame2,"Video Mode",LAYOUT_FILL_X|FRAME_RIDGE);
  new FXRadioButton(box2,"PAL",&target_dxr3video_output,FXDataTarget::ID_OPTION+0);
  new FXRadioButton(box2,"PAL60",&target_dxr3video_output,FXDataTarget::ID_OPTION+1);
  new FXRadioButton(box2,"NTSC",&target_dxr3video_output,FXDataTarget::ID_OPTION+2);

  FXSlider * bcs[3];
  FXGroupBox * box3 = new FXGroupBox(frame2,"Video Mode",LAYOUT_FILL_X|FRAME_RIDGE);
  FXMatrix * mat3=new FXMatrix(box3,3,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(mat3,"Brightness");
  new FXTextField(mat3,5);
  bcs[0]=new FXSlider(mat3,NULL,0,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
  new FXLabel(mat3,"Contrast");
  new FXTextField(mat3,5);
  bcs[1]=new FXSlider(mat3,NULL,0,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);

  new FXLabel(mat3,"Saturation");
  new FXTextField(mat3,5);
  bcs[2]=new FXSlider(mat3,NULL,0,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
  bcs[0]->setRange(0,1000);
  bcs[1]->setRange(0,1000);
  bcs[2]->setRange(0,1000);

  int b,c,s;
  //dxr3_getVideoBCS("/dev/em8300-0",b,c,s);
  
  bcs[0]->setValue(b);
  bcs[1]->setValue(c);
  bcs[2]->setValue(s);
*/
#endif



#ifdef HAVE_XV

  /// XVIDEO SETTINGS PANEL
  /// ======================
  FXCheckButton * chck;
  FXHorizontalFrame * hfr; 
  FXSlider * slider;
  FXButton * button;
  XVAdaptor * adaptor;



  if (dvdapp->getXVControl()->getNumAdaptors()>0) {

    new FXTabItem(tabbook," &XVideo ",NULL);
    vframe= new FXVerticalFrame(tabbook,FRAME_THICK|FRAME_RAISED|LAYOUT_FILL_X|LAYOUT_FILL_Y);

    new FXLabel(vframe,FXStringFormat("XVideo v%d.%d",dvdapp->getXVControl()->getVersion(),dvdapp->getXVControl()->getRelease()),NULL,FRAME_SUNKEN|LAYOUT_FILL_X);
  
    matrix=new FXMatrix(vframe,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X,0,0,0,0,0,0,0,0);
    new FXLabel(matrix,"Configure Adaptor: ",NULL,labelstyle);
    FXListBox * adaptorlist = new FXListBox(matrix,4,NULL,0,listboxstyle);

    FXSwitcher * switcher = new FXSwitcher(vframe,LAYOUT_FILL_X|LAYOUT_FILL_Y);

    for (FXint i=0;i<dvdapp->getXVControl()->getNumAdaptors();i++){
      adaptor = dvdapp->getXVControl()->getAdaptor(i);
      adaptorlist->appendItem(adaptor->getName());
      FXVerticalFrame * vframe2 = new FXVerticalFrame(switcher,LAYOUT_FILL_X,0,0,0,0,0,0,0,0);
    
      if (adaptor->getNumColorProperties() && adaptor->getNumCheckProperties()) {
        hfr    = new FXHorizontalFrame(vframe2,LAYOUT_FILL_X|PACK_UNIFORM_HEIGHT,0,0,0,0,0,0,0,0);        
        grpbox = new FXGroupBox(hfr,"",FRAME_RIDGE|LAYOUT_FILL_X);      

        for (FXint j=0;j<adaptor->getNumCheckProperties();j++){
          chck = new FXCheckButton(grpbox,adaptor->getCheckProperty(j)->name,adaptor->getCheckProperty(j),XVProperty::ID_CHECK_PROPERTY);
          }

        grpbox=new FXGroupBox(hfr,"",FRAME_RIDGE|LAYOUT_FILL_X);
        matrix=new FXMatrix(grpbox,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X,0,0,0,0,0,0,0,0);

        for (FXint j=0;j<adaptor->getNumColorProperties();j++){
          FXColorWell * well = new FXColorWell(matrix,0,adaptor->getColorProperty(j),XVProperty::ID_COLOR_PROPERTY);
          new FXLabel(matrix,adaptor->getColorProperty(j)->name,NULL,ICON_BEFORE_TEXT|JUSTIFY_RIGHT|LAYOUT_CENTER_Y);
          }
        }
      else {
        if (adaptor->getNumCheckProperties()){
          grpbox = new FXGroupBox(vframe2,"",FRAME_RIDGE|LAYOUT_FILL_X);      

          for (FXint j=0;j<adaptor->getNumCheckProperties();j++){
            chck = new FXCheckButton(grpbox,adaptor->getCheckProperty(j)->name,adaptor->getCheckProperty(j),XVProperty::ID_CHECK_PROPERTY);
            }
          }
        if (adaptor->getNumColorProperties()){
          grpbox=new FXGroupBox(vframe2,"",FRAME_RIDGE|LAYOUT_FILL_X);
          matrix=new FXMatrix(grpbox,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X,0,0,0,0,0,0,0,0);

          for (FXint j=0;j<adaptor->getNumColorProperties();j++){
            FXColorWell * well = new FXColorWell(matrix,0,adaptor->getColorProperty(j),XVProperty::ID_COLOR_PROPERTY);
            new FXLabel(matrix,adaptor->getColorProperty(j)->name,NULL,ICON_BEFORE_TEXT|JUSTIFY_RIGHT|LAYOUT_CENTER_Y);
            }
          }
        }

    if (adaptor->getNumValueProperties()){
      grpbox=new FXGroupBox(vframe2,"",FRAME_RIDGE|LAYOUT_FILL_X);
      matrix=new FXMatrix(grpbox,3,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);

      for (FXint j=0;j<adaptor->getNumValueProperties();j++){
        new FXLabel(matrix,adaptor->getValueProperty(j)->name,NULL,LABEL_NORMAL|LAYOUT_CENTER_Y|JUSTIFY_LEFT);
        slider=new FXSlider(matrix,adaptor->getValueProperty(j),XVProperty::ID_SLIDER_PROPERTY,LAYOUT_FILL_X|LAYOUT_FILL_COLUMN|SLIDER_INSIDE_BAR|LAYOUT_CENTER_Y);
        slider->setRange(adaptor->getValueProperty(j)->min,adaptor->getValueProperty(j)->max);
        new FXTextField(matrix,5,adaptor->getValueProperty(j),XVProperty::ID_SLIDERTEXT_PROPERTY,TEXTFIELD_NORMAL|LAYOUT_CENTER_Y);
        }
      }

    if (adaptor->getNumFunctionProperties()){
      matrix=new FXMatrix(vframe2,4,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);

      for (FXint j=0;j<adaptor->getNumFunctionProperties();j++){
        new FXButton(matrix,adaptor->getFunctionProperty(j)->name,NULL,adaptor->getFunctionProperty(j),XVProperty::ID_FUNCTION_PROPERTY,BUTTON_INITIAL|BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0,20,20);
        }
      }
    }
  adaptorlist->setNumVisible(dvdapp->getXVControl()->getNumAdaptors());
  adaptorlist->setTarget(switcher);
  adaptorlist->setSelector(FXWindow::ID_SETVALUE);  
  }
#endif


//  new FXSeparator(vframe,LAYOUT_FILL_X|SEPARATOR_GROOVE);



//  new FXTextField(mat4,5,xvcontrol,ID_XV_BRIGHTNESS);
//  new FXTextField(mat4,5,xvcontrol,ID_XV_CONTRAST);
//  new FXTextField(mat4,5,xvcontrol,ID_XV_SATURATION);
//  new FXTextField(mat4,5,xvcontrol,ID_XV_HUE);
//  new FXTextField(mat4,5,xvcontrol,ID_XV_COLORKEY);


  //new FXSlider(mat3,xvcontrol,ID_XV_BRIGHTNESS,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
  //new FXSlider(mat3,xvcontrol,ID_XV_CONTRAST,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
  //new FXSlider(mat3,xvcontrol,ID_XV_SATURATION,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
 // new FXSlider(mat3,xvcontrol,ID_XV_HUE,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);
  //new FXSlider(mat3,xvcontrol,ID_XV_COLORKEY,LAYOUT_FILL_X|SLIDER_INSIDE_BAR|LAYOUT_FILL_COLUMN|LAYOUT_CENTER_Y);

//#endif

  /// Keyboard Shortcuts PANEL
  /// ======================

  new FXTabItem(tabbook," &Keyboard Shortcuts ",NULL);
  FXHorizontalFrame * frame4 = new FXHorizontalFrame(tabbook,FRAME_THICK|FRAME_RAISED);

  matrix=new FXMatrix(frame4,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);

  new FXLabel(matrix,"Fullscreen",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_FULLSCREEN,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Fullscreen",DEFAULT_SHORTCUT_FULLSCREEN));

  new FXLabel(matrix,"Bring GUI to Top",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_RAISE,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Raise",DEFAULT_SHORTCUT_RAISE));

  new FXLabel(matrix,"TitleMenu",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_TITLEMENU,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","TitleMenu",DEFAULT_SHORTCUT_TITLEMENU));

  new FXLabel(matrix,"RootMenu",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_ROOTMENU,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","RootMenu",DEFAULT_SHORTCUT_ROOTMENU));

  new FXLabel(matrix,"AudioMenu",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_AUDIOMENU,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","AudioMenu",DEFAULT_SHORTCUT_AUDIOMENU));
 
  new FXLabel(matrix,"AngleMenu",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_ANGLEMENU,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","AngleMenu",DEFAULT_SHORTCUT_ANGLEMENU));

  new FXLabel(matrix,"SubtitleMenu",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_SUBPICTUREMENU,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","SubtitleMenu",DEFAULT_SHORTCUT_SUBPICTUREMENU));

  new FXLabel(matrix,"Navigate Up",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_UP,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","NavUp",DEFAULT_SHORTCUT_NAVUP));

  new FXLabel(matrix,"Navigate Down",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_DOWN,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","NavDown",DEFAULT_SHORTCUT_NAVDOWN));

  matrix=new FXMatrix(frame4,2,MATRIX_BY_COLUMNS|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);

  new FXLabel(matrix,"Pause",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_PAUSE,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Pause",DEFAULT_SHORTCUT_PAUSE));

  new FXLabel(matrix,"Stop",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_STOP,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Stop",DEFAULT_SHORTCUT_STOP));
 
  new FXLabel(matrix,"Next Chapter",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_NEXT,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Next",DEFAULT_SHORTCUT_NEXT));

  new FXLabel(matrix,"Previous Chapter",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_PREVIOUS,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Previous",DEFAULT_SHORTCUT_PREVIOUS));

  new FXLabel(matrix,"Search Forward",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_SEARCHFORWARD,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","SearchForward",DEFAULT_SHORTCUT_SEARCHFORWARD));

  new FXLabel(matrix,"Search Backward",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_SEARCHBACKWARD,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","SearchBackward",DEFAULT_SHORTCUT_SEARCHBACKWARD));
 
  new FXLabel(matrix,"Enter/Activate",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_ENTER,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","Enter",DEFAULT_SHORTCUT_ENTER));

  new FXLabel(matrix,"Navigate Left",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_LEFT,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","NavLeft",DEFAULT_SHORTCUT_NAVLEFT));

  new FXLabel(matrix,"Navigate Right",NULL,labelstyle);
  txtfld=new FXTextField(matrix,8,this,DVDWindow::ID_SHORTCUT_RIGHT,textfieldstyle);
  txtfld->setText(getApp()->reg().readStringEntry("HotKeys","NavRight",DEFAULT_SHORTCUT_NAVRIGHT));

  // Bottom part
  FXHorizontalFrame *closebox=new FXHorizontalFrame(main,LAYOUT_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH,0,0,0,0,0,0,0,0);
  new FXButton(closebox," &Accept ",NULL,&dialog,FXDialogBox::ID_ACCEPT,BUTTON_INITIAL|BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);
  new FXButton(closebox," &Cancel ",NULL,&dialog,FXDialogBox::ID_CANCEL,BUTTON_DEFAULT|LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK,0,0,0,0, 20,20);


  if (dialog.execute(PLACEMENT_SCREEN)) {
    region=regionlist->getCurrentItem();
    getApp()->reg().writeIntEntry("OGLE","player region",region);

    
    def_country=(FXchar*)countrylist->getItemData(countrylist->getCurrentItem());
    getApp()->reg().writeStringEntry("OGLE","parental country",def_country.text());

    def_audiolang=(FXchar*)audiolanglist->getItemData(audiolanglist->getCurrentItem());
    getApp()->reg().writeStringEntry("OGLE","default audio language",def_audiolang.text());

    def_subpicturelang=(FXchar*)subpicturelanglist->getItemData(subpicturelanglist->getCurrentItem());
    getApp()->reg().writeStringEntry("OGLE","default subpicture language",def_subpicturelang.text());

    def_menulang=(FXchar*)menulanglist->getItemData(menulanglist->getCurrentItem());
    getApp()->reg().writeStringEntry("OGLE","default menu language",def_menulang.text());

#ifdef HAVE_DXR3
#endif
    if (!FXFile::exists(bookmarkdir)){
      bookmarkdir=bookmarkdir_backup;
      }

    if (disable_screensaver) 
      screensaver_manager->disable();
    else
      screensaver_manager->restore();

    if (disable_dpms) 
      dpms_manager->disable(); 
    else   
      dpms_manager->restore();

    initOgle();
    }
  else{
    bookmarkdir=bookmarkdir_backup;
    dvdroot=dvdroot_backup;
    }

  return 1;
  }
