/*******************************************************************************
*               Goggles - Graphical User Interface for OGLE                    *
********************************************************************************
*        Copyright (C) 2002-2003 by Sander Jansen. All Rights Reserved         *
*                               ---                                            *             
* This program is free software; you can redistribute it and/or modify         *
* it under the terms of the GNU General Public License as published by         *
* the Free Software Foundation; either version 2 of the License, or            *
* (at your option) any later version.                                          *
*                                                                              *
* This program is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                *
* GNU General Public License for more details.                                 *
* You should have received a copy of the GNU General Public License            *
* along with this program; if not, write to the Free Software                  *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*******************************************************************************/

/*
$Id: dvddesktop.h,v 1.1 2003/05/08 03:22:25 sander Exp $
*/

#ifndef DESKTOP_H
#define DESKTOP_H

class FXScreenSaver {
private:
  FXApp * application;
  FXbool set;
  FXint orig_timeout;
  FXint orig_interval;
  FXint orig_blanking;
  FXint orig_exposure;
public:
  FXScreenSaver(FXApp * app);
  ~FXScreenSaver();
  
  /// Disable the Screensaver
  void disable();

  /// Restore Screensaver to original settings
  FXbool restore();

  /// Are we disabled
  FXbool isDisabled() {return set;}

  /// Update State of Screensaver
  void update();
  };


class FXDPMS{
private:
  FXApp * application;
  FXbool enabled;
  FXbool set;
public:
  FXDPMS(FXApp * app);
  ~FXDPMS();

  FXbool isAvailable();
  FXbool isDisabled() {return set;}
  
  /// Disable DPMS
  void disable();

  /// Restore to original settings
  void restore();

  /// Update State of DPMS
  void update();
  };
  

    
    
  


#endif
