%define name goggles
%define dirname		Goggles
%define version		0.5.8
%define release		3
%define builddir	$RPM_BUILD_DIR/%{dirname}-%{version}
%define prefixdef	/usr
%define defaultdxr3 no

# If you don't like the prefix '/usr' you can override it like this:
# rpm -ba|--rebuild --define 'prefix /usr/local'
%{?!prefix:%define prefix %{prefixdef}}
%{?!dxr3:%define dxr3 %{defaultdxr3}}

Name:	%{name}
Version:	%{version}
Release:	1
Vendor:		Generic
Packager:	Florin Andrei <florin@andrei.myip.org>
URL:		http://www.fifthplanet.net/goggles.html
Source:		%{dirname}-%{version}.tar.gz
Source1:	goggles.desktop
Group:		Applications/Multimedia
License:	GPL
Provides:	goggles
BuildRoot:	%{_tmppath}/%{dirname}-%{version}
Requires:	fox >= 1.1.35, ogle >= 0.9.1
Summary:	Graphical user interface (GUI) for Ogle dvd player


%description
Graphical user interface (GUI) for Ogle dvd player

%prep
%setup -n %{dirname}-%{version}

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CPPFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS"
./configure --prefix=%{prefix} --with-dxr3=%{dxr3}
make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"
make DESTDIR="$RPM_BUILD_ROOT" install
mkdir -p %{buildroot}%{_datadir}/applications
cp -p %{SOURCE1} %{buildroot}%{_datadir}/applications
mkdir -p %{buildroot}%{_datadir}/pixmaps
cp -p src/dvd_small_png.png %{buildroot}%{_datadir}/pixmaps/goggles.png

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf "$RPM_BUILD_ROOT"

%files
%defattr(-, root, root)
%{prefix}/bin/goggles
%{prefix}/bin/goggles_gui
%{_datadir}/applications/goggles.desktop
%{_datadir}/pixmaps/goggles.png
%doc AUTHORS COPYING ChangeLog NEWS README

%changelog
* Sat Mar 29 2003 Florin Andrei <florin@andrei.myip.org>
- compiler optimizations
- cute icon added to .desktop file
- removed comment from "clean" directive (oops!)

* Fri Dec 27 2002 Florin Andrei <florin@andrei.myip.org>
- first version, 0.2.4-1
