.TH PSIMAGE l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
psimage \- To plot images (EPS files or Sun rasterfiles) on maps
.SH SYNOPSIS
\fBpsimage\fP \fIimagefile\fP [ \fB\-W\fP[\fB-\fP]\fIxlength\fP[/\fIylength\fP] | \fB\-E\fP\fIdpi\fP ] [ \fB\-C\fP\fIxpos\fP/\fIypos\fP[/\fIjustify\fP] ] 
[ \fB\-F\fP\fIpen\fP ] [ \fB\-G\fP[\fBf\fP|\fBb\fP]\fIcolor\fP ] [ \fB\-I\fP ] [ \fB\-K\fP ] [ \fB\-M\fP ] 
[ \fB\-N\fP\fInxrep\fP[/\fInyrep\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBpsimage\fP reads an Encapsulated \fIPostScript\fP\fR file or
a 1, 8, 24, or 32-bit Sun rasterfile and plots it on a map.
The image can be scaled arbitrarily, and 1-bit raster images can be (1) inverted, i.e.,
black pixels (on) becomes white (off) and vice versa, or (2) colorized, by
assigning different foreground and background colors, and (3) made transparent
where one of back- or foreground is painted only. As an option,
the user may choose to convert colored raster images to grayscale using TV's YIQ-transformation.\"'
The user may also choose to replicate the image which, when preceded by appropriate clip
paths, may allow larger custom-designed fill patterns to be implemented (the \fB\-Gp\fP
mechanism offered in most \fBGMT\fP programs is limited to rasters smaller than 146 by 146).
.TP
\fIimagefile\fP
This must be an Encapsulated \fIPostScript\fP\fR (EPS) file or a Sun rasterfile.
An EPS file must contain an appropriate BoundingBox.
A rasterfile can have a depth of 1, 8, 24, or 32 bits. Old-style, Standard, Run-length-encoded, and
RGB Sun rasterfiles are supported.  Other raster formats can be converted
to Sun format via a variety of public-domain software (e.g., convert, xv).
.TP
.B \-E
Sets the dpi of the image in dots pr inch, or use \fB\-W\fP.
.TP
.B \-W
Sets the size of the image.  If not given \fIylength\fP is set to \fIxlength\fP * (ny/nx).
If \fIxlength\fP is negative we use the absolate value and interpolate image to the
device resolution using the PostScript image operator.
Alternatively, use \fB\-E\fP.
.br
.sp
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Sets position of lower left corner of image, and optionally append justification [0/0/LB].
.TP
.B \-F
Draws a rectangular frame around the image with the given pen [no frame].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-Gb
Sets background color (replace white pixel) for 1-bit image templates.
Use - for transparency (and set \fB\-Gf\fP to the desired color).
.TP
.B \-Gf
Sets foreground color (replace black pixel) for 1-bit image templates.
Use - for transparency (and set \fB\-Gb\fP to the desired color).
.TP
.B \-I
Invert image before plotting (1-bit images only). This is what is done
when you use \fB\-GP\fP in other GMT programs.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Convert color image to monochrome grayshades using the (television) YIQ-transformation.
.TP
.B \-N
Replicate the image \fInxrep\fP in x and \fInyrep\fP in y [Default is 1/1].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To plot the image contained in the 8-bit rasterfile scanned_face.ras, scaling
it to 8 by 10 cm, use
.br
.sp
\fBpsimage\fP scanned_face.ras \fB\-W\fP8\fBc\fP/10\fBc\fP > image.ps
.br
.sp
To include an Encapsulated PostScript file tiger.eps with its upper right corner 2 inch to the right
and 1 inch up from the current location, and have its width scaled to 3 inches, use
.br
.sp
\fBpsimage\fP tiger.eps \fB\-C\fP2\fBi\fP/1\fBi\fP/TR \fB\-W\fP3\fBi\fP > image.ps
.br
.sp
To replicate the image template 1_bit.ras over a 5 by 5 inch area, colorize it, and setting
each piece to be 1 by 1 cm, use
.br
.sp
\fBpsimage\fP 1_bit.ras \fB\-Gb\fP200/150/100 \fB\-Gf\fP100/50/30 \fB\-N\fP5\fBi\fP/5\fBi\fP \fB\-W\fP1\fBc\fP > image.ps
.SH "SEE ALSO"
.IR GMT (l)
