.TH PSCOAST l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
pscoast \- To plot land-masses, water-masses, coastlines, borders, and rivers
.SH SYNOPSIS
\fBpscoast\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-A\fP\fImin_area\fP[\fI/min_level/max_level\fP] ] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIfill\fP ] [ \fB\-D\fP\fIresolution\fP ] 
[ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP\fIfill\fP ] 
[ \fB\-I\fP\fIriver\fP[/\fIpen\fP] ] [ \fB\-Jz\fP|\fBZ\fP\fIparameters\fP ] [ \fB\-K\fP ] 
[ \fB\-L\fP[\fBf\fP][\fBx\fP]\fIlon0\fP/\fIlat0\fP[/\fIslon\fP]/\fIslat\fP/\fIlength\fP[\fBm\fP|\fBn\fP|\fBk\fP][:\fIlabel\fP:\fIjust\fP][\fB+p\fP\fIpen\fP][\fB+f\fP\fIfill\fP] ] ] [ \fB\-O\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP\fIborder\fP[/\fIpen\fP] ] [ \fB\-O\fP ] 
[ \fB\-P\fP ] [ \fB\-Q\fP ] [ \fB\-S\fP\fIfill\fP ] [ \fB\-T\fP[\fBf\fP|\fBm\fP][\fBx\fP]\fIlon0\fP/\fIlat0\fP/\fIsize\fP[/\fIinfo\fP][:w,e,s,n:][+\fIgint\fP[/\fImint\fP]] ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] 
[ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBpscoast\fP plots grayshaded, colored, or textured land-masses [or water-masses] on maps and [optionally]
draws coastlines, rivers, and political boundaries.  Alternatively, it can (1) issue clip paths that will
contain all land or all water areas, or (2) dump the data to an ASCII table.  The datafiles come in 5 different resolutions:
(\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, and (\fBc\fP)rude.  The full resolution files amount to more than 55 Mb
of data and provide great detail; for maps of larger geographical extent it is more economical to use
one of the other resolutions.  If the user selects to paint the land-areas and does not specify fill of
water-areas then the latter will be transparent (i.e., earlier graphics drawn in those areas will not
be overwritten).  Likewise, if the water-areas are painted and no land fill is set then the land-areas
will be transparent.  The \fIPostScript\fP code is written to standard output.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.SH OPTIONS
.TP
.B \-A
Features with an area smaller than \fImin_area\fP in km^2 or of hierarchical level that is lower than \fImin_level\fP or higher than \fImax_level\fP
will not be plotted [Default is 0/0/4 (all features)]. See DATABASE INFORMATION below for more details.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Set the shade (0\-255), color (r/g/b), or pattern (\fBp|P\fP\fIdpi/pattern\fP; see \fB\-G\fP) for lakes  [Default is the fill chosen for "wet" areas (\fB\-S\fP)].
.TP
.B \-D
Selects the resolution of the data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, and (\fBc\fP)rude).  The
resolution drops off by 80% between data sets. [Default is \fBl\fP].
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90].\"'
.TP
.B \-G
Select painting or clipping of "dry" areas.  Append a shade, color, pattern, or \fBc\fP for clipping.
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-I
Draw rivers.  Specify the type of rivers and [optionally] append pen attributes  [Default pen:
width = 1, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.br
Choose from the list of river types below.
Repeat option \fB\-I\fP as often as necessary.
.br
	 1 = Permanent major rivers
.br
	 2 = Additional major rivers
.br
	 3 = Additional rivers
.br
	 4 = Minor rivers
.br
	 5 = Intermittent rivers - major
.br
	 6 = Intermittent rivers - additional
.br
	 7 = Intermittent rivers - minor
.br
	 8 = Major canals
.br
	 9 = Minor canals
.br
	10 = Irrigation canals
.br
	 a = All rivers and canals (1-10)
.br
	 r = All permanent rivers (1-4)
.br
	 i = All intermittent rivers (5-7)
.br
	 c = All canals (8-10)
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draws a simple map scale centered on \fIlon0/lat0\fP.  Use \fB\-Lx\fP to specify x/y position instead.
Scale is calculated at latitude \fIslat\fP (optionally supply longitude \fIslon\fP for oblique projections
[Default is central meridian]), \fIlength\fP is in km [miles if \fBm\fP is appended; nautical miles
if \fBn\fP is appended]. Use \fB\-Lf\fP to get a "fancy" scale [Default is plain]. The default label equals the
distance unit (km, miles, nautical miles) and is justified on top of the scale [t].  Change this by giving your
own label (or - to keep the default) and justification (l(eft), r(ight), t(op), b(ottom), and u(unit) - using
the label as a unit appended to all distance annotations along the scale).  If you want to place a rectangle
behind the scale, specify pen and/or fill parameters with the \fB+p\fP and \fB+f\fP modifiers.
.TP
.B \-M
Dumps a single multisegment ASCII (or binary, see \fB\-bo\fP) file to standard output.  No plotting occurs.
Specify any combination of \fB\-W, \-I, \-N\fP.  Optionally, you may append the
\fIflag\fP character that is written at the start of each segment header ['>'].
.TP
.B \-N
Draw political boundaries.  Specify the type of boundary and [optionally] append pen attributes  [Default pen:
width = 1, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.br
Choose from the list of boundaries below.
Repeat option \fB\-N\fP as often as necessary.
.br
	1 = National boundaries
.br
	2 = State boundaries within the Americas
.br
	3 = Marine boundaries
.br
	a = All boundaries (1-3)
.br
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Mark end of existing clip path.  No projection information is needed.
.TP
.B \-S
Select painting or clipping of "wet" areas.  Append the shade (0\-255), color (r/g/b), pattern (see \fB\-G\fP), or \fBc\fP for clipping.
.TP
.B \-T
Draws a simple map directional rose centered on \fIlon0/lat0\fP.  Use \fB\-Tx\fP to specify x/y position instead.
The \fIsize\fP is the diameter of the rose, and optional label information can be specified to override
the default values of W, E, S, and N (Give :: to suppress all labels).  The default [plain] map rose only labels north.  Use \fB\-Tf\fP to get a
"fancy" rose, and specify what \fIkind\fP of rose you want drawn.  The default [1] draws the two principal E-W,
N-S orientations, 2 adds the two intermediate NW-SE and NE-SW orientations, while 3 adds the eight minor
orientations WNW-ESE, NNW-SSE, NNE-SSW, and ENE-WSW.  For a magnetic compass rose, specify \fB\-Tm\fP.  If given,
\fIinfo\fP must be the two parameters \fIdec/dlabel\fP, where \fIdec\fP is the magnetic declination and \fIdlabel\fP
is a label for the magnetic compass needle (specify '-' to format a label from \fIdec\fP).  Then, both directions
to geographic and magnetic north are plotted [Default is geographic only].  If the north label = * then a north
star is plotted instead of the north label.  Annotation and two levels of tick intervals for geographic and magnetic
directions are 10/5/1 and 30/5/1 degrees, respectively; override these settings by appending +\fIgints\fP[/\fImints\fP].
Color and pen attributes are taken from \fBCOLOR_BACKGROUND\fP and \fBTICK_PEN\fP, respectively, while label fonts and sizes
follow the usual annotation, label, and header font settings.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Draw coastlines. [Default is no coastlines].  Append pen attributes  [Defaults:
width = 1, color = black, texture = solid].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the coastlines [0].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
.SH EXAMPLES
To plot a green Africa with white outline on blue background, with permanent major rivers in thick blue pen, additional major rivers in thin blue pen, and national borders as dashed lines
on a Mercator map at scale 0.1 inch/degree, use
.br
.sp
\fBpscoast\fP \fB\-R\fP-30/30/-40/40 \fB\-Jm\fP0.1\fBi\fP \fB\-B\fP5 \fB\-I\fP1/1\fBp\fP/0/0/255 \fB\-I\fP2/0.25\fBp\fP/0/0/255 \fB\-N\fP1/0.25\fBtap\fP \fB\-W\fP0.25\fBp\fP/255/255/255 \fB\-G\fP0/255/0 \fB\-S\fP0/0/255 \fB\-P\fP > africa.ps
.br
.sp
To plot Iceland using the lava pattern (# 28) at 100 dots per inch, on a Mercator map at scale 1 cm/degree, run
.br
.sp
\fBpscoast\fP \fB\-R\fP-30/-10/60/65 \fB\-Jm\fP1\fBc\fP \fB\-B\fP5 \fB\-Gp\fP100/28 > iceland.ps
.br
.sp
To initiate a clip path for Africa so that the subsequent colorimage of gridded topography is only
seen over land, using a Mercator map at scale 0.1 inch/degree, use
.br
.sp
\fBpscoast\fP \fB\-R\fP-30/30/-40/40 \fB\-Jm\fP0.1\fBi\fP \fB\-B\fP5 \fB\-Gc \-P \-K\fP > africa.ps
.br
\fBgrdimage\fP \fB\-Jm\fP0.1\fBi\fP etopo5.grd \fB\-C\fPcolors.cpt \fB\-O \-K\fP >> africa.ps
.br
\fBpscoast\fP \fB\-Q \-O\fP >> africa.ps
.SH DATABASE INFORMATION
The coastline database is GSHHS which is compiled from two sources: World Vector Shorelines (WVS) and CIA World Data Bank II (WDBII).
In particular, all level-1 polygons (ocean-land boundary) are derived from the more accurate WVS while all higher level polygons
(level 2-4, representing land/lake, lake/island-in-lake, and island-in-lake/lake-in-island-in-lake boundaries) are
taken from WDBII.  Much processing has taken place to convert WVS and WDBII data into usable form for \fBGMT\fP:
assembling closed polygons from line segments, checking for duplicates, and correcting for crossings between
polygons.  The area of each polygon has been determined so that the user
may choose not to draw features smaller than a minimum area (see \fB\-A\fP); one may also limit the highest hierarchical level of
polygons to be included (4 is the maximum).  The 4 lower-resolution databases were derived from the full resolution
database using the Douglas-Peucker line-simplification algorithm.  The classification of rivers and borders follow
that of the WDBII.  See the \fBGMT\fP Cookbook and Technical Reference Appendix K for
further details.
.br
.sp
\fBpscoast\fP will first look for coastline files in directory \fB$GMTHOME\fP/share (where \fB$GMTHOME\fP is
an environmental variable).  If the desired file is not found, it will look for the file
coastline.conf in the same directory.  This file may contain any number of records that
each holds the full pathname of an alternative directory.  Comment lines (#) and blank lines
are allowed.  The desired file is then sought for in the alternate directories.
.SH BUGS
The options to fill (\fB\-C \-G \-S\fP) may not always work if the Azimuthal equidistant projection is
chosen (\fB\-Je|E\fP).  If the antipole of the projection is in the oceans it will most likely work.
If not, try to avoid using projection center coordinates that are even multiples of the coastline
bin size (1, 2, 5, 10, and 20 degrees for \fBf, h, i, l, c\fP, respectively).  This projection is
not supported for clipping.
.br
The political borders are for the most part 1970ies-style and do not reflect the recent
border rearrangements in Europe.  We intend to update these as high-resolution data become
available to us.
.br
Some users of \fBpscoast\fP will not be satisfied with what they find for the
Antarctic shoreline.  In Antarctica, the boundary between ice and 
ocean varies seasonally and inter-annually.  There are some areas of 
permanent sea ice.  In addition to these time-varying ice-ocean 
boundaries, there are also ice grounding lines where ice goes from 
floating on the sea to sitting on land, and lines delimiting areas 
of rock outcrop.  For consistency's sake, we have used the World\"'
Vector Shoreline throughout the world in pscoast, as described in
the \fBGMT\fP Cookbook Appendix K. Users who need specific boundaries
in Antarctica should get the Antarctic Digital Database, prepared
by the British Antarctic Survey, Scott Polar Research Institute,
World Conservation Monitoring Centre, under the auspices of the
Scientific Committee on Antarctic Research.  This data base contains
various kinds of limiting lines for Antarctica and is available on
CD-ROM.  It is published by the Scientific Committee on Antarctic
Research, Scott Polar Research Institute, Lensfield Road, Cambridge
CB2 1ER, United Kingdom.
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR GMT (l),
.IR grdlandmask (l),
.IR psbasemap (l)
