.TH GRDMASK l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
grdmask \- Create mask grdfiles from xy paths.
.SH SYNOPSIS
\fBgrdmask\fP \fIpathfiles\fP \fB\-G\fP\fImask_grd_file\fP] \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] 
\fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-A\fP ] [ \fB\-F\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-N\fP\fIout/edge/in\fP ] [ \fB\-S\fP\fIsearch_radius\fP[\fBm|c|k|K\fP] ] 
[ \fB\-V\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdmask\fP can operate in two different modes. 1. It reads one or more xy-files that each define a closed polygon.
The nodes defined by the specified region and lattice spacing will be set equal to one of three possible values
depending on whether the node is outside, on the polygon perimeter, or inside the polygon.  The
resulting mask grdfile may be used in subsequent operations involving \fBgrdmath\fP to mask out
data from polygonal areas. 2. The xy-files simply represent data point locations and the mask is set to the
inside or outside value depending on whether a node is within a maximum distance from the nearest data point.
If the distance specified is zero then only the nodes nearest each data point are considered "inside".
.TP
\fIpathfiles\fP
The name of 1 or more ASCII [or binary, see \fB\-b\fP] files holding the polygon(s) or data points.
.TP
.B \-G
Name of resulting output mask grd file.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.TP
.B \-A
If the input data are geographic (as indicated by \fB\-fi\fP) then the sides in the polygons will be
approximated by great circle arcs.  This can be turned off using the \fB\-A\fP switch.
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Sets the values that will be assigned to nodes that are \fIout\fPside the polygons,
on the \fIedge\fP, or \fIin\fPside.  Values can be any number, including the
textstring NaN  [Default is 0/0/1].
.TP
.B \-S
Set nodes depending on their distance from the nearest data point.  Nodes within \fIradius\fP [0] from
a data point are considered inside.  Append \fBm\fP to indicate minutes
or \fBc\fP to indicate seconds.  Append \fBk\fP to indicate km (implies \fB\-R\fP and \fB\-I\fP are in degrees, and
we will use a fast flat Earth approximation to calculate distance).  For more accuracy, use uppercase \fBK\fP
if distances should be calculated along geodesics.
However, if the current \fBELLIPSOID\fP is set to Sphere then spherical great circle calculations are used.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To set all nodes inside and on the polygons coastline_*.xy to 0, and outside points
to 1, do
.sp
\fBgrdmask\fP coastline_*.xy \fB\-R\fP-60/-40/-40/-30 \fB\-I\fP5\fBm \-N\fP1/0/0 \fB\-G\fPland_mask.grd  \fB\-V\fP
.br
.sp
To set nodes within 50 km of data points to 1 and other nodes to NaN, do
.sp
\fBgrdmask\fP data.xyz \fB\-R\fP-60/-40/-40/-30 \fB\-I\fP5m \fB\-N\fPNaN/1/1 \fB\-S\fP50\fBk\fP \fB\-G\fPdata_mask.grd  \fB\-V\fP
.SH "SEE ALSO"
.IR GMT (l),
.IR grdlandmask (l),
.IR grdmath (l),
.IR grdclip (l),
.IR psmask (l),
.IR psclip (l)
