.TH FITCIRCLE l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
fitcircle \- find mean position and pole of best-fit great [or small] circle to points on a sphere.
.SH SYNOPSIS
\fBfitcircle\fP [ \fIxyfile\fP ] \fB\-L\fP\fInorm\fP [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-S\fP ] [ \fB\-V\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] 
[ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBfitcircle\fP reads lon,lat [or lat,lon] values from the first two columns on standard input 
[or \fIxyfile\fP].  These are converted to Cartesian three-vectors on the unit sphere.  Then two 
locations are found:  the mean of the input positions, and the pole to the great circle which 
best fits the input positions.  The user may choose one or both of two possible solutions to this 
problem.  The first is called \fB\-L1\fP and the second is called \fB\-L2\fP.  When the data are 
closely grouped along a great circle both solutions are similar.  If the data have large dispersion, 
the pole to the great circle will be less well determined than the mean.  Compare both solutions as 
a qualitative check.
.br
.sp
The \fB\-L1\fP solution is so called because it approximates the minimization of the sum of absolute 
values of cosines of angular distances.  This solution finds the mean position as the Fisher average 
of the data, and the pole position as the Fisher average of the cross-products between the mean and 
the data.  Averaging cross-products gives weight to points in proportion to their distance from the 
mean, analogous to the "leverage" of distant points in linear regression in the plane.
.br
.sp
The \fB\-L2\fP solution is so called because it approximates the minimization of the sum of squares 
of cosines of angular distances.  It creates a 3 by 3 matrix of sums of squares of components of the 
data vectors.  The eigenvectors of this matrix give the mean and pole locations.  This method may 
be more subject to roundoff errors when there are thousands of data.  The pole is given by the eigenvector 
corresponding to the smallest eigenvalue; it is the least-well represented factor in the data and is 
not easily estimated by either method.
.br
.TP
.B \-L
Specify the desired \fInorm\fP as 1 or 2, or use \fB\-L\fP or  \fB\-L3\fP to see both solutions.
.SH OPTIONS
.sp
.TP
\fIxyfile\fP
ASCII [or binary, see \fB\-b\fP] file containing lon,lat [lat,lon] values in the first 2 columns.  If no file is specified, \fBfitcircle\fP 
will read from standard input.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-S
Attempt to fit a small circle instead of a great circle.  The pole will be
constrained to lie on the great circle connecting the pole of the best-fit great circle
and the mean location of the data.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
Suppose you have lon,lat,grav data along a twisty ship track in the file ship.xyg.  You want to 
project this data onto a great circle and resample it in distance, in order to filter it or check its spectrum.  Do the following:
.br
.sp
\fBfitcircle\fP ship.xyg \fB\-L\fP2 
.sp
\fBproject\fP ship.xyg \fB\-C\fP\fIox\fP/\fIoy\fP \fB\-T\fP\fIpx\fP/\fIpy\fP \fB\-S\fP \fB\-F\fPpz | \fBsample1d\fP \fB\-S\fP\-100 \fB\-I\fP1 
> output.pg
.sp
Here, \fIox\fP/\fIoy\fP is the lon/lat of the mean from \fBfitcircle\fP, and \fIpx\fP/\fIpy\fP is the lon/lat 
of the pole.  The file output.pg has distance, gravity data sampled every 1 km along the great circle which best fits ship.xyg
.SH "SEE ALSO"
.IR GMT (l),
.IR project (l),
.IR sample1d (l)
