.TH FILTER1D l "1 Jun 2006" "GMT4.1.3" "GMT4.1.3"
.SH NAME
filter1d \- Time domain filtering of 1-D time series
.SH SYNOPSIS
\fBfilter1d\fP [ \fIinfile\fP ] \fB\-F\fP\fI<type><width>\fP[\fImode\fP] [ \fB\-D\fP\fIincrement\fP ]  
[ \fB\-D\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP\fIignore_val\fP ] [ \fB\-L\fP\fIlack_width\fP ] 
[ \fB\-N\fP\fIn_cols/t_col\fP ] [ \fB\-Q\fP\fIq_factor\fP ] [ \fB\-S\fP\fIsymmetry_factor\fP ] 
[ \fB\-T\fP\fIstart/stop/int\fP ] [ \fB\-V\fP ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBfilter1d\fP is a general time domain filter for multiple column time series data.
The user specifies the number of columns of input and which column is the time.
(See \fB\-N\fP option below).  The fastest operation occurs when the input time series are
equally spaced and have no gaps or outliers and the special options are not needed.
\fBfilter1d\fP has options \fB-L\fP, \fB-Q\fP, and \fB-S\fP for unevenly sampled data with gaps.
.TP
\fIinfile\fP
Multi-column ASCII (or binary, see \fB\-b\fP) file holding data values to be filtered.
.TP
.B \-F
Sets the filter type.  Choose among convolution and non-convolution filters.  Append the filter code followed
by the full filter \fIwidth\fP in same units as time column. Available convolution filters are:
.br
(\fBb\fP) Boxcar: All weights are equal.
.br
(\fBc\fP) Cosine Arch: Weights follow a cosine arch curve.
.br
(\fBg\fP) Gaussian: Weights are given by the Gaussian function.
.br
(\fBf\fP) Custom: Instead of \fIwidth\fP give name of a one-column file of your own weight coefficients.
.br
Non-convolution filters are:
.br
(\fBm\fP) Median: Returns median value.
.br
(\fBp\fP) Maximum likelihood probability (a mode estimator): Return modal value.
If more than one mode is found we return their average value.  Append - or + to
the filter width if you rather want to return the smallest or largest of the modal
values.
.br
(\fBl\fP) Lower: Return the minimum of all values.
.br
(\fBL\fP) Lower: Return minimum of all positive values only.
.br
(\fBu\fP) Upper: Return maximum of all values.
.br
(\fBU\fP) Upper: Return maximum or all negative values only.
.br
Upper case type \fBB, C, G, M, P, F\fP will use robust filter versions:
i.e., replace outliers (2.5 L1 scale off median) with median during filtering.
.br
In the case of \fBL|U\fP it is possible that no data passes the initial sign test; in that case
the filter will return 0.0.
.SH OPTIONS
.sp
.TP
.B \-D
\fIincrement\fP is used when series is NOT equidistantly sampled.
Then \fIincrement\fP will be the abscissae resolution, i.e., all abscissae
will be rounded off to a multiple of \fIincrement\fP.  Alternatively, resample
data with \fBsample1d\fP.
.TP
.B \-E
Include Ends of time series in output.  Default loses half the filter-width of data at each end.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
To ignore values; If an input value equals \fIignore_val\fP it will be set to NaN.
.TP
.B \-L
Checks for Lack of data condition.  If input data has a gap exceeding
\fIwidth\fP then no output will be given at that point [Default does not check Lack].
.TP
.B \-N
Sets number of columns in input and which column contains the independent
variable (time). The left-most column is # 0, the right-most is # (\fIn_cols\fP - 1).
[Default is \fIn_cols\fP = 2, \fIt_col\fP = 0; i.e., file has t, f(t) pairs].
.TP
.B \-Q
assess Quality of output value by checking mean weight in convolution.
Enter \fIq_factor\fP between 0 and 1.  If mean weight < \fIq_factor\fP, output is suppressed
at this point [Default does not check Quality].
.TP
.B \-S
Checks symmetry of data about window center.  Enter a factor
between 0 and 1.  If ( (abs(n_left - n_right)) / (n_left + n_right) ) > \fIfactor\fP,
then no output will be given at this point [Default does not check Symmetry].
.TP
.B \-T
Make evenly spaced timesteps from \fIstart\fP to \fIstop\fP by \fIint\fP [Default uses input times].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To filter the data set in the file cruise.gmtd containing evenly spaced gravity, magnetics, topography,
and distance (in m) with a 10 km Gaussian filter, removing outliers, and output a filtered
value every 2 km between 0 and 100 km:
.br
.sp
\fBfilter1d\fP cruise.gmtd \fB\-T\fP0/1.0e5/2000 \fB\-FG\fP10000 \fB\-N\fP4/3 \fB\-V\fP > filtered_cruise.gmtd
.br
.sp
Data along track often have uneven sampling and gaps which we do not want to interpolate using \fBsample1d\fP.
To find the median depth in a 50 km window every 25 km along the track of cruise v3312, stored in v3312.dt,
checking for gaps of 10km and asymmetry of 0.3:
.br
.sp
\fBfilter1d\fP v3312.dt \fB\-FM\fP50 \fB\-T\fP0/100000/25 \fB\-L\fP10 \fB\-S\fP0.3 > v3312_filt.dt
.SH "SEE ALSO"
.IR GMT (l),
.IR sample1d (l)
