.TH GRDMATH l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdmath \- Reverse Polish Notation calculator for grd files
.SH SYNOPSIS
\fBgrdmath\fP [ \fB\-F\fP ] [ \fB\-I\fP\fIxinc\fP[\fBm|c\fP][/\fIyinc\fP[\fBm|c\fP]]
\fB\-R\fP\fIwest/east/south/north\fP \fB\-V\fP]
\fIoperand\fP [ \fIoperand\fP ] \fBOPERATOR\fP [ \fIoperand\fP ] \fBOPERATOR\fP ... \fB=\fP \fIoutgrdfile\fP
.SH DESCRIPTION
\fBgrdmath\fP will perform operations like add, subtract, multiply, and divide on one or more grd files or constants using
Reverse Polish Notation (RPN) syntax (e.g., Hewlett-Packard calculator-style). Arbitrarily complicated expressions may therefore
be evaluated; the final result is written to an output grd file. When two grd files are
on the stack, each element in file A is modified by the corresponding element in file B.
However, some operators only require one operand (see below). If no grdfiles are used in the
expression then options \fB\-R, \-I\fP must be set (and optionally \fB\-F\fP). The expression
\fB=\fP \fIoutgrdfile\fP can occur as many times as the depth of the stack allows.
.TP
\fIoperand\fP
If \fIoperand\fP can be opened as a file it will be read as a grd file. If not a file, it is interpreted
as a numerical constant or a special symbol (see below).
.TP
\fIoutgrdfile\fP is a 2-D grd file that will hold the final result.
.TP
.B OPERATORS
Choose among the following operators:
.br
Operator n_args Returns
.br
.sp
\fBABS\fP 1 abs (A).
.br
\fBACOS\fP 1 acos (A).
.br
\fBACOSH\fP 1 acosh (A).
.br
\fBADD(+)\fP 2 A + B.
.br
\fBAND\fP 2 NaN if A and B == NaN, B if A == NaN, else A.
.br
\fBASIN\fP 1 asin (A).
.br
\fBASINH\fP 1 asinh (A).
.br
\fBATAN\fP 1 atan (A).
.br
\fBATAN2\fP 2 atan2 (A, B).
.br
\fBATANH\fP 1 atanh (A).
.br
\fBBEI\fP 1 bei (A).
.br
\fBBER\fP 1 ber (A).
.br
\fBCAZ\fP 2 Cartesian azimuth from grid nodes to stack x,y
.br
\fBCDIST\fP 2 Cartesian distance between grid nodes and stack x,y.
.br
\fBCEIL\fP 1 ceil (A) (smallest integer >= A).
.br
\fBCHICRIT\fP 2 Critical value for chi-squared-distribution, with alpha = A and n = B.
.br
\fBCHIDIST\fP 2 chi-squared-distribution P(chi2,nn), with chi2 = A and n = B.
.br
\fBCOS\fP 1 cos (A) (A in radians).
.br
\fBCOSD\fP 1 cos (A) (A in degrees).
.br
\fBCOSH\fP 1 cosh (A).
.br
\fBCURV\fP 1 Curvature of A (Laplacian).
.br
\fBD2DX2\fP 1 d^2(A)/dx^2 2nd derivative.
.br
\fBD2DY2\fP 1 d^2(A)/dy^2 2nd derivative.
.br
\fBD2R\fP 1 Converts Degrees to Radians.
.br
\fBDDX\fP 1 d(A)/dx 1st derivative.
.br
\fBDDY\fP 1 d(A)/dy 1st derivative.
.br
\fBDILOG\fP 1 dilog (A).
.br
\fBDIV(/)\fP 2 A / B.
.br
\fBDUP\fP 1 Places duplicate of A on the stack.
.br
\fBERF\fP 1 Error function erf (A).
.br
\fBERFC\fP 1 Complementary Error function erfc (A).
.br
\fBERFINV\fP 1 Inverse error function of A.
.br
\fBEQ\fP 2 1 if A == B, else 0.
.br
\fBEXCH\fP 2 Exchanges A and B on the stack.
.br
\fBEXP\fP 1 exp (A).
.br
\fBEXTREMA\fP 1 Local Extrema: +2/-2 is max/min, +1/-1 is saddle with max/min in x, 0 elsewhere.
.br
\fBFCRIT\fP 3 Critical value for F-distribution, with alpha = A, n1 = B, and n2 = C.
.br
\fBFDIST\fP 3 F-distribution Q(F,n1,n2), with F = A, n1 = B, and n2 = C.
.br
\fBFLIPLR\fP 1 Reverse order of values in each row
.br
\fBFLIPUD\fP 1 Reverse order of values in each column
.br
\fBFLOOR\fP 1 floor (A) (greatest integer <= A).
.br
\fBFMOD\fP 2 A % B (remainder).
.br
\fBGE\fP 2 1 if A >= B, else 0.
.br
\fBGT\fP 2 1 if A > B, else 0.
.br
\fBHYPOT\fP 2 hypot (A, B) = sqrt (A*A + B*B).
.br
\fBI0\fP 1 Modified Bessel function of A (1st kind, order 0).
.br
\fBI1\fP 1 Modified Bessel function of A (1st kind, order 1).
.br
\fBIN\fP 2 Modified Bessel function of A (1st kind, order B).
.br
\fBINRANGE\fP 3 1 if B <= A <= C, else 0
.br
\fBINSIDE\fP 1 1 when inside polygon(s) in A, else 0
.br
\fBINV\fP 1 1 / A.
.br
\fBISNAN\fP 1 1 if A == NaN, else 0.
.br
\fBJ0\fP 1 Bessel function of A (1st kind, order 0).
.br
\fBJ1\fP 1 Bessel function of A (1st kind, order 1).
.br
\fBJN\fP 2 Bessel function of A (1st kind, order B).
.br
\fBK0\fP 1 Modified Kelvin function of A (2nd kind, order 0).
.br
\fBK1\fP 1 Modified Bessel function of A (2nd kind, order 1).
.br
\fBKN\fP 2 Modified Bessel function of A (2nd kind, order B).
.br
\fBKEI\fP 1 kei (A).
.br
\fBKER\fP 1 ker (A).
.br
\fBLDIST\fP 1 Compute distance from lines in multi-segment ASCII file A
.br
\fBLE\fP 2 1 if A <= B, else 0.
.br
\fBLMSSCL\fP 1 LMS scale estimate (LMS STD) of A.
.br
\fBLOG\fP 1 log (A) (natural log).
.br
\fBLOG10\fP 1 log10 (A) (base 10).
.br
\fBLOG1P\fP 1 log (1+A) (accurate for small A).
.br
\fBLOG2\fP 1 log2 (A) (base 2).
.br
\fBLOWER\fP 1 The lowest (minimum) value of A.
.br
\fBLRAND\fP 2 Laplace random noise with mean A and std. deviation B.
.br
\fBLT\fP 2 1 if A < B, else 0.
.br
\fBMAD\fP 1 Median Absolute Deviation (L1 STD) of A.
.br
\fBMAX\fP 2 Maximum of A and B.
.br
\fBMEAN\fP 1 Mean value of A.
.br
\fBMED\fP 1 Median value of A.
.br
\fBMIN\fP 2 Minimum of A and B.
.br
\fBMODE\fP 1 Mode value (Least Median of Squares) of A.
.br
\fBMUL(x)\fP 2 A * B.
.br
\fBNAN\fP 2 NaN if A == B, else A.
.br
\fBNEG\fP 1 -A.
.br
\fBNEQ\fP 2 1 if A != B, else 0.
.br
\fBNRAND\fP 2 Normal, random values with mean A and std. deviation B.
.br
\fBOR\fP 2 NaN if A or B == NaN, else A.
.br
\fBPDIST\fP 1 Compute distance from points in ASCII file A
.br
\fBPLM\fP 3 Associated Legendre polynomial P(-1<A<+1) degree B order C.
.br
\fBPOP\fP 1 Delete top element from the stack.
.br
\fBPOW(^)\fP 2 A ^ B.
.br
\fBR2\fP 2 R2 = A^2 + B^2.
.br
\fBR2D\fP 1 Convert Radians to Degrees.
.br
\fBRAND\fP 2 Uniform random values between A and B.
.br
\fBRINT\fP 1 rint (A) (nearest integer).
.br
\fBROTX\fP 2 Rotate A by the (constant) shift B in x-direction
.br
\fBROTY\fP 2 Rotate A by the (constant) shift B in y-direction
.br
\fBSAZ\fP 2 Sperhical azimuth from grid nodes to stack x,y
.br
\fBSDIST\fP 2 Spherical (Great circle) distance (in degrees) between grid nodes and stack lon,lat (A, B).
.br
\fBSIGN\fP 1 sign (+1 or -1) of A.
.br
\fBSIN\fP 1 sin (A) (A in radians).
.br
\fBSINC\fP 1 sinc (A) (sin (pi*A)/(pi*A)).
.br
\fBSIND\fP 1 sin (A) (A in degrees).
.br
\fBSINH\fP 1 sinh (A).
.br
\fBSQRT\fP 1 sqrt (A).
.br
\fBSTD\fP 1 Standard deviation of A.
.br
\fBSTEP\fP 1 Heaviside step function: H(A).
.br
\fBSTEPX\fP 1 Heaviside step function in x: H(x-A).
.br
\fBSTEPY\fP 1 Heaviside step function in y: H(y-A).
.br
\fBSUB(-)\fP 2 A - B.
.br
\fBTAN\fP 1 tan (A) (A in radians).
.br
\fBTAND\fP 1 tan (A) (A in degrees).
.br
\fBTANH\fP 1 tanh (A).
.br
\fBTCRIT\fP 2 Critical value for Student's t-distribution, with alpha = A and n = B.\"'
.br
\fBTDIST\fP 2 Student's t-distribution A(t,n), with t = A, and n = B.\"'
.br
\fBUPPER\fP 1 The highest (maximum) value of A.
.br
\fBXOR\fP 2 B if A == NaN, else A.
.br
\fBY0\fP 1 Bessel function of A (2nd kind, order 0).
.br
\fBY1\fP 1 Bessel function of A (2nd kind, order 1).
.br
\fBYLM\fP 2 Re and Im normalized surface harmonics (degree A, order B).
.br
\fBYN\fP 2 Bessel function of A (2nd kind, order B).
.br
\fBZCRIT\fP 1 Critical value for the normal-distribution, with alpha = A.
.br
.TP
.B SYMBOLS
The following symbols have special meaning:
.br
.sp
\fBPI\fP 3.1415926...
.br
\fBE \fP 2.7182818...
.br
\fBX \fP Grid with x-coordinates
.br
\fBY \fP Grid with y-coordinates
.br
.SH OPTIONS
.TP
.B \-F
Select pixel registration (used with \fB\-R, \-I\fP). [Default is grid registration].
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH BEWARE
The operator \fBGDIST\fP calculates spherical distances bewteen the (lon, lat)
point on the stack and all node positions in the grid. The grid domain
and the (lon, lat) point are expected to be in degrees. The operator
\fBYLM\fP calculates the fully normalized spherical harmonics for degree L and
order M for all positions in the grid, which is assumed to be in degrees.
\fBYLM\fP returns two grids, the Real (cosine) and Imaginary (sine) component
of the complex spherical harmonic. Use the \fBPOP\fP operator (and \fBEXCH\fP) to
get rid of one of them, of save both by giving two consequtive = file.grd calls.
The operator \fBPLM\fP calculates the associated Legendre polynomial
of degree L and order M, and its argument is the cosine of the colatitude
which must satisfy -1 <= x <= +1. Unlike \fBYLM\fP, \fBPLM\fP is not normalized.
.br
All the derivatives are based on central finite differences, with natural
boundary conditions.
.SH EXAMPLES
To take log10 of the average of 2 files, use
.br
.sp
\fBgrdmath\fP file1.grd file2.grd \fBADD\fP 0.5 \fBMUL LOG10 =\fP file3.grd
.br
.sp
Given the file ages.grd, which holds seafloor ages in m.y., use the relation
depth(in m) = 2500 + 350 * sqrt (age) to estimate normal seafloor depths:
.br
.sp
\fBgrdmath\fP ages.grd \fBSQRT\fP 350 \fBMUL \fP2500 \fBADD =\fP depths.grd
.br
.sp
To find the angle a (in degrees) of the largest principal stress from the stress tensor given by the
three files s_xx.grd s_yy.grd, and s_xy.grd from the relation tan (2*a) = 2 * s_xy / (s_xx - s_yy), use
.br
.sp
\fBgrdmath\fP 2 s_xy.grd \fBMUL\fP s_xx.grd s_yy.grd \fBSUB DIV ATAN2\fP 2 \fBDIV =\fP direction.grd
.br
.sp
To calculate the fully normalized spherical harmonic of degree 8 and order
4 on a 1 by 1 degree world map, using the real amplitude 0.4 and the
imaginary amplitude 1.1:
.br
.sp
\fBgrdmath\fP \fB\-R\fP0/360/-90/90 \fB\-I\fP1 8 4 \fBYML\fP 1.1 \fBMUL EXCH\fP 0.4 \fBMUL ADD\fP = harm.grd
.br
.sp
To extract the locations of local maxima that exceed 100 mGal in the file faa.grd:
.br
.sp
\fBgrdmath\fP faa.grd \fBDUP EXTREMA\fP 2 \fBEQ MUL DUP\fP 100 \fBGT MUL\fP 0 \fBNAN\fP = z.grd
.br
\fBgrd2xyz\fP z.grd \fB\-S\fP > max.xyz
.SH BUGS
Files that has the same name as some operators, e.g., \fBADD\fP, \fBSIGN\fP, \fB=\fP, etc. cannot be read
and must not be present in the current directory. Piping of files are not allowed.
The stack limit is hard-wired to 50.
All functions expecting a positive radius (e.g., \fBLOG\fP, \fBKEI\fP, etc.) are passed the
absolute value of their argument.
.SH REFERENCES
Abramowitz, M., and I. A. Stegun, 1964, \fIHandbook of Mathematical
Functions\fP, Applied Mathematics Series, vol. 55, Dover, New York.
.br
Press, W. H., S. A. Teukolsky, W. T. Vetterling, B. P. Flannery, 1992,
\fINumerical Recipes\fP, 2nd edition, Cambridge Univ., New York.
.SH "SEE ALSO"
.IR gmt (l),
.IR gmtmath (l),
.IR grd2xyz (l),
.IR grdedit (l),
.IR grdinfo (l),
.IR xyz2grd (l)
