.TH GRDCUT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdcut \- Extract a subregion out of a \fI.grd\fP file
.SH SYNOPSIS
\fBgrdcut\fP \fIinput_file.grd\fP \fB\-G\fP\fIoutput_file.grd\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-V\fP ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdcut\fP will produce a new \fIoutput_file.grd\fP file which is a subregion of \fIinput_file.grd\fP.
The subregion is specified with \fB\-R\fP\fIwest/east/south/north\fP as in other programs; the
specified range must not exceed the range of \fIinput_file.grd\fP. If in doubt, run \fBgrdinfo\fP
to check range. Complementary to \fBgrdcut\fP there is \fBgrdpaste\fP, which will join together two
grdfiles along a common edge.
.TP
\fIinput_file.grd\fP
this is the input \fI.grd\fP format file.
.TP
\fB\-G\fP\fIoutput_file.grd\fP
this is the output \fI.grd\fP format file.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
This defines the subregion to be cut out.
.SH OPTIONS
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
Suppose you have used \fBsurface\fP to grid ship gravity in the region between 148E - 162E and 8N - 32N, and you
do not trust the gridding near the edges, so you want to keep only the area between 150E - 160E and 10N - 30N, then:
.sp
\fBgrdcut\fP grav_148_162_8_32.grd \fB\-G\fPgrav_150_160_10_30.grd \fB\-R\fP150/160/10/30 \fB\-V\fP
.SH "SEE ALSO"
.IR grdpaste (l),
.IR grdinfo (l),
.IR gmt (l)
