.TH GRD2XYZ l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grd2xyz \- Converting grdfile(s) to ASCII or binary data
.SH SYNOPSIS
\fBgrd2xyz\fP \fIgrdfile(s)\fP [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-L\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-S\fP[\fBr\fP ] [ \fB\-V\fP ] [ \fB\-W\fP[\fIweight\fP] ] [ \fB\-Z\fP[\fIflags\fP] ] [ \fB\-bo\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrd2xyz\fP reads one or more binary 2-D grdfile and writes out xyz-triplets in ASCII [or binary] format to standard output.
Modify the
precision of the ASCII output format by editing the D_FORMAT parameter in your \.gmtdefaults4 file, or
choose binary output using single or double precision storage. As an option you may output
z-values without the (x,y) in a
number of formats, see \fB\-Z\fP below.
.TP
\fIgrdfile\fP
Names of 2-D binary grd files to be converted.
.SH OPTIONS
.TP
.B \-H
Output 1 header record based on information in the first grdfile header.
Ignored if binary output is selected. [Default is no header].
.TP
.B \-L
Indicates that the x values are longitudes (necessary for \fB\-:\fP to work).
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-S
Suppress output for nodes whose z-value equals NaN [Default outputs all nodes].
Append \fBr\fP to reverse the suppression, i.e., only output the nodes whose
z-value equals NaN.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Write out x,y,z,w, where w is the supplied \fIweight\fP (or 1 if not supplied) [Default writes x,y,z only].
.TP
.B \-Z
Write a 1-column ASCII [or binary] table. Output will be organized according to the specified ordering convention contained in \fIflags\fP.
If data should be written by rows, make \fIflags\fP start with \fBT\fP(op) if first row is y = ymax
or \fBB\fP(ottom) if first row is y = ymin. Then, append \fBL\fP or \fBR\fP to indicate that first element should start at left
or right end of row. Likewise for column formats: start with \fBL\fP or \fBR\fP to position first column,
and then append \fBT\fP or \fBB\fP to position first element in a row.
For gridline registered grids: If grid is periodic in x but the
outcoming data should not contain the (redundant) column at x = xmax, append \fBx\fP. For grid periodic in y,
skip writing the redundant row at y = ymax by appending \fBy\fP. If the byte-order needs to be swapped, append \fBw\fP. Select
one of several data types (all binary except \fBa\fP):
.br
.sp
        \fBa\fP ASCII representation
.br
        \fBc\fP signed 1-byte character
.br
        \fBu\fP unsigned 1-byte character
.br
        \fBh\fP short 2-byte integer
.br
        \fBi\fP 4-byte integer
.br
        \fBl\fP long (4- or 8-byte) integer
.br
        \fBf\fP 4-byte floating point single precision
.br
        \fBd\fP 8-byte floating point double precision
.br
.sp
Default format is scanline orientation of ASCII numbers: \fB\-ZTLa\fP.
Note that \fB\-Z\fP only applies to 1-column output.
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
This option only applies to xyz output; see \fB\-Z\fP for z table output.
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To edit individual values in the 5' by 5' hawaii_grv.grd file, dump the .grd
to ASCII:
.br
.sp
\fBgrd2xyz\fP hawaii_grv.grd > hawaii_grv.xyz
.br
.sp
To write a single precision binary file without the x,y positions from the file raw_data.grd file, using scanline orientation, run
.br
.sp
\fBgrd2xyz\fP raw_data.grd \fB\-ZTLf\fP > hawaii_grv.b
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR gmt (l),
.IR grdedit (l),
.IR xyz2grd (l)
