.TH GMTSELECT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
gmtselect \- Select data subsets based on multiple spatial criteria
.SH SYNOPSIS
\fBgmtselect\fP [ \fIinfiles\fP ] [ \fB\-A\fP\fImin_area\fP[/\fImin_level/max_level\fP] ]
[ \fB\-C\fP[\fBf\fP]\fIdist/ptfile\fP ] [ \fB\-D\fP\fIresolution\fP ] [ \fB\-F\fP\fIpolygonfile\fP ]
[ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP[\fBcflrs\fP] ] [ \fB\-J\fP\fIparameters\fP ]
[ \fB\-L\fP\fIdist/linefile\fP ] [ \fB\-M\fP[\fIflag\fP] ]
[ \fB\-N\fP\fImaskvalues\fP[\fBo\fP] ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ]
[ \fB\-V\fP ] [ \fB\-Z\fP\fImin/max\fP] ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
[ \fB\-bo\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgmtselect\fP is a filter that reads (longitude, latitude) positions from the first 2 columns of
\fIinfiles\fP [or standard input] and uses a combination of 1-6 criteria to pass or reject the records.
Records can be selected based on whether or not they are 1) inside a rectangular region (\fB\-R\fP
[and \fB\-J\fP]), 2) within \fIdist\fP km of any point in \fIptfile\fP, 3) within \fIdist\fP km of
any line in \fIlinefile\fP, 4) inside one of the polygons in the \fIpolygonfile\fP, 5) inside
geographical features (based on coastlines), or 6) has z-values within a given range.
The sense of the tests can be reversed for each of these 6 criteria by using the \fB\-I\fP option.
See option \fB\-:\fP on how to read (latitude,longitude) files.
.br
        No space between the option flag and the associated arguments. Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfiles\fP
ASCII (or binary, see\fB\-b\fP) data file(s) to be operated on. If not given, standard input is read.
.SH OPTIONS
.TP
.B \-A
Ignored unless \fB\-N\fP is set. Geographical features with an area smaller than \fImin_area\fP
in km^2 or of hierarchical level that is lower than \fImin_level\fP or higher than \fImax_level\fP
will be ignored [Default is 0/4 (all features)]. See DATABASE INFORMATION in the \fBpscoast\fP man-pages for more details.
.TP
.B \-C
Pass all records whose location is within \fIdist\fP of any of the points in the ASCII file \fIptfile\fP. If \fIdist\fP
is zero then the 3rd column of \fIptfile\fP must have each point's\"'
individual radius of influence. Distances are in user units; specify
\fB\-fg\fP or a map projection to indicate distances in km. Prepend \fBf\fP to indicate you want approximate flat
earth distance calculations (faster) rather than exact great circle calculations (slower).
.TP
.B \-D
Ignored unless \fB\-N\fP is set. Selects the resolution of the coastline data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, or (\fBc\fP)rude). The
resolution drops off by ~80% between data sets. [Default is \fBl\fP]. Note that because the coastlines differ in details it is not guaranteed that a point will remain inside [or outside] when a different resolution is selected.
.TP
.B \-F
Pass all records whose location is within one of the closed polygons in the multiple-segment
ASCII file \fIpolygonfile\fP.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Reverses the sense of the test for each of the criteria specified:
.br
        \fBc\fP select records NOT inside any point's circle of influence.\"'
.br
        \fBf\fP select records NOT inside any of the polygons.
.br
        \fBl\fP select records NOT within the specified distance of any line.
.br
        \fBr\fP select records NOT inside the specified rectangular region.
.br
        \fBs\fP select records NOT considered inside as specified by \fB\-A, \-D, \-N\fP.
.br
        \fBz\fP select records NOT within the range specified by \fB\-Z\fP.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-L
Pass all records whose location is within \fIdist\fP of any of the line segments in the multiple-segment ascii
file \fIlinefile\fP. If \fIdist\fP is zero then the 2nd column of each
sub-header in the \fIptfile\fP must have each lines's individual distance value.\"'
Distances are in user units; specify \fB\-fg\fP or a map projection to indicate distances in km.
.TP
.B \-M
Multiple segment file. Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Pass all records whose location is inside specified geographical features.
Specify if records should be skipped (s) or kept (k) using 1 of 2 formats:
.br
        \fB\-N\fP\fIwet/dry\fP.
.br
        \fB\-N\fP\fIocean/land/lake/island/pond\fP.
.br
Append \fBo\fP to let points exactly on feature boundaries be considered outside the feature [Default is inside]. [Default is s/k/s/k/s (i.e., s/k), which passes all points on dry land].
.TP
.B \-Z
Pass all records whose 3rd colum (z) lies within the given range. Input file must have at least
three columns. To indicate no limit on min or max, specify a hyphen (-).
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
If no map projection is supplied we implicitly set \fB\-Jx\fP1.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To extract the subset of data set that is within 300 km of any of the points in pts.d but more than
100 km away from the lines in lines.d, run
.br
.sp
\fBgmtselect\fP lonlatfile \fB\-Jd\fP1d \fB\-C\fP300/pts.d \fB\-L\fP100/lines.d \fB\-Il\fP > subset
.br
.sp
Here, you must specify a map projection so that knows you are giving it geographical data (otherwise
300 would be interpreted as Cartesian distance in x-y units instead of km).
.br
.sp
To keep all points in data.d within the specified region, except the points on land (as determined by the high-resolution
coastlines), use
.br
.sp
\fBgmtselect\fP data.d \fB\-R\fP120/121/22/24 \fB\-Dh\fP \fB\-Ns\fP/\fBk\fP > subset
.br
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR gmt (l),
.IR grdlandmask (l),
.IR pscoast (l)
