.TH GMT2RGB l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
gmt2rgb \- Converting a grdfile, a raw, or a Sun rasterfile to r/g/b grids
.SH SYNOPSIS
\fBgmt2rgb\fP \fIinfile\fP \fB\-G\fP\fItemplate\fP [ \fB\-C\fP\fIcptfile\fP ]
[ \fB\-F\fP ] [ \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]] ]
[ \fB\-L\fP\fIlayer\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgmt2rgb\fP reads one of three types of input files: (1) A Sun 8-, 24-, or 32-bit rasterfile; we the
write out the red, green, and blue components (0-255 range) to separate grid files. Since the rasterfile
header is limited you may use the \fB\-R, \-F, \-I\fP options to set a complete header record [Default is
simply based on the number of rows and columns]. (2) A binary 2-D grdfile; we then convert the z-values
to red, green, blue via the provided cpt file. Optionally, only write out one of the r, g, b, layers.
(3) A RGB or RGBA raw rasterfile. Since raw rastefiles have no header, you have to give the image
dimensions via the \fB\-W\fP option.
.TP
\fIinfile\fP
The (1) Sun rasterfile, (2) 2-D binary grdfile, or (3) raw rasterfile to be converted.
.TP
.B \-G
Provide an output name template for the three output grids. The template should be a regular gridfile name
except it must contain the string %c which on output will be replaced by r, g, or b.
.SH OPTIONS
.TP
.B \-C
name of the color palette table (for 2-D binary input grid only).
.TP
.B \-F
 Will force pixel registration [Default is grid registration].
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-L
Output only the specified layer (r, g, or b). [Default outputs all 3 layers].
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Sets the size of the raw raster file. By default an RGB file (which has 3 bytes/pixel) is assumed.
For RGBA files use \fIn_bytes\fP = 4. Use \fB\-W\fP for guessing the image size of a RGB raw file,
and \fB\-W\fP\fI=/=/4\fP if the raw image is of the RGBA type. Notice that this might be a bit slow
because the guessing algorithm makes uses of FFTs.
.SH EXAMPLES
To use the color palette topo.cpt to create r, g, b component grids from hawaii_grv.grd file, use
.br
.sp
\fBgmt2rgb\fP hawaii_grv.grd \fB\-C\fPtopo.cpt \fB\-G\fPhawaii_grv_%c.grd
.br
.sp
To output the red component from the Sun raster radiation.ras file, use
.br
.sp
\fBgmt2rgb\fP radiation.ras \fB\-L\fPr \fB\-G\fPcomp_%c.grd
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR gmt (l),
.IR grdedit (l),
.IR grdimage (l),
.IR grdmath (l),
.IR grdview (l)
