.TH BLOCKMEDIAN l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
blockmedian \- filter to block average (x,y,z) data by L1 norm.
.SH SYNOPSIS
\fBblockmedian\fP [ \fIxyz[w]file(s)\fP ] \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]]
\fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-C\fP ] [ \fB\-F\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-Q\fP ] [ \fB\-V\fP ]
[ \fB\-W\fP[\fBio\fP] ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBblockmedian\fP reads arbitrarily located (x,y,z) triples [or optionally weighted
quadruples (x,y,z,w)] from standard input [or \fIxyz[w]file(s)\fP] and writes to standard output a median position and
value for every non-empty block in a grid region defined by the \fB\-R\fP and \fB\-I\fP arguments.
Either \fBblockmean\fP, \fBblockmedian\fP, or \fBblockmode\fP should be used as a pre-processor before running \fBsurface\fP to avoid
aliasing short wavelengths. These routines are also generally useful for decimating or averaging
(x,y,z) data. You can modify the
precision of the output format by editing the D_FORMAT parameter in your .gmtdefaults4 file, or
you may choose binary input and/or output using single or double precision storage.
.TP
\fIxyz[w]file(s)\fP
3 [or 4] column ASCII file(s) [or binary, see \fB\-b\fP] holding (x,y,z[,w]) data values. [w] is an optional weight for the data.
If no file is specified, \fBblockmedian\fP will read from standard input.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.SH OPTIONS
.sp
.TP
.B \-C
Use the center of the block as the output location [Default uses the median location (but see \fB\-Q\fP)].
\fB\-C\fP overrides \fB\-Q\fP.
.TP
.B \-F
Block centers have pixel registration. [Default: grid registration.] (Registrations are defined in
GMT Cookbook Appendix B on grid file formats.) Each block is the locus of points nearest the grid value
location. For example, with \fB\-R\fP10/15/10/15 and and \fB\-I\fP1: with the \fB\-F\fP option 10 <=
(x,y) < 11 is one of 25 blocks; without it 9.5 <= (x,y) < 10.5 is one of 36 blocks.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-Q
(Quicker) Finds median z and (x, y) at that z [Default finds median x, median y, median z].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Weighted modifier[s]. Unweighted input and output has 3 columns x,y,z; Weighted i/o has 4 columns x,y,z,w.
Weights can be used in input to construct weighted median values in blocks. Weight sums can be reported in
output for later combining several runs, etc. Use \fB\-W\fP for weighted i/o, \fB\-Wi\fP for weighted input
only, \fB\-Wo\fP for weighted output only. [Default uses unweighted i/o].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 3 (or 4 if \fB\-W\fP is set) columns].
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To find 5 by 5 minute block medians from the double precision binary data in hawaii_b.xyg and output an ASCII table, run
.sp
\fBblockmedian\fP hawaii_b.xyg \fB\-R\fP198/208/18/25 \fB\-I\fP5\fBm \-bi\fP3 > hawaii_5x5.xyg
.SH "SEE ALSO"
.IR blockmean (l),
.IR blockmode (l),
.IR gmt (l),
.IR gmtdefaults (l),
.IR nearneighbor (l),
.IR surface (l),
.IR triangulate (l)
