/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.internal.graph.CompoundBreakCycles;
import org.eclipse.draw2d.internal.graph.CompoundHorizontalPlacement;
import org.eclipse.draw2d.internal.graph.CompoundPopulateRanks;
import org.eclipse.draw2d.internal.graph.CompoundRankSorter;
import org.eclipse.draw2d.internal.graph.CompoundVerticalPlacement;
import org.eclipse.draw2d.internal.graph.ConvertCompoundGraph;
import org.eclipse.draw2d.internal.graph.GraphVisitor;
import org.eclipse.draw2d.internal.graph.InitialRankSolver;
import org.eclipse.draw2d.internal.graph.MinCross;
import org.eclipse.draw2d.internal.graph.PlaceEndpoints;
import org.eclipse.draw2d.internal.graph.RankAssigmentSolver;
import org.eclipse.draw2d.internal.graph.SortSubgraphs;
import org.eclipse.draw2d.internal.graph.TightSpanningTreeSolver;

public final class CompoundDirectedGraphLayout
extends GraphVisitor {
    List steps = new ArrayList();

    public CompoundDirectedGraphLayout() {
        this.steps.add(new CompoundBreakCycles());
        this.steps.add(new ConvertCompoundGraph());
        this.steps.add(new InitialRankSolver());
        this.steps.add(new TightSpanningTreeSolver());
        this.steps.add(new RankAssigmentSolver());
        this.steps.add(new CompoundPopulateRanks());
        this.steps.add(new CompoundVerticalPlacement());
        this.steps.add(new MinCross(new CompoundRankSorter()));
        this.steps.add(new SortSubgraphs());
        this.steps.add(new CompoundHorizontalPlacement());
        this.steps.add(new PlaceEndpoints());
    }

    public void visit(DirectedGraph graph) {
        GraphVisitor visitor;
        int i = 0;
        while (i < this.steps.size()) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.visit(graph);
            ++i;
        }
        i = this.steps.size() - 1;
        while (i >= 0) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.revisit(graph);
            --i;
        }
    }
}

