% ACOSH ACOSH Inverse Hyperbolic Cosine Function
% 
% Usage
% 
% Computes the inverse hyperbolic cosine of its argument.  The general
% syntax for its use is
% 
%   y = acosh(x)
% 
% where x is an n-dimensional array of numerical type.

function y = acosh(x)
  if (nargin == 0 || ~isnumeric(x))
    error('acosh expects a single, numeric input');
  end
  y = log(x+(x.*x-1).^(0.5f));
  
