/*
 * Copyright (c) 2002-2006 Samit Basu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __Module_hpp__
#define __Module_hpp__

#include "Scope.hpp"
class Context;

/**
 * Load a function dynamically.  Throws an Exception if 
 * there are not at least two arguments to the function,
 * if the file could not be found, or if the requested
 * symbol is not present.
 */
ArrayVector LoadLibFunction(int nargout,const ArrayVector& arg,
			    Interpreter* eval) throw(Exception);
/**
 * import a C function 
 */
ArrayVector ImportFunction(int nargout, const ArrayVector& arg, 
			   Interpreter* eval) throw(Exception);
/**
 *  Add the loadlib and import functions to the given context.
 */
void LoadModuleFunctions(Context* context);

/**
 * Clear all the loaded libraries
 */
void ClearLibs(Interpreter* eval);

#endif
