% ACSC  ACSC Inverse Cosecant Function
% 
% 
% Usage
%  
%  Computes the inverse cosecant of its argument.  The general
%  syntax for its use is
%  
%    y = acsc(x)
%  
%  where x is an n-dimensional array of numerical type.
%  


function y = acsc(x)
  if (nargin == 0 || ~isnumeric(x))
    error('acsc expects a single, numeric input');
  end
  y = asin(1.f./x);
  
