/*
 * Copyright (c) 2002-2006 Samit Basu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __Reserved_hpp__
#define __Reserved_hpp__

#include "Parser.h"

namespace FreeMat {

  /**
   * These keywords must be in alphabetical order.
   */
  const unsigned int FM_BREAK = 0;
  const unsigned int FM_CASE = 1;
  const unsigned int FM_CATCH = 2;
  const unsigned int FM_CONTINUE = 3;
  const unsigned int FM_ELSE = 4;
  const unsigned int FM_ELSEIF = 5;
  const unsigned int FM_END = 6;
  const unsigned int FM_FOR = 7;
  const unsigned int FM_FUNCTION = 8;
  const unsigned int FM_GLOBAL = 9;
  const unsigned int FM_IF = 10;
  const unsigned int FM_KEYBOARD = 11;
  const unsigned int FM_OTHERWISE = 12;
  const unsigned int FM_PERSISTENT = 13;
  const unsigned int FM_QUIT = 14;
  const unsigned int FM_RETALL = 15;
  const unsigned int FM_RETURN = 16;
  const unsigned int FM_SWITCH = 17;
  const unsigned int FM_TRY = 18;
  const unsigned int FM_WHILE = 19;

  /**
   * Each reserved word structure has three attributes,
   * the text of the reserved word, the token for the word,
   * as generated by the parser, and the ordinal (from above).
   */
  typedef struct {
    char *word;
    int  token;
    int  ordinal;
  } reservedWordStruct;

#define RESWORDCOUNT 20
  extern reservedWordStruct reservedWord[RESWORDCOUNT];

  /**
   * A comparison function for the reservedWord list of 
   * structures, so that the binary search algorithm used
   * on the reservedWordStruct list works properly.
   */
  int compareReservedWord(const void*, const void*);
}
#endif
