# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..5\n"; }
END {print "not ok 1\n" unless $loaded;}
use Finance::QuoteHist;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$pcount = 2;

{
  local $/;
  my @chunks = split(/\n\n+/, <DATA>);
  @quotes    = split(/\n/, $chunks[0]);
  @splits    = split(/\n/, $chunks[1]);
  @dividends = split(/\n/, $chunks[2]);
}

($qsym, $qstart, $qend) = split(',', shift @quotes);
($ssym, $sstart, $send) = split(',', shift @splits);
($dsym, $dstart, $dend) = split(',', shift @dividends);

$ok = 1;
$q = Finance::QuoteHist->new(
			     symbols    => $qsym,
			     start_date => $qstart,
			     end_date   => $qend,
			    );
@rows = $q->quotes;
$ok = 0 unless $#quotes == $#rows;
foreach (0 .. $#rows) {
   if (join(':', @{$rows[$_]}) ne $quotes[$_]) {
     $ok = 0;
     last;
   }
}
print $ok ? "ok" : "not ok";
print " $pcount (direct quotes)\n";
++$pcount;

$ok = 1;
$q = Finance::QuoteHist->new(
			     symbols    => $ssym,
			     start_date => $sstart,
			     end_date   => $send,
			    );
@rows = $q->splits;
$ok = 0 unless $#splits == $#rows;
foreach (0 .. $#rows) {
  if (join(':', @{$rows[$_]}) ne $splits[$_]) {
    $ok = 0;
    last;
  }
}
print $ok ? "ok" : "not ok";
print " $pcount (filtered splits)\n";
++$pcount;

# Use the same quote object here to test filtered divs.
$ok = 1;
@rows = $q->dividends;
$ok = 0 unless $#dividends == $#rows;
foreach (0 .. $#rows) {
  if (join(':', @{$rows[$_]}) ne $dividends[$_]) {
    $ok = 0;
    last;
  }
}
print $ok ? "ok" : "not ok";
print " $pcount (filtered dividends)\n";
++$pcount;

$ok = 1;
$q = Finance::QuoteHist->new(
			     symbols    => $dsym,
			     start_date => $dstart,
			     end_date   => $dend,
			    );
@rows = $q->dividends;
$ok = 0 unless $#dividends == $#rows;
foreach (0 .. $#rows) {
  if (join(':', @{$rows[$_]}) ne $dividends[$_]) {
    $ok = 0;
    last;
  }
}
print $ok ? "ok" : "not ok";
print " $pcount (direct dividends)\n";
++$pcount;

__END__
^DJA,11/01/1997,02/28/1998
^DJA:1997/11/03:2471.1000:2521.1000:2461.2000:2509.0000:5647400
^DJA:1997/11/04:2504.8000:2530.4000:2478.2000:2510.8000:5415900
^DJA:1997/11/05:2512.3000:2541.4000:2489.6000:2512.4000:5656800
^DJA:1997/11/06:2507.0000:2530.4000:2481.8000:2508.9000:5228900
^DJA:1997/11/07:2472.8000:2501.3000:2446.0000:2483.0000:5699800
^DJA:1997/11/10:2496.5000:2511.8000:2455.6000:2469.7000:4641400
^DJA:1997/11/11:2474.2000:2497.8000:2452.8000:2474.6000:4356600
^DJA:1997/11/12:2455.3000:2480.5000:2417.7000:2430.7000:5853400
^DJA:1997/11/13:2441.4000:2466.9000:2401.0000:2441.3000:6539600
^DJA:1997/11/14:2449.1000:2488.0000:2425.6000:2468.3000:6357600
^DJA:1997/11/17:2490.1000:2532.7000:2476.2000:2508.6000:5765400
^DJA:1997/11/18:2511.7000:2527.9000:2473.5000:2487.7000:5213800
^DJA:1997/11/19:2484.3000:2520.1000:2465.4000:2500.6000:5427200
^DJA:1997/11/20:2513.9000:2561.8000:2501.9000:2544.3000:6026100
^DJA:1997/11/21:2551.8000:2577.2000:2520.6000:2559.0000:6110000
^DJA:1997/11/24:2546.1000:2564.4000:2510.2000:2527.9000:5149200
^DJA:1997/11/25:2540.2000:2568.7000:2511.9000:2542.8000:5878900
^DJA:1997/11/26:2550.7000:2573.8000:2527.9000:2546.5000:4877500
^DJA:1997/11/28:2552.6000:2570.5000:2542.7000:2555.6000:1890700
^DJA:1997/12/01:2568.5000:2625.9000:2554.7000:2612.7000:5903000
^DJA:1997/12/02:2610.2000:2640.1000:2588.4000:2612.5000:5761200
^DJA:1997/12/03:2613.5000:2640.5000:2576.6000:2613.8000:6246100
^DJA:1997/12/04:2621.4000:2654.3000:2596.3000:2620.3000:6334700
^DJA:1997/12/05:2609.5000:2660.8000:2597.5000:2641.1000:5635900
^DJA:1997/12/08:2642.5000:2669.3000:2618.9000:2643.4000:4903200
^DJA:1997/12/09:2636.9000:2655.3000:2607.7000:2631.1000:5391300
^DJA:1997/12/10:2620.6000:2642.5000:2587.0000:2618.3000:6022900
^DJA:1997/12/11:2595.3000:2614.5000:2542.2000:2571.7000:6317700
^DJA:1997/12/12:2584.2000:2612.3000:2545.0000:2571.7000:5792800
^DJA:1997/12/15:2583.9000:2621.7000:2563.5000:2598.8000:5971500
^DJA:1997/12/16:2608.2000:2638.2000:2580.4000:2604.4000:6233200
^DJA:1997/12/17:2614.3000:2637.1000:2576.3000:2599.2000:6189000
^DJA:1997/12/18:2598.6000:2612.3000:2542.4000:2563.8000:6188700
^DJA:1997/12/19:2545.5000:2572.1000:2478.3000:2539.9000:7932000
^DJA:1997/12/22:2549.4000:2583.9000:2521.6000:2557.2000:5306700
^DJA:1997/12/23:2557.2000:2577.4000:2515.4000:2529.9000:5150700
^DJA:1997/12/24:2538.3000:2549.8000:2505.6000:2517.8000:2659800
^DJA:1997/12/26:2519.8000:2541.1000:2508.0000:2520.9000:1549000
^DJA:1997/12/29:2536.3000:2565.2000:2522.0000:2548.0000:4431600
^DJA:1997/12/30:2557.8000:2612.0000:2545.6000:2597.3000:4995000
^DJA:1997/12/31:2598.2000:2632.2000:2576.3000:2607.4000:4672800
^DJA:1998/01/02:2610.8000:2630.6000:2579.5000:2611.2000:3667300
^DJA:1998/01/05:2619.3000:2646.0000:2581.3000:2613.8000:6280700
^DJA:1998/01/06:2600.7000:2631.3000:2572.0000:2600.8000:6183600
^DJA:1998/01/07:2588.8000:2624.3000:2556.3000:2609.0000:6673900
^DJA:1998/01/08:2600.1000:2626.5000:2559.3000:2584.8000:6521400
^DJA:1998/01/09:2581.7000:2595.1000:2499.1000:2518.4000:7464200
^DJA:1998/01/12:2476.1000:2561.9000:2464.4000:2544.2000:7054500
^DJA:1998/01/13:2551.7000:2583.0000:2529.7000:2565.4000:6467400
^DJA:1998/01/14:2571.0000:2587.4000:2536.9000:2568.5000:6032800
^DJA:1998/01/15:2562.7000:2583.5000:2532.6000:2549.3000:5690500
^DJA:1998/01/16:2571.8000:2604.9000:2549.0000:2575.1000:6700800
^DJA:1998/01/20:2583.2000:2630.3000:2565.3000:2617.1000:6447900
^DJA:1998/01/21:2604.2000:2632.9000:2567.1000:2597.6000:6261600
^DJA:1998/01/22:2582.2000:2619.4000:2551.8000:2580.6000:6465700
^DJA:1998/01/23:2588.3000:2604.8000:2530.3000:2556.9000:6357700
^DJA:1998/01/26:2564.9000:2594.2000:2534.7000:2557.8000:5550800
^DJA:1998/01/27:2556.6000:2598.2000:2533.1000:2570.5000:6791400
^DJA:1998/01/28:2581.4000:2629.1000:2559.7000:2608.2000:7084700
^DJA:1998/01/29:2608.2000:2654.4000:2589.0000:2625.0000:7507600
^DJA:1998/01/30:2622.2000:2641.1000:2587.9000:2604.8000:6133800
^DJA:1998/02/02:2639.0000:2673.9000:2620.5000:2654.8000:7243200
^DJA:1998/02/03:2647.3000:2682.1000:2629.8000:2670.1000:6921200
^DJA:1998/02/04:2660.5000:2688.7000:2635.8000:2664.4000:6954200
^DJA:1998/02/05:2664.1000:2695.0000:2636.5000:2661.5000:7039800
^DJA:1998/02/06:2677.5000:2704.7000:2655.2000:2684.8000:5696500
^DJA:1998/02/09:2688.8000:2715.9000:2662.5000:2694.8000:5248100
^DJA:1998/02/10:2714.3000:2746.2000:2681.6000:2723.6000:6428000
^DJA:1998/02/11:2723.3000:2748.3000:2701.2000:2727.6000:5993000
^DJA:1998/02/12:2720.8000:2776.1000:2699.7000:2760.2000:6114800
^DJA:1998/02/13:2755.2000:2781.7000:2723.4000:2750.6000:5319400
^DJA:1998/02/17:2773.7000:2791.0000:2739.0000:2764.2000:6058900
^DJA:1998/02/18:2764.7000:2792.7000:2734.8000:2765.8000:6060000
^DJA:1998/02/19:2746.2000:2775.1000:2725.8000:2743.1000:5818200
^DJA:1998/02/20:2728.7000:2761.6000:2701.1000:2740.4000:5943000
^DJA:1998/02/23:2738.5000:2774.9000:2721.0000:2748.3000:5507300
^DJA:1998/02/24:2726.6000:2759.7000:2701.8000:2721.9000:5898800
^DJA:1998/02/25:2745.6000:2766.4000:2714.0000:2745.1000:6113500
^DJA:1998/02/26:2744.5000:2768.2000:2708.5000:2743.9000:6462800
^DJA:1998/02/27:2745.1000:2772.2000:2715.8000:2746.3000:5744800

INTC,01/01/1997,01/01/1998
INTC:1997/07/14:2:1

INTC,01/01/1997,01/01/1998
INTC:1997/01/29:0.050000
INTC:1997/04/29:0.050000
INTC:1997/07/30:0.030000
INTC:1997/10/29:0.030000
