#!/usr/bin/perl -w

require 5.001;
use Date::Manip;
@Date::Manip::TestArgs=();
$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
} elsif ( -f "test.pl" ) {
  require "test.pl";
} else {
  die "ERROR: cannot find test.pl\n";
}
$ntest=16;

print "1..$ntest\n"  if (! $runtests);
Date_Init(@Date::Manip::TestArgs,"ForceDate=1997-03-08-12:30:00");

$dates="

   1977 16:00:00
    1977062716:00:00

04.12.1999
    1999120400:00:00

2  2012
    2012050200:00:00

2  2012
    2012050200:00:00

31/12/2000
    2000123100:00:00

3  1975
    1975090300:00:00

27  2001
    2001102700:00:00

  1980
    1980090100:00:00

 20, 1999
    1999122000:00:00

20  1987 12:32:20
    1987072012:32:20

23:37:20   1987
    1987060123:37:20

20/12/01 17:27:08
    2001122017:27:08

20/12/01  17:27:08
    2001122017:27:08

20/12/01  17270800
    2001122017:27:08

17:27:08 20/12/01
    2001122017:27:08

4  1975 400 
    1975100416:00:00
";

print "Date (Russian)...\n";
Date_Init("Language=Russian","DateFormat=non-US","Internal=0");
test_Func($ntest,\&ParseDate,$dates,$runtests);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:

