/////////////////////////////////////////////////////////////////////////////
// Name:        TitlePropDlg.h
// Purpose:     DVD title properties dialog
// Author:      Alex Thuering
// Created:     31.01.2004
// RCS-ID:      $Id: TitlePropDlg.h,v 1.6 2008/05/18 19:17:02 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef TITLE_PROP_DLG_H
#define TITLE_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

class TitlePropDlg: public wxPropDlg {
public:
	TitlePropDlg(wxWindow *parent, DVD* dvd, Audio* audio, Video* video,
			Pgc* pgc, Vob* vob);
	virtual ~TitlePropDlg() {}
	
private:
	DVD* m_dvd;
	Audio* m_audio;
	Video* m_video;
	Pgc* m_pgc;
	Vob* m_vob;
	int m_formatCtrlIdx;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	void CreateButtonPane(wxSizer* sizer, bool resetButton = false);
	void OnAV(wxCommandEvent& event);
	void OnDoNotTranscodeCheck(wxCommandEvent& event);
	DECLARE_EVENT_TABLE()
};

#endif // TITLE_PROP_DLG_H
