/////////////////////////////////////////////////////////////////////////////
// Name:        DonateDlg.cpp
// Purpose:     Donate dialog
// Author:      Alex Thuering
// Created:     20.04.2008
// RCS-ID:      $Id: DonateDlg.cpp,v 1.2 2008/04/21 20:20:13 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "DonateDlg.h"
#include "hyperlink.h"
#include "Config.h"
#include <wxVillaLib/utils.h>
#include <wx/statline.h>

#define DONATE_URL wxT("http://www.dvdstyler.de/donate.html")

DonateDlg::DonateDlg(wxWindow* parent) : wxPropDlg(parent) {
	SetTitle(_("DVDStyler Registration"));
	Create(false);
	SetSize(400, -1);
}

void DonateDlg::CreatePropPanel(wxSizer* sizer) {
	AddText(sizer, _("Development and maintaining DVDStyer requires a considerable"));
	sizer->Add(0, 6);
	AddText(sizer, _("amount of work and effort. Please make a donation to support"));
	sizer->Add(0, 6);
	AddText(sizer, _("continued development of DVDStyler!"));
	sizer->Add(0, 6);
	myHyperLink* website = new myHyperLink(this, -1, DONATE_URL);
	website->SetURL(DONATE_URL);
	sizer->Add(website, 0, wxALIGN_CENTER);

	wxFlexGridSizer* grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
	grid->AddGrowableCol(1);
	sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
	AddCheckProp(grid, _("Do not show this message again"), false);
}

void DonateDlg::CreateButtonPane(wxSizer* sizer, bool resetButton) {
	wxBoxSizer* buttonPane = new wxBoxSizer(wxHORIZONTAL);
	buttonPane->Add(10, 10, 1, wxEXPAND);
	wxButton* okBt = new wxButton(this, wxID_OK, _("OK"));
	okBt->SetDefault();
	buttonPane->Add(okBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
	buttonPane->Add(10, 10, 1, wxEXPAND);
	sizer->Add(buttonPane, 0, wxEXPAND|wxLEFT|wxRIGHT|wxBOTTOM, 10);
}

bool DonateDlg::SetValues() {
	if (GetBool(0))
		s_config.SetKey(-25);
	return true;
}

int DonateDlg::ShowModal() {
	if (s_config.GetKey() < 4)
		return wxID_OK;
	return wxPropDlg::ShowModal();
}
