/////////////////////////////////////////////////////////////////////////////
// Name:        MenuPropDlg.h
// Purpose:     DVD menu properties dialog
// Author:      Alex Thuering
// Created:     25.04.2004
// RCS-ID:      $Id: MenuPropDlg.h,v 1.5 2008/03/31 17:56:02 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef MENU_PROP_DLG_H
#define MENU_PROP_DLG_H

#include <wx/wx.h>
#include <wx/spinctrl.h>
#include <wx/combobox.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"
#include "Menu.h"

class MenuPropDlg: public wxPropDlg {
  public:
    MenuPropDlg(wxWindow *parent, DVD* dvd, int tsi, int pgci);
	virtual ~MenuPropDlg() {}
	
  protected:
	void CreatePropPanel(wxSizer* sizer);
  	bool SetValues();
  	void CreateButtonPane(wxSizer* sizer, bool resetButton = false);
  	
  private:
	DVD* m_dvd;
	Audio* m_audio;
	Video* m_video;
	int m_tsi;
	int m_pgci;
    Pgc* m_pgc;
	Vob* m_vob;
	Menu* m_menu;
	wxSpinCtrl* m_pauseCtrl;
	wxComboBox* m_postCommandsCtrl;
	void OnAV(wxCommandEvent& event);
	void OnLoopCheck(wxCommandEvent& event);
	wxArrayString GetCommands();
    DECLARE_EVENT_TABLE()
};

#endif // MENU_PROP_DLG_H
